/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.storage.columnar;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.tuple.IEvaluatableTuple;
import org.apache.kylin.shaded.com.google.common.collect.Iterators;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.stream.core.query.HavingFilterChecker;
import org.apache.kylin.stream.core.query.IStreamingSearchResult;
import org.apache.kylin.stream.core.query.ResponseResultSchema;
import org.apache.kylin.stream.core.query.StreamingQueryProfile;
import org.apache.kylin.stream.core.storage.Record;
import org.apache.kylin.stream.core.storage.columnar.ColumnarRecordCodec;
import org.apache.kylin.stream.core.storage.columnar.DataSegmentFragment;
import org.apache.kylin.stream.core.storage.columnar.FragmentCuboidReader;
import org.apache.kylin.stream.core.storage.columnar.FragmentData;
import org.apache.kylin.stream.core.storage.columnar.RawRecord;
import org.apache.kylin.stream.core.storage.columnar.invertindex.IndexSearchResult;
import org.apache.kylin.stream.core.storage.columnar.invertindex.InvertIndexSearcher;
import org.apache.kylin.stream.core.storage.columnar.protocol.CuboidMetaInfo;
import org.apache.kylin.stream.core.util.StreamFilterUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentSearchResult
implements IStreamingSearchResult {
    private static Logger logger = LoggerFactory.getLogger(FragmentSearchResult.class);
    private TupleFilter filter;
    private InvertIndexSearcher iiSearcher;
    private DataSegmentFragment fragment;
    private ResponseResultSchema responseSchema;
    private ColumnarRecordCodec recordCodec;
    private Set<TblColRef> groups;
    private TupleFilter havingFilter;
    private FragmentCuboidReader fragmentCuboidReader;
    private StreamingQueryProfile queryProfile;
    private int filterRowCnt = 0;
    private int finalRowCnt = 0;

    public FragmentSearchResult(DataSegmentFragment fragment, FragmentData fragmentData, CuboidMetaInfo cuboidMetaInfo, ResponseResultSchema responseSchema, TupleFilter filter, Set<TblColRef> groups, TupleFilter havingFilter, ColumnarRecordCodec recordCodec) throws IOException {
        this.fragment = fragment;
        this.filter = filter;
        this.responseSchema = responseSchema;
        this.groups = groups;
        this.havingFilter = havingFilter;
        TblColRef[] dimensions = responseSchema.getDimensions();
        ByteBuffer readBuffer = fragmentData.getDataReadBuffer();
        this.iiSearcher = new InvertIndexSearcher(cuboidMetaInfo, dimensions, readBuffer.asReadOnlyBuffer());
        CubeDesc cubeDesc = responseSchema.getCubeDesc();
        this.recordCodec = recordCodec;
        this.fragmentCuboidReader = new FragmentCuboidReader(cubeDesc, fragmentData, cuboidMetaInfo, dimensions, responseSchema.getMeasureDescs(), recordCodec.getDimensionEncodings());
        this.queryProfile = StreamingQueryProfile.get();
    }

    @Override
    public Iterator<Record> iterator() {
        Iterator<RawRecord> sourceRecords = this.searchFragment();
        FilteredAndAggregatedRecords filterAggrRecords = new FilteredAndAggregatedRecords(sourceRecords, this.responseSchema, this.recordCodec, this.filter, this.groups, this.havingFilter);
        return filterAggrRecords.iterator();
    }

    private Iterator<RawRecord> searchFragment() {
        Iterator<RawRecord> result;
        IndexSearchResult indexSearchResult = this.searchFromIndex();
        if (indexSearchResult == null || indexSearchResult.needFullScan()) {
            result = this.fragmentCuboidReader.iterator();
            this.queryProfile.addStepInfo(this.getFragmentDataScanStep(), "use_index", "false");
        } else {
            this.queryProfile.addStepInfo(this.getFragmentDataScanStep(), "use_index", "true");
            if (indexSearchResult.rows == null) {
                if (this.queryProfile.isDetailProfileEnable()) {
                    logger.info("query-{}: no data match the query in the file segment-{}_fragment-{}", this.queryProfile.getQueryId(), this.fragment.getSegmentName(), this.fragment.getFragmentId());
                }
                return Collections.emptyIterator();
            }
            final Iterator<Integer> rows = indexSearchResult.rows;
            result = new Iterator<RawRecord>(){

                @Override
                public boolean hasNext() {
                    return rows.hasNext();
                }

                @Override
                public RawRecord next() {
                    return FragmentSearchResult.this.fragmentCuboidReader.read((Integer)rows.next() - 1);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return result;
    }

    private IndexSearchResult searchFromIndex() {
        if (this.queryProfile.isDetailProfileEnable()) {
            this.queryProfile.startStep(this.getFragmentIdxSearchStep());
        }
        IndexSearchResult result = this.iiSearcher.search(this.filter);
        if (this.queryProfile.isDetailProfileEnable()) {
            this.queryProfile.finishStep(this.getFragmentIdxSearchStep());
        }
        return result;
    }

    private String getFragmentIdxSearchStep() {
        return String.format(Locale.ROOT, "segment-%s_fragment-%s_idx_search", this.fragment.getSegmentName(), this.fragment.getFragmentId());
    }

    private String getFragmentDataScanStep() {
        return String.format(Locale.ROOT, "segment-%s_fragment-%s_data_scan", this.fragment.getSegmentName(), this.fragment.getFragmentId());
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void startRead() {
        if (this.queryProfile.isDetailProfileEnable()) {
            String stepName = this.getFragmentDataScanStep();
            this.queryProfile.startStep(stepName);
            logger.info("query-{}: start to search segment-{}_fragment-{} file", this.queryProfile.getQueryId(), this.fragment.getSegmentName(), this.fragment.getFragmentId());
        }
    }

    @Override
    public void endRead() {
        long scanRowCnt = this.fragmentCuboidReader.getReadRowCount();
        this.queryProfile.incScanRows(scanRowCnt);
        this.queryProfile.incFilterRows(this.filterRowCnt);
        if (this.queryProfile.isDetailProfileEnable()) {
            String stepName = this.getFragmentDataScanStep();
            StreamingQueryProfile.ProfileStep profileStep = this.queryProfile.finishStep(stepName).stepInfo("row_count", String.valueOf(this.fragmentCuboidReader.getReadRowCount()));
            logger.info("query-{}: segment-{}_fragment-{} scan finished, scan {} rows, filter {} rows, return {} rows, take {} ms", this.queryProfile.getQueryId(), this.fragment.getSegmentName(), this.fragment.getFragmentId(), scanRowCnt, this.filterRowCnt, this.finalRowCnt, profileStep.getDuration());
        }
    }

    static interface AggregationCache
    extends Closeable {
        public boolean aggregate(RawRecord var1);

        public Iterator<Record> iterator();
    }

    public class FilteredAndAggregatedRecords
    implements Iterable<Record> {
        private TupleFilter filter;
        private TupleFilter havingFilter;
        private Iterator<RawRecord> sourceRecords;
        private AggregationCache aggrCache;
        private ResponseResultSchema schema;
        private int[] groupIndexes;
        private ColumnarRecordCodec recordDecoder;
        private int pushDownLimit = Integer.MAX_VALUE;
        RawRecord next;
        final IEvaluatableTuple oneTuple = new IEvaluatableTuple(){

            @Override
            public Object getValue(TblColRef col) {
                return new ByteArray(FilteredAndAggregatedRecords.this.next.getDimensions()[FilteredAndAggregatedRecords.this.schema.getIndexOfDimension(col)]);
            }
        };
        final IFilterCodeSystem<ByteArray> filterCodeSystem = StreamFilterUtil.getStreamingFilterCodeSystem();

        public FilteredAndAggregatedRecords(Iterator<RawRecord> sourceRecords, ResponseResultSchema schema, ColumnarRecordCodec recordDecoder, TupleFilter filter, Set<TblColRef> groups, TupleFilter havingFilter) {
            this.sourceRecords = sourceRecords;
            this.schema = schema;
            this.recordDecoder = recordDecoder;
            this.filter = filter;
            this.havingFilter = havingFilter;
            this.groupIndexes = new int[groups.size()];
            int i = 0;
            for (TblColRef group : groups) {
                this.groupIndexes[i] = schema.getIndexOfDimension(group);
                ++i;
            }
            this.aggrCache = this.groupIndexes.length == 0 ? new OneValueAggregationCache() : new TreeMapAggregationCache();
        }

        @Override
        public Iterator<Record> iterator() {
            if (this.hasAggregation()) {
                while (this.sourceRecords.hasNext()) {
                    RawRecord rawRecord = this.sourceRecords.next();
                    if (this.filter != null && !this.satisfyFilter(rawRecord)) {
                        FragmentSearchResult.this.filterRowCnt++;
                        continue;
                    }
                    this.aggrCache.aggregate(rawRecord);
                }
                return this.aggrCache.iterator();
            }
            return this.transformAndFilterRecords();
        }

        private Iterator<Record> transformAndFilterRecords() {
            return new Iterator<Record>(){
                Record oneRecord;
                {
                    this.oneRecord = new Record(FilteredAndAggregatedRecords.this.schema.getDimensionCount(), FilteredAndAggregatedRecords.this.schema.getMetricsCount());
                }

                @Override
                public boolean hasNext() {
                    if (FilteredAndAggregatedRecords.this.next != null) {
                        return true;
                    }
                    while (FilteredAndAggregatedRecords.this.sourceRecords.hasNext()) {
                        FilteredAndAggregatedRecords.this.next = (RawRecord)FilteredAndAggregatedRecords.this.sourceRecords.next();
                        if (FilteredAndAggregatedRecords.this.filter != null && !this.evaluateFilter()) {
                            FragmentSearchResult.this.filterRowCnt++;
                            continue;
                        }
                        return true;
                    }
                    FilteredAndAggregatedRecords.this.next = null;
                    return false;
                }

                private boolean evaluateFilter() {
                    return FilteredAndAggregatedRecords.this.filter.evaluate(FilteredAndAggregatedRecords.this.oneTuple, FilteredAndAggregatedRecords.this.filterCodeSystem);
                }

                @Override
                public Record next() {
                    if (FilteredAndAggregatedRecords.this.next == null) {
                        this.hasNext();
                        if (FilteredAndAggregatedRecords.this.next == null) {
                            throw new NoSuchElementException();
                        }
                    }
                    byte[][] rawDimVals = FilteredAndAggregatedRecords.this.next.getDimensions();
                    for (int i = 0; i < rawDimVals.length; ++i) {
                        this.oneRecord.setDimension(i, FilteredAndAggregatedRecords.this.recordDecoder.decodeDimension(i, rawDimVals[i]));
                    }
                    FilteredAndAggregatedRecords.this.next = null;
                    return this.oneRecord;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        private boolean hasAggregation() {
            return this.groupIndexes.length > 0 || this.schema.getMetricsCount() > 0;
        }

        private boolean satisfyFilter(RawRecord rawRecord) {
            this.next = rawRecord;
            return this.filter.evaluate(this.oneTuple, this.filterCodeSystem);
        }

        private MeasureAggregator[] newAggregators() {
            String[] aggrFuncs = this.schema.getAggrFuncs();
            MeasureAggregator[] result = new MeasureAggregator[aggrFuncs.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = MeasureAggregator.create(aggrFuncs[i], this.schema.getMetricsDataType(i));
            }
            return result;
        }

        class OneValueAggregationCache
        implements AggregationCache {
            MeasureAggregator[] aggrs;
            byte[][] rawDimValues;

            public OneValueAggregationCache() {
                this.aggrs = FilteredAndAggregatedRecords.this.newAggregators();
            }

            @Override
            public boolean aggregate(RawRecord r) {
                int i;
                if (this.rawDimValues == null) {
                    byte[][] tmpDimValues = r.getDimensions();
                    this.rawDimValues = new byte[tmpDimValues.length][];
                    for (i = 0; i < tmpDimValues.length; ++i) {
                        this.rawDimValues[i] = new byte[tmpDimValues[i].length];
                        System.arraycopy(tmpDimValues[i], 0, this.rawDimValues[i], 0, tmpDimValues[i].length);
                    }
                }
                byte[][] metricsVals = r.getMetrics();
                for (i = 0; i < this.aggrs.length; ++i) {
                    Object metrics = FilteredAndAggregatedRecords.this.recordDecoder.decodeMetrics(i, metricsVals[i]);
                    this.aggrs[i].aggregate(metrics);
                }
                return true;
            }

            @Override
            public void close() throws RuntimeException {
            }

            @Override
            public Iterator<Record> iterator() {
                HavingFilterChecker havingFilterChecker;
                if (this.rawDimValues == null) {
                    return Collections.emptyIterator();
                }
                HavingFilterChecker havingFilterChecker2 = havingFilterChecker = FilteredAndAggregatedRecords.this.havingFilter == null ? null : new HavingFilterChecker(FilteredAndAggregatedRecords.this.havingFilter, FilteredAndAggregatedRecords.this.schema);
                if (havingFilterChecker == null) {
                    return Iterators.singletonIterator(this.createRecord());
                }
                if (havingFilterChecker.check(this.aggrs)) {
                    return Iterators.singletonIterator(this.createRecord());
                }
                return Collections.emptyIterator();
            }

            Record createRecord() {
                int i;
                Record record = new Record(FilteredAndAggregatedRecords.this.schema.getDimensionCount(), FilteredAndAggregatedRecords.this.schema.getMetricsCount());
                for (i = 0; i < this.rawDimValues.length; ++i) {
                    record.setDimension(i, FilteredAndAggregatedRecords.this.recordDecoder.decodeDimension(i, this.rawDimValues[i]));
                }
                for (i = 0; i < this.aggrs.length; ++i) {
                    record.setMetric(i, this.aggrs[i].getState());
                }
                FragmentSearchResult.this.finalRowCnt++;
                return record;
            }
        }

        class TreeMapAggregationCache
        implements AggregationCache {
            final Comparator<byte[][]> bytesComparator = new Comparator<byte[][]>(){

                @Override
                public int compare(byte[][] o1, byte[][] o2) {
                    for (int i = 0; i < FilteredAndAggregatedRecords.this.groupIndexes.length; ++i) {
                        int groupIdx = FilteredAndAggregatedRecords.this.groupIndexes[i];
                        int result = Bytes.compareTo(o1[groupIdx], o2[groupIdx]);
                        if (result == 0) continue;
                        return result;
                    }
                    return 0;
                }
            };
            SortedMap<byte[][], MeasureAggregator[]> aggBufMap = this.createBuffMap();

            private SortedMap<byte[][], MeasureAggregator[]> createBuffMap() {
                return Maps.newTreeMap(this.bytesComparator);
            }

            @Override
            public boolean aggregate(RawRecord r) {
                byte[][] dimVals = r.getDimensions();
                byte[][] metricsVals = r.getMetrics();
                MeasureAggregator[] aggrs = (MeasureAggregator[])this.aggBufMap.get(dimVals);
                if (aggrs == null) {
                    if (this.aggBufMap.size() >= FilteredAndAggregatedRecords.this.pushDownLimit) {
                        return false;
                    }
                    byte[][] copyDimVals = new byte[FilteredAndAggregatedRecords.this.schema.getDimensionCount()][];
                    for (int i = 0; i < dimVals.length; ++i) {
                        copyDimVals[i] = new byte[dimVals[i].length];
                        System.arraycopy(dimVals[i], 0, copyDimVals[i], 0, dimVals[i].length);
                    }
                    aggrs = FilteredAndAggregatedRecords.this.newAggregators();
                    this.aggBufMap.put(copyDimVals, aggrs);
                }
                for (int i = 0; i < aggrs.length; ++i) {
                    Object metrics = FilteredAndAggregatedRecords.this.recordDecoder.decodeMetrics(i, metricsVals[i]);
                    aggrs[i].aggregate(metrics);
                }
                return true;
            }

            @Override
            public void close() throws RuntimeException {
            }

            @Override
            public Iterator<Record> iterator() {
                Iterator<Map.Entry<byte[][], MeasureAggregator[]>> it;
                final Iterator<Map.Entry<byte[][], MeasureAggregator[]>> input = it = this.aggBufMap.entrySet().iterator();
                return new Iterator<Record>(){
                    final Record oneRecord;
                    Map.Entry<byte[][], MeasureAggregator[]> returningEntry;
                    final HavingFilterChecker havingFilterChecker;
                    {
                        this.oneRecord = new Record(FilteredAndAggregatedRecords.this.schema.getDimensionCount(), FilteredAndAggregatedRecords.this.schema.getMetricsCount());
                        this.returningEntry = null;
                        this.havingFilterChecker = FilteredAndAggregatedRecords.this.havingFilter == null ? null : new HavingFilterChecker(FilteredAndAggregatedRecords.this.havingFilter, FilteredAndAggregatedRecords.this.schema);
                    }

                    @Override
                    public boolean hasNext() {
                        while (this.returningEntry == null && input.hasNext()) {
                            this.returningEntry = (Map.Entry)input.next();
                            if (this.havingFilterChecker == null || this.havingFilterChecker.check(this.returningEntry.getValue())) continue;
                            this.returningEntry = null;
                        }
                        return this.returningEntry != null;
                    }

                    @Override
                    public Record next() {
                        byte[][] rawDimVals = this.returningEntry.getKey();
                        for (int i = 0; i < rawDimVals.length; ++i) {
                            this.oneRecord.setDimension(i, FilteredAndAggregatedRecords.this.recordDecoder.decodeDimension(i, rawDimVals[i]));
                        }
                        MeasureAggregator[] measures = this.returningEntry.getValue();
                        for (int i = 0; i < measures.length; ++i) {
                            this.oneRecord.setMetric(i, measures[i].getState());
                        }
                        FragmentSearchResult.this.finalRowCnt++;
                        this.returningEntry = null;
                        return this.oneRecord;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }
    }
}

