/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.zip.DataFormatException;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.common.util.CompressionUtils;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.apache.kylin.stream.core.query.ResponseResultSchema;
import org.apache.kylin.stream.core.storage.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordsSerializer {
    private static final Logger logger = LoggerFactory.getLogger(RecordsSerializer.class);
    private static final int ROWVALUE_BUFFER_SIZE = 0x100000;
    private ResponseResultSchema schema;
    private DataTypeSerializer[] metricsSerializers;

    public RecordsSerializer(ResponseResultSchema schema) {
        this.schema = schema;
        DataType[] metricsDataTypes = schema.getMetricsDataTypes();
        this.metricsSerializers = new DataTypeSerializer[metricsDataTypes.length];
        for (int i = 0; i < this.metricsSerializers.length; ++i) {
            this.metricsSerializers[i] = DataTypeSerializer.create(metricsDataTypes[i]);
        }
    }

    public Pair<byte[], Long> serialize(Iterator<Record> records, int storagePushDownLimit) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(0x100000);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(0x100000);
        long finalRowCnt = 0L;
        while (records.hasNext()) {
            Record record = records.next();
            buffer.clear();
            this.serializeRecord(record, buffer);
            buffer.flip();
            outputStream.write(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
            if (++finalRowCnt < (long)storagePushDownLimit) continue;
            logger.info("The finalScanner aborted because storagePushDownLimit is satisfied, storagePushDownLimit is:{}", (Object)storagePushDownLimit);
            break;
        }
        byte[] compressedAllRows = CompressionUtils.compress(outputStream.toByteArray());
        return new Pair<byte[], Long>(compressedAllRows, finalRowCnt);
    }

    private void serializeRecord(Record record, ByteBuffer out) {
        int i;
        String[] dimValues = record.getDimensions();
        Object[] metricValues = record.getMetrics();
        for (i = 0; i < dimValues.length; ++i) {
            BytesUtil.writeUTFString(dimValues[i], out);
        }
        for (i = 0; i < metricValues.length; ++i) {
            this.metricsSerializers[i].serialize(metricValues[i], out);
        }
    }

    private void deserializeRecord(Record resultRecord, ByteBuffer in) {
        int i;
        for (i = 0; i < this.schema.getDimensionCount(); ++i) {
            resultRecord.setDimension(i, BytesUtil.readUTFString(in));
        }
        for (i = 0; i < this.schema.getMetricsCount(); ++i) {
            resultRecord.setMetric(i, this.metricsSerializers[i].deserialize(in));
        }
    }

    public Iterator<Record> deserialize(byte[] recordsBytes) throws IOException, DataFormatException {
        final byte[] decompressedData = CompressionUtils.decompress(recordsBytes);
        return new Iterator<Record>(){
            private ByteBuffer inputBuffer = null;
            private Record oneRecord = new Record(RecordsSerializer.access$000(RecordsSerializer.this).getDimensionCount(), RecordsSerializer.access$000(RecordsSerializer.this).getMetricsCount());

            @Override
            public boolean hasNext() {
                if (this.inputBuffer == null) {
                    this.inputBuffer = ByteBuffer.wrap(decompressedData);
                }
                return this.inputBuffer.position() < this.inputBuffer.limit();
            }

            @Override
            public Record next() {
                RecordsSerializer.this.deserializeRecord(this.oneRecord, this.inputBuffer);
                return this.oneRecord;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("UnSupport Operation");
            }
        };
    }

    static /* synthetic */ ResponseResultSchema access$000(RecordsSerializer x0) {
        return x0.schema;
    }
}

