/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.server.rest.controller;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.kylin.stream.server.StreamingServer;
import org.apache.kylin.stream.server.rest.controller.BasicController;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/system"})
public class SystemController
extends BasicController {
    private static final Logger logger = LoggerFactory.getLogger(SystemController.class);
    private StreamingServer streamingServer = StreamingServer.getInstance();
    private static ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();

    @RequestMapping(value={"/logLevel/{loggerName}/{logLevel}"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public void setLogLevel(@PathVariable(value="loggerName") String loggerName, @PathVariable(value="logLevel") String logLevel) {
        org.apache.log4j.Logger logger = LogManager.getLogger((String)loggerName);
        Level level = Level.toLevel((String)logLevel);
        logger.setLevel(level);
    }

    @RequestMapping(value={"/logLevel/{loggerName}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String getLogLevel(@PathVariable(value="loggerName") String loggerName) {
        org.apache.log4j.Logger logger = LogManager.getLogger((String)loggerName);
        Level level = logger.getEffectiveLevel();
        if (level != null) {
            return level.toString();
        }
        return null;
    }

    @RequestMapping(value={"/threadDump"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public void threadDump(HttpServletResponse response) {
        response.setContentType("text/plain;charset=utf-8");
        try (ServletOutputStream outputStream = response.getOutputStream();){
            SystemController.printThreadInfo(new PrintStream((OutputStream)outputStream, false, "UTF-8"), "Thread Dump");
        }
        catch (IOException e) {
            logger.error("exception when get stack trace", e);
        }
    }

    private static String getTaskName(long id, String name) {
        if (name == null) {
            return Long.toString(id);
        }
        return id + " (" + name + ")";
    }

    public static synchronized void printThreadInfo(PrintStream stream, String title) {
        int stackDepth = 20;
        boolean contention = threadBean.isThreadContentionMonitoringEnabled();
        long[] threadIds = threadBean.getAllThreadIds();
        stream.println("Process Thread Dump: " + title);
        stream.println(threadIds.length + " active threads");
        for (long tid : threadIds) {
            ThreadInfo info = threadBean.getThreadInfo(tid, 20);
            if (info == null) {
                stream.println("  Inactive");
                continue;
            }
            stream.println("Thread " + SystemController.getTaskName(info.getThreadId(), info.getThreadName()) + ":");
            Thread.State state = info.getThreadState();
            stream.println("  State: " + (Object)((Object)state));
            stream.println("  Blocked count: " + info.getBlockedCount());
            stream.println("  Waited count: " + info.getWaitedCount());
            if (contention) {
                stream.println("  Blocked time: " + info.getBlockedTime());
                stream.println("  Waited time: " + info.getWaitedTime());
            }
            if (state == Thread.State.WAITING) {
                stream.println("  Waiting on " + info.getLockName());
            } else if (state == Thread.State.BLOCKED) {
                stream.println("  Blocked on " + info.getLockName());
                stream.println("  Blocked by " + SystemController.getTaskName(info.getLockOwnerId(), info.getLockOwnerName()));
            }
            stream.println("  Stack:");
            for (StackTraceElement frame : info.getStackTrace()) {
                stream.println("    " + frame.toString());
            }
        }
        stream.flush();
    }
}

