/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.IExpressionEvaluator;
import org.codehaus.commons.compiler.PrimitiveWrapper;
import org.codehaus.janino.Java;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.ScriptEvaluator;
import org.codehaus.janino.Visitor;
import org.codehaus.janino.util.Traverser;

public class ExpressionEvaluator
extends ScriptEvaluator
implements IExpressionEvaluator {
    private Class[] optionalExpressionTypes;

    public ExpressionEvaluator(String expression, Class expressionType, String[] parameterNames, Class[] parameterTypes) throws CompileException {
        this.setExpressionType(expressionType);
        this.setParameters(parameterNames, parameterTypes);
        this.cook(expression);
    }

    public ExpressionEvaluator(String expression, Class expressionType, String[] parameterNames, Class[] parameterTypes, Class[] thrownExceptions, ClassLoader optionalParentClassLoader) throws CompileException {
        this.setExpressionType(expressionType);
        this.setParameters(parameterNames, parameterTypes);
        this.setThrownExceptions(thrownExceptions);
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(expression);
    }

    public ExpressionEvaluator(String expression, Class expressionType, String[] parameterNames, Class[] parameterTypes, Class[] thrownExceptions, Class optionalExtendedType, Class[] implementedTypes, ClassLoader optionalParentClassLoader) throws CompileException {
        this.setExpressionType(expressionType);
        this.setParameters(parameterNames, parameterTypes);
        this.setThrownExceptions(thrownExceptions);
        this.setExtendedClass(optionalExtendedType);
        this.setImplementedInterfaces(implementedTypes);
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(expression);
    }

    public ExpressionEvaluator(Scanner scanner, String className, Class optionalExtendedType, Class[] implementedTypes, boolean staticMethod, Class expressionType, String methodName, String[] parameterNames, Class[] parameterTypes, Class[] thrownExceptions, ClassLoader optionalParentClassLoader) throws CompileException, IOException {
        this.setClassName(className);
        this.setExtendedClass(optionalExtendedType);
        this.setImplementedInterfaces(implementedTypes);
        this.setStaticMethod(staticMethod);
        this.setExpressionType(expressionType);
        this.setMethodName(methodName);
        this.setParameters(parameterNames, parameterTypes);
        this.setThrownExceptions(thrownExceptions);
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(scanner);
    }

    public ExpressionEvaluator() {
    }

    @Override
    public void setExpressionType(Class expressionType) {
        this.setExpressionTypes(new Class[]{expressionType});
    }

    @Override
    public void setExpressionTypes(Class[] expressionTypes) {
        this.assertNotCooked();
        this.optionalExpressionTypes = expressionTypes;
        Class[] returnTypes = new Class[expressionTypes.length];
        for (int i = 0; i < returnTypes.length; ++i) {
            Class et = expressionTypes[i];
            returnTypes[i] = et == IExpressionEvaluator.ANY_TYPE ? Object.class : et;
        }
        super.setReturnTypes(returnTypes);
    }

    @Override
    @Deprecated
    public final void setReturnType(Class returnType) {
        throw new AssertionError((Object)"Must not be used on an ExpressionEvaluator; use 'setExpressionType()' instead");
    }

    @Override
    @Deprecated
    public final void setReturnTypes(Class[] returnTypes) {
        throw new AssertionError((Object)"Must not be used on an ExpressionEvaluator; use 'setExpressionTypes()' instead");
    }

    @Override
    protected Class getDefaultReturnType() {
        return Object.class;
    }

    @Override
    protected List<Java.BlockStatement> makeStatements(int idx, Parser parser) throws CompileException, IOException {
        Class et;
        ArrayList<Java.BlockStatement> statements = new ArrayList<Java.BlockStatement>();
        Java.Rvalue value = parser.parseExpression().toRvalueOrCompileException();
        Class clazz = et = this.optionalExpressionTypes == null ? IExpressionEvaluator.ANY_TYPE : this.optionalExpressionTypes[idx];
        if (et == Void.TYPE) {
            statements.add(new Java.ExpressionStatement(value));
        } else {
            if (et == IExpressionEvaluator.ANY_TYPE) {
                value = new Java.MethodInvocation(parser.location(), new Java.ReferenceType(parser.location(), new String[]{"org", "codehaus", "commons", "compiler", "PrimitiveWrapper"}, null), "wrap", new Java.Rvalue[]{value});
                PrimitiveWrapper.wrap(99);
                this.classToType(null, PrimitiveWrapper.class);
            }
            statements.add(new Java.ReturnStatement(parser.location(), value));
        }
        if (!parser.peekEof()) {
            throw new CompileException("Unexpected token \"" + parser.peek() + "\"", parser.location());
        }
        return statements;
    }

    @Deprecated
    public static Object createFastExpressionEvaluator(String expression, Class interfaceToImplement, String[] parameterNames, ClassLoader optionalParentClassLoader) throws CompileException {
        ExpressionEvaluator ee = new ExpressionEvaluator();
        ee.setParentClassLoader(optionalParentClassLoader);
        return ee.createFastEvaluator(expression, interfaceToImplement, parameterNames);
    }

    @Deprecated
    public static Object createFastExpressionEvaluator(Scanner scanner, String className, Class optionalExtendedType, Class interfaceToImplement, String[] parameterNames, ClassLoader optionalParentClassLoader) throws CompileException, IOException {
        ExpressionEvaluator ee = new ExpressionEvaluator();
        ee.setClassName(className);
        ee.setExtendedClass(optionalExtendedType);
        ee.setParentClassLoader(optionalParentClassLoader);
        return ee.createFastEvaluator(scanner, interfaceToImplement, parameterNames);
    }

    @Deprecated
    public static Object createFastExpressionEvaluator(Scanner scanner, String[] optionalDefaultImports, String className, Class optionalExtendedType, Class interfaceToImplement, String[] parameterNames, ClassLoader optionalParentClassLoader) throws CompileException, IOException {
        ExpressionEvaluator ee = new ExpressionEvaluator();
        ee.setClassName(className);
        ee.setExtendedClass(optionalExtendedType);
        ee.setDefaultImports(optionalDefaultImports);
        ee.setParentClassLoader(optionalParentClassLoader);
        return ee.createFastEvaluator(scanner, interfaceToImplement, parameterNames);
    }

    public static String[] guessParameterNames(Scanner scanner) throws CompileException, IOException {
        Parser parser = new Parser(scanner);
        while (parser.peek("import")) {
            parser.parseImportDeclaration();
        }
        Java.Rvalue rvalue = parser.parseExpression().toRvalueOrCompileException();
        if (!parser.peekEof()) {
            throw new CompileException("Unexpected token \"" + parser.peek() + "\"", scanner.location());
        }
        final HashSet parameterNames = new HashSet();
        rvalue.accept((Visitor.RvalueVisitor)new Traverser(){

            @Override
            public void traverseAmbiguousName(Java.AmbiguousName an) {
                for (String identifier : an.identifiers) {
                    if (!Character.isUpperCase(identifier.charAt(0))) continue;
                    return;
                }
                parameterNames.add(an.identifiers[0]);
            }
        }.comprehensiveVisitor());
        return parameterNames.toArray(new String[parameterNames.size()]);
    }
}

