/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web.portlet;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.portlet.PortletContext;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.mock.web.portlet.MockPortletContext;

public class MockPortletSession
implements PortletSession {
    private static int nextId = 1;
    private final String id = Integer.toString(nextId++);
    private final long creationTime = System.currentTimeMillis();
    private int maxInactiveInterval;
    private long lastAccessedTime = System.currentTimeMillis();
    private final PortletContext portletContext;
    private final Map<String, Object> portletAttributes = new LinkedHashMap<String, Object>();
    private final Map<String, Object> applicationAttributes = new LinkedHashMap<String, Object>();
    private boolean invalid = false;
    private boolean isNew = true;

    public MockPortletSession() {
        this(null);
    }

    public MockPortletSession(PortletContext portletContext) {
        this.portletContext = portletContext != null ? portletContext : new MockPortletContext();
    }

    public Object getAttribute(String name) {
        return this.portletAttributes.get(name);
    }

    public Object getAttribute(String name, int scope) {
        if (scope == 2) {
            return this.portletAttributes.get(name);
        }
        if (scope == 1) {
            return this.applicationAttributes.get(name);
        }
        return null;
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(new LinkedHashSet<String>(this.portletAttributes.keySet()));
    }

    public Enumeration<String> getAttributeNames(int scope) {
        if (scope == 2) {
            return Collections.enumeration(new LinkedHashSet<String>(this.portletAttributes.keySet()));
        }
        if (scope == 1) {
            return Collections.enumeration(new LinkedHashSet<String>(this.applicationAttributes.keySet()));
        }
        return null;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return this.id;
    }

    public void access() {
        this.lastAccessedTime = System.currentTimeMillis();
        this.setNew(false);
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void clearAttributes() {
        this.doClearAttributes(this.portletAttributes);
        this.doClearAttributes(this.applicationAttributes);
    }

    protected void doClearAttributes(Map<String, Object> attributes) {
        Iterator<Map.Entry<String, Object>> it = attributes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            String name = entry.getKey();
            Object value = entry.getValue();
            it.remove();
            if (!(value instanceof HttpSessionBindingListener)) continue;
            ((HttpSessionBindingListener)value).valueUnbound(new HttpSessionBindingEvent(new MockHttpSession(), name, value));
        }
    }

    public void invalidate() {
        this.invalid = true;
        this.clearAttributes();
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public void setNew(boolean value) {
        this.isNew = value;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void removeAttribute(String name) {
        this.portletAttributes.remove(name);
    }

    public void removeAttribute(String name, int scope) {
        if (scope == 2) {
            this.portletAttributes.remove(name);
        } else if (scope == 1) {
            this.applicationAttributes.remove(name);
        }
    }

    public void setAttribute(String name, Object value) {
        if (value != null) {
            this.portletAttributes.put(name, value);
        } else {
            this.portletAttributes.remove(name);
        }
    }

    public void setAttribute(String name, Object value, int scope) {
        if (scope == 2) {
            if (value != null) {
                this.portletAttributes.put(name, value);
            } else {
                this.portletAttributes.remove(name);
            }
        } else if (scope == 1) {
            if (value != null) {
                this.applicationAttributes.put(name, value);
            } else {
                this.applicationAttributes.remove(name);
            }
        }
    }

    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
    }

    public PortletContext getPortletContext() {
        return this.portletContext;
    }

    public Map<String, Object> getAttributeMap() {
        return Collections.unmodifiableMap(this.portletAttributes);
    }

    public Map<String, Object> getAttributeMap(int scope) {
        if (scope == 2) {
            return Collections.unmodifiableMap(this.portletAttributes);
        }
        if (scope == 1) {
            return Collections.unmodifiableMap(this.applicationAttributes);
        }
        return Collections.emptyMap();
    }
}

