/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.jackson2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.annotation.JacksonAnnotation;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.databind.DatabindContext;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.databind.DeserializationConfig;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.databind.JavaType;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.databind.Module;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.databind.cfg.MapperConfig;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.databind.jsontype.NamedType;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import org.apache.kylin.job.shaded.org.apache.commons.logging.Log;
import org.apache.kylin.job.shaded.org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ClassUtils;

public final class SecurityJackson2Modules {
    private static final Log logger = LogFactory.getLog(SecurityJackson2Modules.class);
    private static final List<String> securityJackson2ModuleClasses = Arrays.asList("org.springframework.security.jackson2.CoreJackson2Module", "org.springframework.security.cas.jackson2.CasJackson2Module", "org.springframework.security.web.jackson2.WebJackson2Module");

    private SecurityJackson2Modules() {
    }

    public static void enableDefaultTyping(ObjectMapper mapper) {
        TypeResolverBuilder<?> typeBuilder;
        if (mapper != null && (typeBuilder = mapper.getDeserializationConfig().getDefaultTyper(null)) == null) {
            mapper.setDefaultTyping(SecurityJackson2Modules.createWhitelistedDefaultTyping());
        }
    }

    private static Module loadAndGetInstance(String className, ClassLoader loader) {
        Module instance;
        block4: {
            instance = null;
            try {
                Class<?> securityModule = ClassUtils.forName(className, loader);
                if (securityModule != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Loaded module " + className + ", now registering");
                    }
                    instance = (Module)securityModule.newInstance();
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block4;
                logger.debug("Cannot load module " + className, e);
            }
        }
        return instance;
    }

    public static List<Module> getModules(ClassLoader loader) {
        ArrayList<Module> modules = new ArrayList<Module>();
        for (String className : securityJackson2ModuleClasses) {
            Module module = SecurityJackson2Modules.loadAndGetInstance(className, loader);
            if (module == null) continue;
            modules.add(module);
        }
        return modules;
    }

    private static TypeResolverBuilder<? extends TypeResolverBuilder> createWhitelistedDefaultTyping() {
        WhitelistTypeResolverBuilder result = new WhitelistTypeResolverBuilder(ObjectMapper.DefaultTyping.NON_FINAL);
        result = result.init(JsonTypeInfo.Id.CLASS, null);
        result = result.inclusion(JsonTypeInfo.As.PROPERTY);
        return result;
    }

    static class WhitelistTypeIdResolver
    implements TypeIdResolver {
        private static final Set<String> WHITELIST_CLASS_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("java.util.ArrayList", "java.util.Collections$EmptyMap", "java.util.Collections$UnmodifiableRandomAccessList", "java.util.Date", "java.util.TreeMap", "java.util.HashMap", "org.springframework.security.core.context.SecurityContextImpl")));
        private final TypeIdResolver delegate;

        WhitelistTypeIdResolver(TypeIdResolver delegate) {
            this.delegate = delegate;
        }

        @Override
        public void init(JavaType baseType) {
            this.delegate.init(baseType);
        }

        @Override
        public String idFromValue(Object value) {
            return this.delegate.idFromValue(value);
        }

        @Override
        public String idFromValueAndType(Object value, Class<?> suggestedType) {
            return this.delegate.idFromValueAndType(value, suggestedType);
        }

        @Override
        public String idFromBaseType() {
            return this.delegate.idFromBaseType();
        }

        @Override
        public JavaType typeFromId(DatabindContext context, String id) throws IOException {
            boolean isExplicitMixin;
            DeserializationConfig config = (DeserializationConfig)context.getConfig();
            JavaType result = this.delegate.typeFromId(context, id);
            String className = result.getRawClass().getName();
            if (this.isWhitelisted(className)) {
                return this.delegate.typeFromId(context, id);
            }
            boolean bl = isExplicitMixin = config.findMixInClassFor(result.getRawClass()) != null;
            if (isExplicitMixin) {
                return result;
            }
            JacksonAnnotation jacksonAnnotation = AnnotationUtils.findAnnotation(result.getRawClass(), JacksonAnnotation.class);
            if (jacksonAnnotation != null) {
                return result;
            }
            throw new IllegalArgumentException("The class with " + id + " and name of " + className + " is not whitelisted. If you believe this class is safe to deserialize, please provide an explicit mapping using Jackson annotations or by providing a Mixin. If the serialization is only done by a trusted source, you can also enable default typing. See https://github.com/spring-projects/spring-security/issues/4370 for details");
        }

        private boolean isWhitelisted(String id) {
            return WHITELIST_CLASS_NAMES.contains(id);
        }

        @Override
        public String getDescForKnownTypeIds() {
            return this.delegate.getDescForKnownTypeIds();
        }

        @Override
        public JsonTypeInfo.Id getMechanism() {
            return this.delegate.getMechanism();
        }
    }

    static class WhitelistTypeResolverBuilder
    extends ObjectMapper.DefaultTypeResolverBuilder {
        public WhitelistTypeResolverBuilder(ObjectMapper.DefaultTyping defaultTyping) {
            super(defaultTyping);
        }

        protected TypeIdResolver idResolver(MapperConfig<?> config, JavaType baseType, Collection<NamedType> subtypes, boolean forSer, boolean forDeser) {
            TypeIdResolver result = super.idResolver(config, baseType, subtypes, forSer, forDeser);
            return new WhitelistTypeIdResolver(result);
        }
    }
}

