/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config.annotation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.springframework.core.OrderComparator;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.handler.WebRequestHandlerInterceptorAdapter;

public class InterceptorRegistry {
    private final List<InterceptorRegistration> registrations = new ArrayList<InterceptorRegistration>();
    private static final Comparator<Object> INTERCEPTOR_ORDER_COMPARATOR = OrderComparator.INSTANCE.withSourceProvider(new OrderComparator.OrderSourceProvider(){

        @Override
        public Object getOrderSource(Object object) {
            if (object instanceof InterceptorRegistration) {
                return ((InterceptorRegistration)object).toOrdered();
            }
            return null;
        }
    });

    public InterceptorRegistration addInterceptor(HandlerInterceptor interceptor) {
        InterceptorRegistration registration = new InterceptorRegistration(interceptor);
        this.registrations.add(registration);
        return registration;
    }

    public InterceptorRegistration addWebRequestInterceptor(WebRequestInterceptor interceptor) {
        WebRequestHandlerInterceptorAdapter adapted = new WebRequestHandlerInterceptorAdapter(interceptor);
        InterceptorRegistration registration = new InterceptorRegistration(adapted);
        this.registrations.add(registration);
        return registration;
    }

    protected List<Object> getInterceptors() {
        Collections.sort(this.registrations, INTERCEPTOR_ORDER_COMPARATOR);
        ArrayList<Object> result = new ArrayList<Object>(this.registrations.size());
        for (InterceptorRegistration registration : this.registrations) {
            result.add(registration.getInterceptor());
        }
        return result;
    }
}

