/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import java.io.InputStream;
import java.util.Locale;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.JobErrorCode;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.profiler.Message;
import org.apache.kylin.profiler.ProfilerStatus;

public class BuildAsyncProfileHelper {
    public static final String NOT_EXIST = "not_exist";

    private BuildAsyncProfileHelper() {
    }

    public static String getProfileStatus(String project, String jobStepId) {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        Path actionPath = new Path(kylinConfig.getJobTmpProfilerFlagsDir(project, jobStepId) + "/status");
        if (!HadoopUtil.getWorkingFileSystem().exists(actionPath)) {
            return NOT_EXIST;
        }
        return HadoopUtil.readStringFromHdfs((Path)actionPath);
    }

    public static void startProfile(String project, String jobStepId, String param) {
        String status = BuildAsyncProfileHelper.getProfileStatus(project, jobStepId);
        BuildAsyncProfileHelper.checkInvalidStatus(status);
        if (ProfilerStatus.RUNNING().equals(status)) {
            throw new KylinException((ErrorCodeSupplier)JobErrorCode.PROFILING_STATUS_ERROR, String.format(Locale.ROOT, MsgPicker.getMsg().getProfilingStartedError(), new Object[0]));
        }
        String cmd = Message.createDriverMessage((String)Message.START(), (String)param);
        Path actionPath = new Path(KylinConfig.getInstanceFromEnv().getJobTmpProfilerFlagsDir(project, jobStepId) + "/action");
        HadoopUtil.writeStringToHdfs((String)cmd, (Path)actionPath);
    }

    public static InputStream dump(String project, String jobStepId, String param) {
        String status = BuildAsyncProfileHelper.getProfileStatus(project, jobStepId);
        BuildAsyncProfileHelper.checkInvalidStatus(status);
        if (ProfilerStatus.IDLE().equals(status)) {
            throw new KylinException((ErrorCodeSupplier)JobErrorCode.PROFILING_STATUS_ERROR, String.format(Locale.ROOT, MsgPicker.getMsg().getProfilingNotStartError(), new Object[0]));
        }
        String cmd = Message.createDriverMessage((String)Message.DUMP(), (String)param);
        Path actionPath = new Path(KylinConfig.getInstanceFromEnv().getJobTmpProfilerFlagsDir(project, jobStepId) + "/action");
        HadoopUtil.writeStringToHdfs((String)cmd, (Path)actionPath);
        Path dumpFilePath = new Path(KylinConfig.getInstanceFromEnv().getJobTmpProfilerFlagsDir(project, jobStepId) + "/dump.tar.gz");
        FileSystem fileSystem = HadoopUtil.getWorkingFileSystem();
        for (long timeout = KylinConfig.getInstanceFromEnv().buildJobProfilingResultTimeout(); !ProfilerStatus.DUMPED().equals(BuildAsyncProfileHelper.getProfileStatus(project, jobStepId)) && timeout >= 0L; timeout -= 500L) {
            Thread.sleep(500L);
        }
        if (!fileSystem.exists(dumpFilePath)) {
            throw new KylinException((ErrorCodeSupplier)JobErrorCode.PROFILING_COLLECT_TIMEOUT, String.format(Locale.ROOT, MsgPicker.getMsg().getProfilingCollectTimeout(), new Object[0]));
        }
        return fileSystem.open(dumpFilePath);
    }

    public static void checkInvalidStatus(String status) {
        if (NOT_EXIST.equals(status)) {
            throw new KylinException((ErrorCodeSupplier)JobErrorCode.PROFILING_STATUS_ERROR, String.format(Locale.ROOT, MsgPicker.getMsg().getProfilingJobNotStartError(), new Object[0]));
        }
        if (ProfilerStatus.CLOSED().equals(status)) {
            throw new KylinException((ErrorCodeSupplier)JobErrorCode.PROFILING_STATUS_ERROR, String.format(Locale.ROOT, MsgPicker.getMsg().getProfilingJobFinishedError(), new Object[0]));
        }
    }
}

