/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.streaming.jobs;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.response.RestResponse;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.utils.StreamingUtils;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.streaming.request.StreamingSegmentRequest;
import org.apache.kylin.streaming.rest.RestSupport;
import org.apache.kylin.streaming.util.JobExecutionIdHolder;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.kafka010.OffsetRangeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class StreamingSegmentManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StreamingSegmentManager.class);
    private static final String SEGMENT_POST_URL = "/streaming_jobs/dataflow/segment";

    public static NDataSegment allocateSegment(SparkSession ss, String dataflowId, String project, Long batchMinTime, Long batchMaxTime) {
        return StreamingSegmentManager.allocateSegment(ss, null, dataflowId, project, batchMinTime, batchMaxTime);
    }

    public static NDataSegment allocateSegment(SparkSession ss, SegmentRange.KafkaOffsetPartitionedSegmentRange sr, String dataflowId, String project, Long batchMinTime, Long batchMaxTime) {
        NDataSegment newSegment;
        KylinConfig config;
        if (sr == null) {
            Tuple2<String, String> offsetRange = OffsetRangeManager.currentOffsetRange(ss);
            sr = new SegmentRange.KafkaOffsetPartitionedSegmentRange(batchMinTime, batchMaxTime, OffsetRangeManager.partitionOffsets((String)offsetRange._1), OffsetRangeManager.partitionOffsets((String)offsetRange._2));
        }
        if ((config = KylinConfig.getInstanceFromEnv()).isUTEnv()) {
            SegmentRange.KafkaOffsetPartitionedSegmentRange segRange = sr;
            newSegment = (NDataSegment)EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
                NDataflowManager dfMgr = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
                return dfMgr.appendSegmentForStreaming(dfMgr.getDataflow(dataflowId), (SegmentRange)segRange);
            }, (String)project);
            return newSegment;
        }
        StreamingSegmentRequest req = new StreamingSegmentRequest(project, dataflowId);
        req.setSegmentRange((SegmentRange)sr);
        req.setNewSegId(RandomUtil.randomUUIDStr());
        req.setJobType(JobTypeEnum.STREAMING_BUILD.name());
        String jobId = StreamingUtils.getJobId((String)dataflowId, (String)req.getJobType());
        req.setJobExecutionId(JobExecutionIdHolder.getJobExecutionId(jobId));
        try (RestSupport rest = new RestSupport(config);){
            RestResponse<String> restResponse = rest.execute((HttpRequestBase)rest.createHttpPost(SEGMENT_POST_URL), req);
            String newSegId = (String)restResponse.getData();
            StreamingUtils.replayAuditlog();
            if (!StringUtils.isEmpty((CharSequence)newSegId)) {
                NDataflowManager dfMgr = NDataflowManager.getInstance((KylinConfig)config, (String)project);
                newSegment = dfMgr.getDataflow(dataflowId).getSegment(newSegId);
                for (LayoutEntity layout : newSegment.getIndexPlan().getAllLayouts()) {
                    NDataLayout ly = NDataLayout.newDataLayout((NDataflow)newSegment.getDataflow(), (String)newSegment.getId(), (long)layout.getId());
                    newSegment.getLayoutsMap().put(ly.getLayoutId(), ly);
                }
                NDataSegment nDataSegment = newSegment;
                return nDataSegment;
            }
            NDataSegment empSeg = NDataSegment.empty();
            empSeg.setId("");
            NDataSegment nDataSegment = empSeg;
            return nDataSegment;
        }
    }
}

