/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.streaming.merge;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.streaming.merge.MergePolicy;

public class PeakMergePolicy
extends MergePolicy {
    @Override
    public List<NDataSegment> selectMatchedSegList(List<NDataSegment> segList, int layer, long thresholdOfSegSize, int numberOfSeg) {
        this.matchSegList.clear();
        int idx = this.findStartIndex(segList, thresholdOfSegSize);
        if (idx != -1) {
            boolean matched = false;
            for (int i = idx; i < segList.size(); ++i) {
                this.matchSegList.add(segList.get(i));
                if (segList.get(i).getAdditionalInfo().getOrDefault("file_layer", "0").equals(String.valueOf(layer))) {
                    long currSegStorageSize = segList.get(i).getStorageBytesSize();
                    if (this.matchSegList.size() > numberOfSeg || !this.isThresholdOfSegSizeOver(currSegStorageSize, thresholdOfSegSize)) continue;
                    matched = true;
                    break;
                }
                if (this.matchSegList.size() > numberOfSeg) break;
            }
            if (!matched) {
                this.matchSegList.clear();
            }
            return this.matchSegList;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean matchMergeCondition(long thresholdOfSegSize) {
        return this.matchSegList.size() > 1 && this.isThresholdOfSegSizeOver(this.matchSegList.stream().mapToLong(NDataSegment::getStorageBytesSize).sum(), thresholdOfSegSize);
    }

    @Override
    public void next(AtomicInteger currLayer) {
        currLayer.incrementAndGet();
    }

    @Override
    public boolean isThresholdOfSegSizeOver(long totalSegSize, long thresholdOfSegSize) {
        return totalSegSize >= thresholdOfSegSize;
    }
}

