/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.NativeQueryRealization;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.TimeUtil;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableMap;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.favorite.QueryHistoryIdOffset;
import org.apache.kylin.metadata.favorite.QueryHistoryIdOffsetManager;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.query.QueryHistory;
import org.apache.kylin.metadata.query.QueryHistoryDAO;
import org.apache.kylin.metadata.query.QueryHistoryInfo;
import org.apache.kylin.metadata.query.QueryHistoryRequest;
import org.apache.kylin.metadata.query.QueryStatistics;
import org.apache.kylin.metadata.query.RDBMSQueryHistoryDAO;
import org.apache.kylin.rest.exception.ForbiddenException;
import org.apache.kylin.rest.response.NDataModelResponse;
import org.apache.kylin.rest.response.QueryHistoryFiltersResponse;
import org.apache.kylin.rest.response.QueryStatisticsResponse;
import org.apache.kylin.rest.service.AsyncTaskQueryHistorySupporter;
import org.apache.kylin.rest.service.AsyncTaskServiceSupporter;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.ModelService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component(value="queryHistoryService")
public class QueryHistoryService
extends BasicService
implements AsyncTaskQueryHistorySupporter {
    public static final String WEEK = "week";
    public static final String DAY = "day";
    public static final String MODEL = "model";
    public static final String COUNT = "count";
    public static final String MEAN_DURATION = "meanDuration";
    private static final Logger logger = LoggerFactory.getLogger((String)"query");
    @Autowired
    private AclEvaluate aclEvaluate;
    @Autowired
    @Qualifier(value="asyncTaskService")
    private AsyncTaskServiceSupporter asyncTaskService;
    @Autowired
    @Qualifier(value="modelService")
    private ModelService modelService;

    public QueryHistoryDAO getQueryHistoryDao() {
        return RDBMSQueryHistoryDAO.getInstance();
    }

    public void downloadQueryHistories(QueryHistoryRequest request, HttpServletResponse response, ZoneOffset zoneOffset, Integer timeZoneOffsetHour, boolean onlySql) throws Exception {
        this.processRequestParams(request);
        if (this.haveSpaces(request.getSql())) {
            return;
        }
        this.splitModels(request);
        Future future = this.asyncTaskService.runDownloadQueryHistory(request, response, zoneOffset, timeZoneOffsetHour, this.getQueryHistoryDao(), onlySql);
        Long timeCost = (Long)future.get(KylinConfig.getInstanceFromEnv().getQueryHistoryDownloadTimeoutSeconds(), TimeUnit.SECONDS);
        logger.info("download query history cost {}s", (Object)timeCost);
    }

    public Map<String, Object> getQueryHistories(QueryHistoryRequest request, int limit, int page) {
        this.processRequestParams(request);
        HashMap<String, Object> data = new HashMap<String, Object>();
        List queryHistories = Lists.newArrayList();
        if (this.haveSpaces(request.getSql())) {
            data.put("query_histories", queryHistories);
            data.put("size", 0);
            return data;
        }
        this.splitModels(request);
        QueryHistoryDAO queryHistoryDAO = this.getQueryHistoryDao();
        queryHistories = queryHistoryDAO.getQueryHistoriesByConditions(request, limit, page);
        queryHistories.forEach(query -> {
            QueryHistoryInfo queryHistoryInfo = query.getQueryHistoryInfo();
            if ((queryHistoryInfo == null || queryHistoryInfo.getRealizationMetrics() == null || queryHistoryInfo.getRealizationMetrics().isEmpty()) && StringUtils.isEmpty((CharSequence)query.getQueryRealizations())) {
                return;
            }
            query.setNativeQueryRealizations(this.parseQueryRealizationInfo((QueryHistory)query, request.getProject()));
        });
        data.put("query_histories", queryHistories);
        data.put("size", queryHistoryDAO.getQueryHistoriesSize(request, request.getProject()));
        return data;
    }

    public Map<String, Long> queryTiredStorageMetric(QueryHistoryRequest request) {
        this.processRequestParams(request);
        if (this.haveSpaces(request.getSql())) {
            return ImmutableMap.of((Object)"total_scan_count", (Object)0L, (Object)"source_result_count", (Object)0L, (Object)"total_scan_bytes", (Object)0L);
        }
        QueryHistoryDAO queryHistoryDAO = this.getQueryHistoryDao();
        List queryHistories = queryHistoryDAO.getQueryHistoriesByConditions(request, 1, 0);
        if (queryHistories.isEmpty()) {
            return ImmutableMap.of((Object)"total_scan_count", (Object)0L, (Object)"source_result_count", (Object)0L, (Object)"total_scan_bytes", (Object)0L);
        }
        return ImmutableMap.of((Object)"total_scan_count", (Object)((QueryHistory)queryHistories.get(0)).getTotalScanCount(), (Object)"source_result_count", (Object)((QueryHistory)queryHistories.get(0)).getQueryHistoryInfo().getSourceResultCount(), (Object)"total_scan_bytes", (Object)((QueryHistory)queryHistories.get(0)).getTotalScanBytes());
    }

    private void processRequestParams(QueryHistoryRequest request) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)request.getProject()));
        this.aclEvaluate.checkProjectReadPermission(request.getProject());
        request.setUsername(SecurityContextHolder.getContext().getAuthentication().getName());
        if (this.aclEvaluate.hasProjectAdminPermission(NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(request.getProject()))) {
            request.setAdmin(true);
        }
        if (request.getSql() == null) {
            request.setSql("");
        }
        if (request.getSql() != null) {
            request.setSql(request.getSql().trim());
        }
    }

    private List<NativeQueryRealization> parseQueryRealizationInfo(QueryHistory query, String project) {
        Map<String, String> noBrokenModels = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).listUnderliningDataModels().stream().collect(Collectors.toMap(NDataModel::getAlias, RootPersistentEntity::getUuid));
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)config, (String)project);
        NDataModelManager modelManager = NDataModelManager.getInstance((KylinConfig)config, (String)project);
        List realizations = query.transformRealizations(project);
        realizations.forEach(realization -> {
            String modelId = realization.getModelId();
            NDataModel nDataModel = modelManager.getDataModelDesc(modelId);
            if (noBrokenModels.containsValue(modelId)) {
                NDataModelResponse model = (NDataModelResponse)this.modelService.updateResponseAcl((NDataModel)new NDataModelResponse(nDataModel), project);
                realization.setModelAlias(model.getFusionModelAlias());
                realization.setLayoutExist(this.isLayoutExist(indexPlanManager, realization.getModelId(), realization.getLayoutId()));
            } else {
                String modelAlias = nDataModel == null ? "Deleted Model" : String.format(Locale.ROOT, "%s broken", nDataModel.getAlias());
                realization.setModelAlias(modelAlias);
                realization.setValid(false);
                realization.setLayoutExist(false);
            }
        });
        return realizations;
    }

    private boolean isLayoutExist(NIndexPlanManager indexPlanManager, String modelId, Long layoutId) {
        if (layoutId == null) {
            return false;
        }
        return indexPlanManager.getIndexPlan(modelId).getLayoutEntity(layoutId) != null;
    }

    private void splitModels(QueryHistoryRequest request) {
        NDataflowManager dataflowManager = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)request.getProject());
        Map<String, String> modelAliasMap = dataflowManager.listUnderliningDataModels().stream().collect(Collectors.toMap(NDataModel::getAlias, RootPersistentEntity::getUuid));
        List realizations = request.getRealizations();
        if (realizations != null && !realizations.isEmpty() && !realizations.contains("modelName")) {
            ArrayList modelNames = Lists.newArrayList((Iterable)realizations);
            modelNames.remove(QueryHistory.EngineType.HIVE.name());
            modelNames.remove(QueryHistory.EngineType.CONSTANTS.name());
            modelNames.remove(QueryHistory.EngineType.RDBMS.name());
            request.setFilterModelIds(modelNames.stream().filter(modelAliasMap::containsKey).map(modelAliasMap::get).collect(Collectors.toList()));
        }
        if (realizations != null && realizations.contains("modelName") && !CollectionUtils.isEmpty((Collection)request.getExcludeRealization())) {
            ArrayList excludeModelNames = Lists.newArrayList((Iterable)request.getExcludeRealization());
            request.setExcludeFilterModelIds(excludeModelNames.stream().filter(modelAliasMap::containsKey).map(modelAliasMap::get).collect(Collectors.toList()));
        }
    }

    public List<String> getQueryHistoryUsernames(QueryHistoryRequest request, int size) {
        QueryHistoryDAO queryHistoryDAO = this.getQueryHistoryDao();
        request.setUsername(SecurityContextHolder.getContext().getAuthentication().getName());
        if (!this.aclEvaluate.hasProjectAdminPermission(NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(request.getProject()))) {
            throw new ForbiddenException(MsgPicker.getMsg().getExportResultNotAllowed());
        }
        request.setAdmin(true);
        List queryHistories = queryHistoryDAO.getQueryHistoriesSubmitters(request, size);
        return queryHistories.stream().map(QueryHistory::getQuerySubmitter).collect(Collectors.toList());
    }

    public QueryHistoryFiltersResponse getQueryHistoryModels(QueryHistoryRequest request, int size) {
        NDataflowManager dataFlowManager = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)request.getProject());
        List models = dataFlowManager.listAllDataflows();
        List modelList = models.stream().sorted(Comparator.comparing(NDataflow::getQueryHitCount, Comparator.reverseOrder())).map(NDataflow::getModel).map(NDataModel::getAlias).filter(this.filterByName(request.getFilterModelName())).collect(Collectors.toList());
        List<String> engineList = Stream.of(QueryHistory.EngineType.HIVE.name(), QueryHistory.EngineType.RDBMS.name(), QueryHistory.EngineType.CONSTANTS.name(), "OBJECT STORAGE").filter(this.filterByName(request.getFilterModelName())).collect(Collectors.toList());
        Integer count = engineList.size() + modelList.size();
        return new QueryHistoryFiltersResponse(count, models.size(), engineList, modelList.stream().limit(size).collect(Collectors.toList()));
    }

    private Predicate<String> filterByName(String name) {
        return alias -> !StringUtils.isEmpty((CharSequence)alias) && (StringUtils.isEmpty((CharSequence)name) || alias.toLowerCase(Locale.ROOT).contains(name.toLowerCase(Locale.ROOT)));
    }

    private boolean haveSpaces(String text) {
        if (text == null) {
            return false;
        }
        String regex = "[\r|\n|\\s]+";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        return matcher.find();
    }

    public QueryStatisticsResponse getQueryStatistics(String project, long startTime, long endTime) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)project));
        this.aclEvaluate.checkProjectReadPermission(project);
        QueryHistoryDAO queryHistoryDAO = this.getQueryHistoryDao();
        QueryStatistics queryStatistics = queryHistoryDAO.getQueryCountAndAvgDuration(startTime, endTime, project);
        return new QueryStatisticsResponse(queryStatistics.getCount(), queryStatistics.getMeanDuration());
    }

    public QueryStatisticsResponse getQueryStatisticsByRealization(String project, long startTime, long endTime) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)project));
        this.aclEvaluate.checkProjectReadPermission(project);
        QueryHistoryDAO queryHistoryDao = this.getQueryHistoryDao();
        QueryStatistics queryStatistics = queryHistoryDao.getQueryCountAndAvgDurationRealization(startTime, endTime, project);
        return new QueryStatisticsResponse(queryStatistics.getCount(), queryStatistics.getMeanDuration());
    }

    public long getLastWeekQueryCount(String project) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)project));
        this.aclEvaluate.checkProjectReadPermission(project);
        QueryHistoryDAO queryHistoryDAO = this.getQueryHistoryDao();
        long endTime = TimeUtil.getDayStart((long)System.currentTimeMillis());
        long startTime = endTime - 604800000L;
        QueryStatistics statistics = queryHistoryDAO.getQueryCountByRange(startTime, endTime, project);
        return statistics.getCount();
    }

    public long getQueryCountToAccelerate(String project) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)project));
        this.aclEvaluate.checkProjectReadPermission(project);
        QueryHistoryIdOffset queryHistoryIdOffset = QueryHistoryIdOffsetManager.getInstance((String)project).get(QueryHistoryIdOffset.OffsetType.ACCELERATE);
        long idOffset = queryHistoryIdOffset.getOffset();
        QueryHistoryDAO queryHistoryDao = this.getQueryHistoryDao();
        return queryHistoryDao.getQueryHistoryCountBeyondOffset(idOffset, project);
    }

    public Map<String, Object> getQueryCount(String project, long startTime, long endTime, String dimension) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)project));
        this.aclEvaluate.checkProjectReadPermission(project);
        QueryHistoryDAO queryHistoryDAO = this.getQueryHistoryDao();
        if (dimension.equals(MODEL)) {
            List queryStatistics = queryHistoryDAO.getQueryCountByModel(startTime, endTime, project);
            return this.transformQueryStatisticsByModel(project, queryStatistics, COUNT);
        }
        List queryStatistics = queryHistoryDAO.getQueryCountByTime(startTime, endTime, dimension, project);
        RDBMSQueryHistoryDAO.fillZeroForQueryStatistics((List)queryStatistics, (long)startTime, (long)endTime, (String)dimension);
        return this.transformQueryStatisticsByTime(queryStatistics, COUNT, dimension);
    }

    public Map<String, Object> getAvgDuration(String project, long startTime, long endTime, String dimension) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)project));
        this.aclEvaluate.checkProjectReadPermission(project);
        QueryHistoryDAO queryHistoryDAO = this.getQueryHistoryDao();
        if (dimension.equals(MODEL)) {
            List queryStatistics = queryHistoryDAO.getAvgDurationByModel(startTime, endTime, project);
            return this.transformQueryStatisticsByModel(project, queryStatistics, MEAN_DURATION);
        }
        List queryStatistics = queryHistoryDAO.getAvgDurationByTime(startTime, endTime, dimension, project);
        RDBMSQueryHistoryDAO.fillZeroForQueryStatistics((List)queryStatistics, (long)startTime, (long)endTime, (String)dimension);
        return this.transformQueryStatisticsByTime(queryStatistics, MEAN_DURATION, dimension);
    }

    public Map<String, Object> getAvgDurationByRealization(String project, long startTime, long endTime, String dimension) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)project));
        this.aclEvaluate.checkProjectReadPermission(project);
        QueryHistoryDAO queryHistoryDAO = this.getQueryHistoryDao();
        if (dimension.equals(MODEL)) {
            List queryStatistics = queryHistoryDAO.getAvgDurationByModel(startTime, endTime, project);
            return this.transformQueryStatisticsByModel(project, queryStatistics, MEAN_DURATION);
        }
        List queryStatistics = queryHistoryDAO.getAvgDurationRealizationByTime(startTime, endTime, dimension, project);
        RDBMSQueryHistoryDAO.fillZeroForQueryStatistics((List)queryStatistics, (long)startTime, (long)endTime, (String)dimension);
        return this.transformQueryStatisticsByTime(queryStatistics, MEAN_DURATION, dimension);
    }

    public Map<String, Object> getQueryCountByRealization(String project, long startTime, long endTime, String dimension) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)project));
        this.aclEvaluate.checkProjectReadPermission(project);
        QueryHistoryDAO queryHistoryDAO = this.getQueryHistoryDao();
        if (dimension.equals(MODEL)) {
            List queryStatistics = queryHistoryDAO.getQueryCountByModel(startTime, endTime, project);
            return this.transformQueryStatisticsByModel(project, queryStatistics, COUNT);
        }
        List queryStatistics = queryHistoryDAO.getQueryCountRealizationByTime(startTime, endTime, dimension, project);
        RDBMSQueryHistoryDAO.fillZeroForQueryStatistics((List)queryStatistics, (long)startTime, (long)endTime, (String)dimension);
        return this.transformQueryStatisticsByTime(queryStatistics, COUNT, dimension);
    }

    private Map<String, Object> transformQueryStatisticsByModel(String project, List<QueryStatistics> statistics, String fieldName) {
        HashMap result = Maps.newHashMap();
        NDataModelManager modelManager = (NDataModelManager)this.getManager(NDataModelManager.class, project);
        statistics.forEach(singleStatistics -> {
            NDataModel model = modelManager.getDataModelDesc(singleStatistics.getModel());
            if (model == null) {
                return;
            }
            result.put(model.getAlias(), this.getValueByField((QueryStatistics)singleStatistics, fieldName));
        });
        return result;
    }

    private Object getValueByField(QueryStatistics statistics, String fieldName) {
        Object object = null;
        try {
            Field field = statistics.getClass().getDeclaredField(fieldName);
            Unsafe.changeAccessibleObject((AccessibleObject)field, (boolean)true);
            object = field.get(statistics);
        }
        catch (Exception e) {
            logger.error("Error caught when get value from query statistics {}", (Object)e.getMessage());
        }
        return object;
    }

    private Map<String, Object> transformQueryStatisticsByTime(List<QueryStatistics> statistics, String fieldName, String dimension) {
        HashMap result = Maps.newHashMap();
        statistics.forEach(singleStatistics -> {
            if (dimension.equals("month")) {
                TimeZone timeZone = TimeZone.getTimeZone(KylinConfig.getInstanceFromEnv().getTimeZone());
                LocalDate date = singleStatistics.getTime().atZone(timeZone.toZoneId()).toLocalDate();
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM", Locale.getDefault(Locale.Category.FORMAT));
                result.put(date.withDayOfMonth(1).format(formatter), this.getValueByField((QueryStatistics)singleStatistics, fieldName));
                return;
            }
            long time = singleStatistics.getTime().toEpochMilli();
            Date date = new Date(time);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault(Locale.Category.FORMAT));
            result.put(sdf.format(date), this.getValueByField((QueryStatistics)singleStatistics, fieldName));
        });
        return result;
    }

    public Map<String, String> getQueryHistoryTableMap(List<String> projects) {
        List filterProjects = ((NProjectManager)this.getManager(NProjectManager.class)).listAllProjects().stream().map(ProjectInstance::getName).filter(s -> projects == null || projects.stream().map(str -> str.toLowerCase(Locale.ROOT)).collect(Collectors.toList()).contains(s.toLowerCase(Locale.ROOT))).collect(Collectors.toList());
        HashMap result = Maps.newHashMap();
        for (String project : filterProjects) {
            this.aclEvaluate.checkProjectReadPermission(project);
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)project));
            ProjectInstance projectInstance = ((NProjectManager)this.getManager(NProjectManager.class)).getProject(project);
            if (projectInstance == null) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PROJECT_NOT_EXIST, new Object[]{project});
            }
            result.put(project, this.getQueryHistoryDao().getQueryMetricMeasurement());
        }
        return result;
    }
}

