/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import oshi.hardware.CentralProcessor;
import oshi.hardware.ComputerSystem;
import oshi.hardware.Display;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HWDiskStore;
import oshi.hardware.NetworkIF;
import oshi.hardware.PowerSource;
import oshi.hardware.Sensors;
import oshi.hardware.SoundCard;
import oshi.hardware.UsbDevice;
import oshi.hardware.common.AbstractHardwareAbstractionLayer;
import oshi.hardware.platform.windows.WindowsCentralProcessor;
import oshi.hardware.platform.windows.WindowsComputerSystem;
import oshi.hardware.platform.windows.WindowsDisks;
import oshi.hardware.platform.windows.WindowsDisplay;
import oshi.hardware.platform.windows.WindowsGlobalMemory;
import oshi.hardware.platform.windows.WindowsNetworks;
import oshi.hardware.platform.windows.WindowsPowerSource;
import oshi.hardware.platform.windows.WindowsSensors;
import oshi.hardware.platform.windows.WindowsSoundCard;
import oshi.hardware.platform.windows.WindowsUsbDevice;

public class WindowsHardwareAbstractionLayer
extends AbstractHardwareAbstractionLayer {
    private static final long serialVersionUID = 1L;

    @Override
    public ComputerSystem getComputerSystem() {
        if (this.computerSystem == null) {
            this.computerSystem = new WindowsComputerSystem();
        }
        return this.computerSystem;
    }

    @Override
    public GlobalMemory getMemory() {
        if (this.memory == null) {
            this.memory = new WindowsGlobalMemory();
        }
        return this.memory;
    }

    @Override
    public CentralProcessor getProcessor() {
        if (this.processor == null) {
            this.processor = new WindowsCentralProcessor();
        }
        return this.processor;
    }

    @Override
    public PowerSource[] getPowerSources() {
        return WindowsPowerSource.getPowerSources();
    }

    @Override
    public HWDiskStore[] getDiskStores() {
        return new WindowsDisks().getDisks();
    }

    @Override
    public Display[] getDisplays() {
        return WindowsDisplay.getDisplays();
    }

    @Override
    public Sensors getSensors() {
        if (this.sensors == null) {
            this.sensors = new WindowsSensors();
        }
        return this.sensors;
    }

    @Override
    public NetworkIF[] getNetworkIFs() {
        return new WindowsNetworks().getNetworks();
    }

    @Override
    public UsbDevice[] getUsbDevices(boolean tree) {
        return WindowsUsbDevice.getUsbDevices(tree);
    }

    @Override
    public SoundCard[] getSoundCards() {
        return WindowsSoundCard.getSoundCards().toArray(new SoundCard[0]);
    }
}

