/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.kerberos;

import java.io.File;
import java.io.IOException;
import javax.security.auth.kerberos.KeyTab;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.krb5.KrbAsReqBuilder;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.HostAddresses;
import sun.security.krb5.internal.KDCOptions;
import sun.security.krb5.internal.ccache.Credentials;
import sun.security.krb5.internal.ccache.CredentialsCache;

public class KerberosInit {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosInit.class);
    private final PrincipalName principal;
    private final KeyTab keytab;
    private final String cachePath;
    private final String krb5ConfPath;

    public KerberosInit(String prc, String keytabPath, String cachePath, String krb5ConfPath) throws RealmException {
        this.principal = new PrincipalName(prc);
        if (keytabPath == null || keytabPath.length() == 0) {
            LOG.warn("keytab path is null or empty, try use default keytab path");
            this.keytab = KeyTab.getInstance();
        } else {
            File keytabFile = new File(keytabPath);
            if (!keytabFile.exists()) {
                throw new IllegalArgumentException("keytab file not exists: " + keytabPath);
            }
            this.keytab = KeyTab.getInstance(keytabFile);
        }
        this.cachePath = cachePath;
        this.krb5ConfPath = krb5ConfPath;
        if (krb5ConfPath != null && !new File(krb5ConfPath).exists()) {
            throw new IllegalArgumentException("krb5 conf file not exists: " + krb5ConfPath);
        }
    }

    public KerberosInit(String prc, String keytabPath, String cachePath) throws RealmException {
        this(prc, keytabPath, cachePath, null);
    }

    private void execute0() throws KrbException, IOException {
        KrbAsReqBuilder builder = new KrbAsReqBuilder(this.principal, this.keytab);
        KDCOptions opt = new KDCOptions();
        builder.setOptions(opt);
        String realm = this.principal.getRealmString();
        PrincipalName sname = PrincipalName.tgsService(realm, realm);
        builder.setTarget(sname);
        builder.setAddresses(HostAddresses.getLocalAddresses());
        builder.action();
        Credentials credentials = builder.getCCreds();
        builder.destroy();
        CredentialsCache cache = CredentialsCache.create(this.principal, this.cachePath);
        if (cache == null) {
            throw new IOException("Unable to create the cache file " + this.cachePath);
        }
        cache.update(credentials);
        cache.save();
        LOG.info("Successfully stored kerberos ticket cache in " + this.cachePath);
    }

    public void execute() throws KrbException, IOException {
        String originalKrb5Conf = System.getProperty("java.security.krb5.conf");
        try {
            if (this.krb5ConfPath != null) {
                System.setProperty("java.security.krb5.conf", this.krb5ConfPath);
            }
            this.execute0();
        }
        finally {
            if (this.krb5ConfPath != null && originalKrb5Conf != null) {
                System.setProperty("java.security.krb5.conf", originalKrb5Conf);
            }
        }
    }
}

