/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaOperations;
import org.apache.spark.sql.delta.DeltaOptions;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor;
import org.apache.spark.sql.delta.actions.FileAction;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.actions.SetTransaction;
import org.apache.spark.sql.delta.commands.DeltaCommand;
import org.apache.spark.sql.delta.commands.OptimizeTableCommandOverwrites$;
import org.apache.spark.sql.delta.commands.optimize.DeletionVectorStats;
import org.apache.spark.sql.delta.commands.optimize.FileSizeStatsWithHistogram;
import org.apache.spark.sql.delta.commands.optimize.FileSizeStatsWithHistogram$;
import org.apache.spark.sql.delta.commands.optimize.OptimizeStats;
import org.apache.spark.sql.delta.commands.optimize.OptimizeStats$;
import org.apache.spark.sql.delta.commands.optimize.ZOrderFileStats;
import org.apache.spark.sql.delta.commands.optimize.ZOrderStats;
import org.apache.spark.sql.delta.commands.optimize.ZOrderStats$;
import org.apache.spark.sql.delta.files.SQLMetricsReporting;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.skipping.MultiDimClustering$;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.v2.clickhouse.ClickHouseConfig$;
import org.apache.spark.sql.execution.datasources.v2.clickhouse.metadata.AddMergeTreeParts;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.metric.SQLMetrics$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005%g\u0001\u0002\t\u0012\u0001yA\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\to\u0001\u0011\t\u0011)A\u0005q!AA\b\u0001B\u0001B\u0003%Q\b\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003S\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u001d\u0011\u0007A1A\u0005\n\rDaa\u001a\u0001!\u0002\u0013!\u0007b\u00025\u0001\u0005\u0004%I!\u001b\u0005\u0007[\u0002\u0001\u000b\u0011\u00026\t\u000b9\u0004A\u0011A8\t\u000bQ\u0004A\u0011B;\t\u000f\u0005-\u0001\u0001\"\u0003\u0002\u000e!9\u0011Q\u0005\u0001\u0005\n\u0005\u001d\u0002bBA \u0001\u0011%\u0011\u0011\t\u0005\b\u0003;\u0003A\u0011BAP\u0005Ay\u0005\u000f^5nSj,W\t_3dkR|'O\u0003\u0002\u0013'\u0005A1m\\7nC:$7O\u0003\u0002\u0015+\u0005)A-\u001a7uC*\u0011acF\u0001\u0004gFd'B\u0001\r\u001a\u0003\u0015\u0019\b/\u0019:l\u0015\tQ2$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00029\u0005\u0019qN]4\u0004\u0001M)\u0001aH\u0013*_A\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\t1\u0011I\\=SK\u001a\u0004\"AJ\u0014\u000e\u0003EI!\u0001K\t\u0003\u0019\u0011+G\u000e^1D_6l\u0017M\u001c3\u0011\u0005)jS\"A\u0016\u000b\u00051\u001a\u0012!\u00024jY\u0016\u001c\u0018B\u0001\u0018,\u0005M\u0019\u0016\u000bT'fiJL7m\u001d*fa>\u0014H/\u001b8h!\t\u0001\u0003'\u0003\u00022C\ta1+\u001a:jC2L'0\u00192mK\u0006a1\u000f]1sWN+7o]5p]B\u0011A'N\u0007\u0002+%\u0011a'\u0006\u0002\r'B\f'o[*fgNLwN\\\u0001\u0004ibt\u0007CA\u001d;\u001b\u0005\u0019\u0012BA\u001e\u0014\u0005Uy\u0005\u000f^5nSN$\u0018n\u0019+sC:\u001c\u0018m\u0019;j_:\f!\u0003]1si&$\u0018n\u001c8Qe\u0016$\u0017nY1uKB\u0019aHR%\u000f\u0005}\"eB\u0001!D\u001b\u0005\t%B\u0001\"\u001e\u0003\u0019a$o\\8u}%\t!%\u0003\u0002FC\u00059\u0001/Y2lC\u001e,\u0017BA$I\u0005\r\u0019V-\u001d\u0006\u0003\u000b\u0006\u0002\"AS(\u000e\u0003-S!\u0001T'\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u001dV\t\u0001bY1uC2L8\u000f^\u0005\u0003!.\u0013!\"\u0012=qe\u0016\u001c8/[8o\u0003=QxJ\u001d3fe\nK8i\u001c7v[:\u001c\bc\u0001 G'B\u0011A\u000b\u0017\b\u0003+Z\u0003\"\u0001Q\u0011\n\u0005]\u000b\u0013A\u0002)sK\u0012,g-\u0003\u0002Z5\n11\u000b\u001e:j]\u001eT!aV\u0011\u0002\rqJg.\u001b;?)\u0015ifl\u00181b!\t1\u0003\u0001C\u00033\u000b\u0001\u00071\u0007C\u00038\u000b\u0001\u0007\u0001\bC\u0003=\u000b\u0001\u0007Q\bC\u0003R\u000b\u0001\u0007!+\u0001\npa\u0016\u0014\u0018\r^5p]RKW.Z:uC6\u0004X#\u00013\u0011\u0005\u0001*\u0017B\u00014\"\u0005\u0011auN\\4\u0002'=\u0004XM]1uS>tG+[7fgR\fW\u000e\u001d\u0011\u0002)%\u001cX*\u001e7uS\u0012KWn\u00117vgR,'/\u001b8h+\u0005Q\u0007C\u0001\u0011l\u0013\ta\u0017EA\u0004C_>dW-\u00198\u0002+%\u001cX*\u001e7uS\u0012KWn\u00117vgR,'/\u001b8hA\u0005Aq\u000e\u001d;j[&TX\rF\u0001q!\rqd)\u001d\t\u0003iIL!a]\u000b\u0003\u0007I{w/\u0001\fqeVtWmQ1oI&$\u0017\r^3GS2,G*[:u)\u00151Xp`A\u0005!\rqdi\u001e\t\u0003qnl\u0011!\u001f\u0006\u0003uN\tq!Y2uS>t7/\u0003\u0002}s\n9\u0011\t\u001a3GS2,\u0007\"\u0002@\f\u0001\u0004!\u0017aC7j]\u001aKG.Z*ju\u0016Dq!!\u0001\f\u0001\u0004\t\u0019!A\nnCb$U\r\\3uK\u0012\u0014vn^:SCRLw\u000eE\u0002!\u0003\u000bI1!a\u0002\"\u0005\u0019!u.\u001e2mK\")Af\u0003a\u0001m\u0006\u0011rM]8va\u001aKG.Z:J]R|')\u001b8t)\u0019\ty!!\b\u0002\"A!aHRA\t!\u0019\u0001\u00131CA\fm&\u0019\u0011QC\u0011\u0003\rQ+\b\u000f\\33!\u0015!\u0016\u0011D*T\u0013\r\tYB\u0017\u0002\u0004\u001b\u0006\u0004\bbBA\u0010\u0019\u0001\u0007\u0011qB\u0001\u0014a\u0006\u0014H/\u001b;j_:\u001cHk\\\"p[B\f7\r\u001e\u0005\u0007\u0003Ga\u0001\u0019\u00013\u0002#5\f\u0007\u0010V1sO\u0016$h)\u001b7f'&TX-A\tsk:|\u0005\u000f^5nSj,')\u001b8K_\n$\"\"!\u000b\u00022\u0005M\u0012qGA\u001e!\u0011qd)a\u000b\u0011\u0007a\fi#C\u0002\u00020e\u0014!BR5mK\u0006\u001bG/[8o\u0011\u00159T\u00021\u00019\u0011\u001d\t)$\u0004a\u0001\u0003/\t\u0011\u0002]1si&$\u0018n\u001c8\t\r\u0005eR\u00021\u0001w\u0003\r\u0011\u0017N\u001c\u0005\u0007\u0003{i\u0001\u0019\u00013\u0002\u00175\f\u0007PR5mKNK'0Z\u0001\u000fG>lW.\u001b;B]\u0012\u0014V\r\u001e:z))\t\u0019%!\u0016\u0002X\u0005u\u0014q\u0011\u000b\u0005\u0003\u000b\nY\u0005E\u0002!\u0003\u000fJ1!!\u0013\"\u0005\u0011)f.\u001b;\t\u000f\u00055c\u00021\u0001\u0002P\u0005\ta\rE\u0003!\u0003#B$.C\u0002\u0002T\u0005\u0012\u0011BR;oGRLwN\\\u0019\t\u000b]r\u0001\u0019\u0001\u001d\t\u000f\u0005ec\u00021\u0001\u0002\\\u0005\tr\u000e\u001d;j[&TXm\u00149fe\u0006$\u0018n\u001c8\u0011\t\u0005u\u0013q\u000f\b\u0005\u0003?\n\u0019H\u0004\u0003\u0002b\u0005Ed\u0002BA2\u0003_rA!!\u001a\u0002n9!\u0011qMA6\u001d\r\u0001\u0015\u0011N\u0005\u00029%\u0011!dG\u0005\u00031eI!AF\f\n\u0005Q)\u0012bAA;'\u0005yA)\u001a7uC>\u0003XM]1uS>t7/\u0003\u0003\u0002z\u0005m$!C(qKJ\fG/[8o\u0015\r\t)h\u0005\u0005\u0007u:\u0001\r!a \u0011\ty2\u0015\u0011\u0011\t\u0004q\u0006\r\u0015bAACs\n1\u0011i\u0019;j_:Dq!!#\u000f\u0001\u0004\tY)A\u0004nKR\u0014\u0018nY:\u0011\rQ\u000bIbUAG!\u0011\ty)!'\u000e\u0005\u0005E%\u0002BAJ\u0003+\u000ba!\\3ue&\u001c'bAAL+\u0005IQ\r_3dkRLwN\\\u0005\u0005\u00037\u000b\tJA\u0005T#2kU\r\u001e:jG\u0006i1M]3bi\u0016lU\r\u001e:jGN$\"\"a#\u0002\"\u00065\u0016\u0011WA_\u0011\u001d\t\u0019k\u0004a\u0001\u0003K\u000bAb\u001d9be.\u001cuN\u001c;fqR\u0004B!a*\u0002*6\tq#C\u0002\u0002,^\u0011Ab\u00159be.\u001cuN\u001c;fqRDa!a,\u0010\u0001\u00041\u0018AC1eI\u0016$g)\u001b7fg\"9\u00111W\bA\u0002\u0005U\u0016\u0001\u0004:f[>4X\r\u001a$jY\u0016\u001c\b\u0003\u0002 G\u0003o\u00032\u0001_A]\u0013\r\tY,\u001f\u0002\u000b%\u0016lwN^3GS2,\u0007bBA`\u001f\u0001\u0007\u0011\u0011Y\u0001\u000be\u0016lwN^3e\tZ\u001b\b\u0003\u0002 G\u0003\u0007\u00042\u0001_Ac\u0013\r\t9-\u001f\u0002\u0019\t\u0016dW\r^5p]Z+7\r^8s\t\u0016\u001c8M]5qi>\u0014\b")
public class OptimizeExecutor
implements DeltaCommand,
SQLMetricsReporting,
scala.Serializable {
    private final SparkSession sparkSession;
    private final OptimisticTransaction txn;
    private final Seq<Expression> partitionPredicate;
    private final Seq<String> zOrderByColumns;
    private final long operationTimestamp;
    private final boolean isMultiDimClustering;
    private Map<String, SQLMetric> org$apache$spark$sql$delta$files$SQLMetricsReporting$$operationSQLMetrics;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public void registerSQLMetrics(SparkSession spark, Map<String, SQLMetric> metrics) {
        SQLMetricsReporting.registerSQLMetrics$((SQLMetricsReporting)this, (SparkSession)spark, metrics);
    }

    public Map<String, String> getMetricsForOperation(DeltaOperations.Operation operation) {
        return SQLMetricsReporting.getMetricsForOperation$((SQLMetricsReporting)this, (DeltaOperations.Operation)operation);
    }

    public Option<SQLMetric> getMetric(String name) {
        return SQLMetricsReporting.getMetric$((SQLMetricsReporting)this, (String)name);
    }

    public Seq<Expression> parsePredicates(SparkSession spark, String predicate) {
        return DeltaCommand.parsePredicates$((DeltaCommand)this, (SparkSession)spark, (String)predicate);
    }

    public void verifyPartitionPredicates(SparkSession spark, Seq<String> partitionColumns, Seq<Expression> predicates) {
        DeltaCommand.verifyPartitionPredicates$((DeltaCommand)this, (SparkSession)spark, partitionColumns, predicates);
    }

    public Map<String, AddFile> generateCandidateFileMap(Path basePath, Seq<AddFile> candidateFiles) {
        return DeltaCommand.generateCandidateFileMap$((DeltaCommand)this, (Path)basePath, candidateFiles);
    }

    public Seq<RemoveFile> removeFilesFromPaths(DeltaLog deltaLog, Map<String, AddFile> nameToAddFileMap, Seq<String> filesToRewrite, long operationTimestamp) {
        return DeltaCommand.removeFilesFromPaths$((DeltaCommand)this, (DeltaLog)deltaLog, nameToAddFileMap, filesToRewrite, (long)operationTimestamp);
    }

    public HadoopFsRelation buildBaseRelation(SparkSession spark, OptimisticTransaction txn, String actionType, Path rootPath, Seq<String> inputLeafFiles, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.buildBaseRelation$((DeltaCommand)this, (SparkSession)spark, (OptimisticTransaction)txn, (String)actionType, (Path)rootPath, inputLeafFiles, nameToAddFileMap);
    }

    public AddFile getTouchedFile(Path basePath, String filePath, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.getTouchedFile$((DeltaCommand)this, (Path)basePath, (String)filePath, nameToAddFileMap);
    }

    public LogicalPlan resolveIdentifier(Analyzer analyzer, TableIdentifier identifier) {
        return DeltaCommand.resolveIdentifier$((DeltaCommand)this, (Analyzer)analyzer, (TableIdentifier)identifier);
    }

    public boolean isCatalogTable(Analyzer analyzer, TableIdentifier tableIdent) {
        return DeltaCommand.isCatalogTable$((DeltaCommand)this, (Analyzer)analyzer, (TableIdentifier)tableIdent);
    }

    public boolean isPathIdentifier(TableIdentifier tableIdent) {
        return DeltaCommand.isPathIdentifier$((DeltaCommand)this, (TableIdentifier)tableIdent);
    }

    public DeltaLog getDeltaLog(SparkSession spark, Option<String> path, Option<TableIdentifier> tableIdentifier, String operationName, Map<String, String> hadoopConf) {
        return DeltaCommand.getDeltaLog$((DeltaCommand)this, (SparkSession)spark, path, tableIdentifier, (String)operationName, hadoopConf);
    }

    public Map<String, String> getDeltaLog$default$5() {
        return DeltaCommand.getDeltaLog$default$5$((DeltaCommand)this);
    }

    public void sendDriverMetrics(SparkSession spark, Map<String, SQLMetric> metrics) {
        DeltaCommand.sendDriverMetrics$((DeltaCommand)this, (SparkSession)spark, metrics);
    }

    public boolean hasBeenExecuted(OptimisticTransaction txn, SparkSession sparkSession, Option<DeltaOptions> options) {
        return DeltaCommand.hasBeenExecuted$((DeltaCommand)this, (OptimisticTransaction)txn, (SparkSession)sparkSession, options);
    }

    public Option<DeltaOptions> hasBeenExecuted$default$3() {
        return DeltaCommand.hasBeenExecuted$default$3$((DeltaCommand)this);
    }

    public Option<SetTransaction> createSetTransaction(SparkSession sparkSession, DeltaLog deltaLog, Option<DeltaOptions> options) {
        return DeltaCommand.createSetTransaction$((DeltaCommand)this, (SparkSession)sparkSession, (DeltaLog)deltaLog, options);
    }

    public Option<DeltaOptions> createSetTransaction$default$3() {
        return DeltaCommand.createSetTransaction$default$3$((DeltaCommand)this);
    }

    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$((DeltaLogging)this, (DeltaLog)deltaLog, (String)opType, tags, (Object)data, path);
    }

    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$((DeltaLogging)this);
    }

    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$((DeltaLogging)this);
    }

    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$((DeltaLogging)this);
    }

    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$((DeltaLogging)this, (String)tablePath, (String)opType, tags, thunk);
    }

    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$((DeltaLogging)this);
    }

    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$((DeltaLogging)this, (DeltaLog)deltaLog, (String)opType, tags, thunk);
    }

    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$((DeltaLogging)this);
    }

    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$((DeltaLogging)this, (String)group, (String)name, thunk);
    }

    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$((DeltaLogging)this, (DeltaLog)deltaLog, (String)tahoeId);
    }

    public void logConsole(String line) {
        DatabricksLogging.logConsole$((DatabricksLogging)this, (String)line);
    }

    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$((DatabricksLogging)this, (MetricDefinition)metric, (double)quantity, additionalTags, (String)blob, (boolean)forceSample, (boolean)trimBlob, (boolean)silent);
    }

    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$((DatabricksLogging)this);
    }

    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$((DatabricksLogging)this);
    }

    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$((DatabricksLogging)this);
    }

    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$((DatabricksLogging)this);
    }

    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$((DatabricksLogging)this);
    }

    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$((DatabricksLogging)this, (MetricDefinition)metric, additionalTags, (String)blob, (boolean)trimBlob);
    }

    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$((DatabricksLogging)this);
    }

    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$((DatabricksLogging)this);
    }

    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$((DatabricksLogging)this);
    }

    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$((DatabricksLogging)this, (OpType)opType, (String)opTarget, extraTags, (boolean)isSynchronous, (boolean)alwaysRecordStats, (boolean)allowAuthTags, (boolean)killJvmIfStuck, (MetricDefinition)outputMetric, (boolean)silent, thunk);
    }

    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$((DatabricksLogging)this);
    }

    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$((DatabricksLogging)this);
    }

    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$((DatabricksLogging)this);
    }

    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$((DatabricksLogging)this);
    }

    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$((DatabricksLogging)this);
    }

    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$((DatabricksLogging)this);
    }

    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$((DatabricksLogging)this);
    }

    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$((DatabricksLogging)this, (MetricDefinition)metric, (double)quantity, additionalTags, (String)blob, (boolean)forceSample, (boolean)trimBlob, (boolean)silent);
    }

    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$((DatabricksLogging)this);
    }

    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$((DatabricksLogging)this);
    }

    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$((DatabricksLogging)this);
    }

    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$((DatabricksLogging)this);
    }

    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$((DatabricksLogging)this);
    }

    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$((DatabricksLogging)this, (MetricDefinition)metric, additionalTags, (String)blob, (boolean)trimBlob);
    }

    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$((DatabricksLogging)this);
    }

    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$((DatabricksLogging)this);
    }

    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$((DatabricksLogging)this);
    }

    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$((DeltaProgressReporter)this, (String)statusCode, (String)defaultMessage, data, body);
    }

    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$((DeltaProgressReporter)this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Map<String, SQLMetric> org$apache$spark$sql$delta$files$SQLMetricsReporting$$operationSQLMetrics() {
        return this.org$apache$spark$sql$delta$files$SQLMetricsReporting$$operationSQLMetrics;
    }

    public void org$apache$spark$sql$delta$files$SQLMetricsReporting$$operationSQLMetrics_$eq(Map<String, SQLMetric> x$1) {
        this.org$apache$spark$sql$delta$files$SQLMetricsReporting$$operationSQLMetrics = x$1;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private long operationTimestamp() {
        return this.operationTimestamp;
    }

    private boolean isMultiDimClustering() {
        return this.isMultiDimClustering;
    }

    public Seq<Row> optimize() {
        Seq seq;
        Object object = new Object();
        try {
            seq = (Seq)this.recordDeltaOperation(this.txn.deltaLog(), "delta.optimize", this.recordDeltaOperation$default$3(), (Function0 & Serializable & scala.Serializable)() -> {
                Tuple2 tuple2;
                Tuple2 tuple22;
                boolean isMergeTreeFormat = ClickHouseConfig$.MODULE$.isMergeTreeFormatEngine((Map<String, String>)$this.txn.deltaLog().unsafeVolatileMetadata().configuration());
                long minFileSize = BoxesRunTime.unboxToLong((Object)$this.sparkSession.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_OPTIMIZE_MIN_FILE_SIZE()));
                long maxFileSize = BoxesRunTime.unboxToLong((Object)$this.sparkSession.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_OPTIMIZE_MAX_FILE_SIZE()));
                Predef$.MODULE$.require(minFileSize > 0L, (Function0 & Serializable & scala.Serializable)() -> "minFileSize must be > 0");
                Predef$.MODULE$.require(maxFileSize > 0L, (Function0 & Serializable & scala.Serializable)() -> "maxFileSize must be > 0");
                Seq candidateFiles = $this.txn.filterFiles($this.partitionPredicate, true);
                StructType partitionSchema = $this.txn.metadata().partitionSchema();
                double maxDeletedRowsRatio = BoxesRunTime.unboxToDouble((Object)$this.sparkSession.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_OPTIMIZE_MAX_DELETED_ROWS_RATIO()));
                Seq<AddFile> filesToProcess = this.pruneCandidateFileList(minFileSize, maxDeletedRowsRatio, (Seq<AddFile>)candidateFiles);
                int maxThreads = BoxesRunTime.unboxToInt((Object)$this.sparkSession.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_OPTIMIZE_MAX_THREADS()));
                if (isMergeTreeFormat) {
                    Seq partitionsToCompact = filesToProcess.groupBy((Function1 & Serializable & scala.Serializable)file -> new Tuple2((Object)((AddMergeTreeParts)((Object)((Object)file))).bucketNum(), (Object)file.partitionValues())).toSeq();
                    Seq<Tuple2<Tuple2<String, Map<String, String>>, Seq<AddFile>>> jobs = OptimizeTableCommandOverwrites$.MODULE$.groupFilesIntoBinsClickhouse((Seq<Tuple2<Tuple2<String, Map<String, String>>, Seq<AddFile>>>)partitionsToCompact, maxFileSize);
                    tuple22 = new Tuple2((Object)ThreadUtils$.MODULE$.parmap(jobs, "OptimizeJob", maxThreads, (Function1 & Serializable & scala.Serializable)partitionBinGroup -> OptimizeTableCommandOverwrites$.MODULE$.runOptimizeBinJobClickhouse($this.txn, (Map<String, String>)((Map)((Tuple2)partitionBinGroup._1())._2()), (String)((Tuple2)partitionBinGroup._1())._1(), (Seq<AddFile>)((Seq)partitionBinGroup._2()), maxFileSize)).flatten((Function1)Predef$.MODULE$.$conforms()), jobs);
                } else {
                    Seq partitionsToCompact = filesToProcess.groupBy((Function1 & Serializable & scala.Serializable)x$4 -> x$4.partitionValues()).toSeq();
                    Seq<Tuple2<Map<String, String>, Seq<AddFile>>> jobs = this.groupFilesIntoBins((Seq<Tuple2<Map<String, String>, Seq<AddFile>>>)partitionsToCompact, maxFileSize);
                    tuple22 = tuple2 = new Tuple2((Object)ThreadUtils$.MODULE$.parmap(jobs, "OptimizeJob", maxThreads, (Function1 & Serializable & scala.Serializable)partitionBinGroup -> this.runOptimizeBinJob($this.txn, (Map<String, String>)((Map)partitionBinGroup._1()), (Seq<AddFile>)((Seq)partitionBinGroup._2()), maxFileSize)).flatten((Function1)Predef$.MODULE$.$conforms()), jobs);
                }
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Seq updates = (Seq)tuple2._1();
                Seq jobs = (Seq)tuple2._2();
                Tuple2 tuple23 = new Tuple2((Object)updates, (Object)jobs);
                Tuple2 tuple24 = tuple23;
                Seq updates2 = (Seq)tuple24._1();
                Seq jobs2 = (Seq)tuple24._2();
                Seq addedFiles = (Seq)updates2.collect((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends FileAction, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        AddFile addFile;
                        A1 A1 = x1;
                        Object object = A1 instanceof AddFile ? (addFile = (AddFile)A1) : function1.apply(x1);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(FileAction x1) {
                        FileAction fileAction = x1;
                        boolean bl = fileAction instanceof AddFile;
                        return bl;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Seq removedFiles = (Seq)updates2.collect((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends FileAction, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        RemoveFile removeFile;
                        A1 A1 = x2;
                        Object object = A1 instanceof RemoveFile ? (removeFile = (RemoveFile)A1) : function1.apply(x2);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(FileAction x2) {
                        FileAction fileAction = x2;
                        boolean bl = fileAction instanceof RemoveFile;
                        return bl;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Seq removedDVs = ((SeqLike)((TraversableLike)filesToProcess.filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)OptimizeExecutor.$anonfun$optimize$8(x$6)))).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.deletionVector(), Seq$.MODULE$.canBuildFrom())).toSeq();
                if (addedFiles.size() > 0) {
                    DeltaOperations.Optimize operation = new DeltaOperations.Optimize((Seq)$this.partitionPredicate.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.sql(), Seq$.MODULE$.canBuildFrom()), $this.zOrderByColumns);
                    Map<String, SQLMetric> metrics = this.createMetrics($this.sparkSession.sparkContext(), (Seq<AddFile>)addedFiles, (Seq<RemoveFile>)removedFiles, (Seq<DeletionVectorDescriptor>)removedDVs);
                    this.commitAndRetry($this.txn, (DeltaOperations.Operation)operation, (Seq<Action>)updates2, metrics, (Function1<OptimisticTransaction, Object>)(Function1 & Serializable & scala.Serializable)newTxn -> BoxesRunTime.boxToBoolean((boolean)OptimizeExecutor.$anonfun$optimize$11(this, candidateFiles, partitionSchema, newTxn)));
                }
                OptimizeStats optimizeStats = new OptimizeStats(OptimizeStats$.MODULE$.apply$default$1(), OptimizeStats$.MODULE$.apply$default$2(), OptimizeStats$.MODULE$.apply$default$3(), OptimizeStats$.MODULE$.apply$default$4(), OptimizeStats$.MODULE$.apply$default$5(), OptimizeStats$.MODULE$.apply$default$6(), OptimizeStats$.MODULE$.apply$default$7(), OptimizeStats$.MODULE$.apply$default$8(), OptimizeStats$.MODULE$.apply$default$9(), OptimizeStats$.MODULE$.apply$default$10(), OptimizeStats$.MODULE$.apply$default$11(), OptimizeStats$.MODULE$.apply$default$12(), OptimizeStats$.MODULE$.apply$default$13(), OptimizeStats$.MODULE$.apply$default$14(), OptimizeStats$.MODULE$.apply$default$15(), OptimizeStats$.MODULE$.apply$default$16(), OptimizeStats$.MODULE$.apply$default$17(), OptimizeStats$.MODULE$.apply$default$18());
                optimizeStats.addedFilesSizeStats().merge(addedFiles);
                optimizeStats.removedFilesSizeStats().merge(removedFiles);
                optimizeStats.numPartitionsOptimized_$eq((long)((SeqLike)((SeqLike)jobs2.map((Function1 & Serializable & scala.Serializable)j -> j._1(), Seq$.MODULE$.canBuildFrom())).distinct()).size());
                optimizeStats.numBatches_$eq((long)jobs2.size());
                optimizeStats.totalConsideredFiles_$eq((long)candidateFiles.size());
                optimizeStats.totalFilesSkipped_$eq(optimizeStats.totalConsideredFiles() - (long)removedFiles.size());
                optimizeStats.totalClusterParallelism_$eq((long)$this.sparkSession.sparkContext().defaultParallelism());
                int numTableColumns = $this.txn.snapshot().metadata().schema().size();
                optimizeStats.numTableColumns_$eq((long)numTableColumns);
                optimizeStats.numTableColumnsWithStats_$eq((long)RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)DeltaConfigs$.MODULE$.DATA_SKIPPING_NUM_INDEXED_COLS().fromMetaData($this.txn.snapshot().metadata()))), numTableColumns));
                if (removedDVs.size() > 0) {
                    optimizeStats.deletionVectorStats_$eq((Option)new Some((Object)new DeletionVectorStats((long)removedDVs.size(), BoxesRunTime.unboxToLong((Object)((TraversableOnce)removedDVs.map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.cardinality()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)))));
                }
                if (this.isMultiDimClustering()) {
                    ZOrderFileStats inputFileStats = new ZOrderFileStats((long)removedFiles.size(), BoxesRunTime.unboxToLong((Object)((TraversableOnce)removedFiles.map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)OptimizeExecutor.$anonfun$optimize$17(x$12)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
                    optimizeStats.zOrderStats_$eq((Option)new Some((Object)new ZOrderStats("all", new ZOrderFileStats(0L, 0L), inputFileStats, 0L, inputFileStats, optimizeStats.numPartitionsOptimized(), ZOrderStats$.MODULE$.apply$default$7())));
                }
                throw new NonLocalReturnControl(object, (Object)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.txn.deltaLog().dataPath().toString(), optimizeStats.toOptimizeMetrics()})), (List)Nil$.MODULE$));
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                seq = (Seq)ex.value();
            }
            throw ex;
        }
        return seq;
    }

    private Seq<AddFile> pruneCandidateFileList(long minFileSize, double maxDeletedRowsRatio, Seq<AddFile> files) {
        if (this.isMultiDimClustering()) {
            return files;
        }
        return (Seq)files.filter((Function1 & Serializable & scala.Serializable)addFile -> BoxesRunTime.boxToBoolean((boolean)OptimizeExecutor.$anonfun$pruneCandidateFileList$2(minFileSize, maxDeletedRowsRatio, addFile)));
    }

    private Seq<Tuple2<Map<String, String>, Seq<AddFile>>> groupFilesIntoBins(Seq<Tuple2<Map<String, String>, Seq<AddFile>>> partitionsToCompact, long maxTargetFileSize) {
        return (Seq)partitionsToCompact.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Map partition = (Map)tuple2._1();
            Seq files = (Seq)tuple2._2();
            ArrayBuffer bins = new ArrayBuffer();
            ArrayBuffer currentBin = new ArrayBuffer();
            LongRef currentBinSize = LongRef.create((long)0L);
            ((IterableLike)files.sortBy((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.size()), (Ordering)Ordering.Long$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)file -> {
                OptimizeExecutor.$anonfun$groupFilesIntoBins$3(this, currentBinSize, maxTargetFileSize, bins, currentBin, file);
                return BoxedUnit.UNIT;
            });
            Object object = currentBin.nonEmpty() ? bins.$plus$eq((Object)currentBin.toVector()) : BoxedUnit.UNIT;
            ArrayBuffer arrayBuffer = (ArrayBuffer)((TraversableLike)bins.filter((Function1 & Serializable & scala.Serializable)bin -> BoxesRunTime.boxToBoolean((boolean)OptimizeExecutor.$anonfun$groupFilesIntoBins$4(this, bin)))).map((Function1 & Serializable & scala.Serializable)b -> new Tuple2((Object)partition, b), ArrayBuffer$.MODULE$.canBuildFrom());
            return arrayBuffer;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<FileAction> runOptimizeBinJob(OptimisticTransaction txn, Map<String, String> partition, Seq<AddFile> bin, long maxFileSize) {
        Dataset dataset;
        Path baseTablePath = txn.deltaLog().dataPath();
        Snapshot x$1 = txn.snapshot();
        Seq<AddFile> x$2 = bin;
        Some x$3 = new Some((Object)"Optimize");
        boolean x$4 = txn.deltaLog().createDataFrame$default$3();
        Dataset<Row> input = txn.deltaLog().createDataFrame(x$1, x$2, x$4, (Option<String>)x$3);
        if (this.isMultiDimClustering()) {
            long totalSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)bin.map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.size()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            int approxNumFiles = (int)Math.max(1L, totalSize / maxFileSize);
            dataset = MultiDimClustering$.MODULE$.cluster(input, approxNumFiles, this.zOrderByColumns);
        } else {
            boolean useRepartition = BoxesRunTime.unboxToBoolean((Object)this.sparkSession.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_OPTIMIZE_REPARTITION_ENABLED()));
            dataset = useRepartition ? input.repartition(1) : input.coalesce(1);
        }
        Dataset repartitionDF = dataset;
        String partitionDesc = ((TraversableOnce)partition.toSeq().map((Function1 & Serializable & scala.Serializable)entry -> new StringBuilder(1).append((String)entry._1()).append("=").append(entry._2()).toString(), Seq$.MODULE$.canBuildFrom())).mkString(",");
        String partitionName = partition.isEmpty() ? "" : new StringBuilder(16).append(" in partition (").append(partitionDesc).append(")").toString();
        String description = new StringBuilder(22).append(baseTablePath).append("<br/>Optimizing ").append(bin.size()).append(" files").append(partitionName).toString();
        this.sparkSession.sparkContext().setJobGroup(this.sparkSession.sparkContext().getLocalProperty(SparkContext$.MODULE$.SPARK_JOB_GROUP_ID()), description, this.sparkSession.sparkContext().setJobGroup$default$3());
        Seq addFiles = (Seq)txn.writeFiles(repartitionDF).collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends FileAction, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (!(A1 instanceof AddFile)) {
                    throw new IllegalStateException(new StringBuilder(82).append("Unexpected action ").append(A1).append(" with type ").append(A1.getClass()).append(". File compaction job output").append("should only have AddFiles").toString());
                }
                AddFile addFile = (AddFile)A1;
                boolean x$1 = false;
                String x$2 = addFile.copy$default$1();
                Map x$3 = addFile.copy$default$2();
                long x$4 = addFile.copy$default$3();
                long x$5 = addFile.copy$default$4();
                String x$6 = addFile.copy$default$6();
                Map x$7 = addFile.copy$default$7();
                DeletionVectorDescriptor x$8 = addFile.copy$default$8();
                AddFile addFile2 = addFile.copy(x$2, x$3, x$4, x$5, x$1, x$6, x$7, x$8);
                return (B1)addFile2;
            }

            public final boolean isDefinedAt(FileAction x1) {
                FileAction fileAction = x1;
                boolean bl = fileAction instanceof AddFile ? true : true;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq removeFiles = (Seq)bin.map((Function1 & Serializable & scala.Serializable)f -> f.removeWithTimestamp(this.operationTimestamp(), false), Seq$.MODULE$.canBuildFrom());
        Seq updates = (Seq)addFiles.$plus$plus((GenTraversableOnce)removeFiles, Seq$.MODULE$.canBuildFrom());
        return updates;
    }

    private void commitAndRetry(OptimisticTransaction txn, DeltaOperations.Operation optimizeOperation, Seq<Action> actions, Map<String, SQLMetric> metrics, Function1<OptimisticTransaction, Object> f) {
        while (true) {
            try {
                txn.registerSQLMetrics(this.sparkSession, metrics);
                txn.commit(actions, optimizeOperation);
            }
            catch (ConcurrentModificationException e) {
                OptimisticTransaction newTxn = txn.deltaLog().startTransaction();
                if (BoxesRunTime.unboxToBoolean((Object)f.apply((Object)newTxn))) {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Retrying commit after checking for semantic conflicts with concurrent updates.");
                    txn = newTxn;
                    continue;
                }
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Semantic conflicts detected. Aborting operation.");
                throw e;
            }
            break;
        }
    }

    private Map<String, SQLMetric> createMetrics(SparkContext sparkContext, Seq<AddFile> addedFiles, Seq<RemoveFile> removedFiles, Seq<DeletionVectorDescriptor> removedDVs) {
        Tuple2 tuple2 = (Tuple2)((TraversableOnce)removedDVs.map((Function1 & Serializable & scala.Serializable)dv -> new Tuple2.mcJJ.sp(dv.cardinality(), (long)dv.sizeInBytes()), Seq$.MODULE$.canBuildFrom())).reduceLeftOption((Function2 & Serializable & scala.Serializable)(dv1, dv2) -> new Tuple2.mcJJ.sp(dv1._1$mcJ$sp() + dv2._1$mcJ$sp(), dv1._2$mcJ$sp() + dv2._2$mcJ$sp())).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Tuple2.mcJJ.sp(0L, 0L));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long deletionVectorRowsRemoved = tuple2._1$mcJ$sp();
        long deletionVectorBytesRemoved = tuple2._2$mcJ$sp();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(deletionVectorRowsRemoved, deletionVectorBytesRemoved);
        Tuple2.mcJJ.sp sp3 = sp2;
        long deletionVectorRowsRemoved2 = sp3._1$mcJ$sp();
        long deletionVectorBytesRemoved2 = sp3._2$mcJ$sp();
        Map dvMetrics = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numDeletionVectorsRemoved"), (Object)OptimizeExecutor.setAndReturnMetric$1("total number of deletion vectors removed", removedDVs.size(), sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numDeletionVectorRowsRemoved"), (Object)OptimizeExecutor.setAndReturnMetric$1("total number of deletion vector rows removed", deletionVectorRowsRemoved2, sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numDeletionVectorBytesRemoved"), (Object)OptimizeExecutor.setAndReturnMetric$1("total number of bytes of removed deletion vectors", deletionVectorBytesRemoved2, sparkContext))}));
        Option sizeStats = FileSizeStatsWithHistogram$.MODULE$.create((Seq)((SeqLike)addedFiles.map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToLong((long)x$16.size()), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Long$.MODULE$));
        return ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"minFileSize"), (Object)OptimizeExecutor.setAndReturnMetric$1("minimum file size", ((FileSizeStatsWithHistogram)sizeStats.get()).min(), sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p25FileSize"), (Object)OptimizeExecutor.setAndReturnMetric$1("25th percentile file size", ((FileSizeStatsWithHistogram)sizeStats.get()).p25(), sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p50FileSize"), (Object)OptimizeExecutor.setAndReturnMetric$1("50th percentile file size", ((FileSizeStatsWithHistogram)sizeStats.get()).p50(), sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p75FileSize"), (Object)OptimizeExecutor.setAndReturnMetric$1("75th percentile file size", ((FileSizeStatsWithHistogram)sizeStats.get()).p75(), sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxFileSize"), (Object)OptimizeExecutor.setAndReturnMetric$1("maximum file size", ((FileSizeStatsWithHistogram)sizeStats.get()).max(), sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numAddedFiles"), (Object)OptimizeExecutor.setAndReturnMetric$1("total number of files added.", addedFiles.size(), sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numRemovedFiles"), (Object)OptimizeExecutor.setAndReturnMetric$1("total number of files removed.", removedFiles.size(), sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numAddedBytes"), (Object)OptimizeExecutor.setAndReturnMetric$1("total number of bytes added", OptimizeExecutor.totalSize$1(addedFiles), sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numRemovedBytes"), (Object)OptimizeExecutor.setAndReturnMetric$1("total number of bytes removed", OptimizeExecutor.totalSize$1(removedFiles), sparkContext))}))).$plus$plus((GenTraversableOnce)dvMetrics);
    }

    public static final /* synthetic */ boolean $anonfun$optimize$8(AddFile x$6) {
        return x$6.deletionVector() != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$optimize$11(OptimizeExecutor $this, Seq candidateFiles$1, StructType partitionSchema$1, OptimisticTransaction newTxn) {
        Set candidateSetNew;
        StructType newPartitionSchema = newTxn.metadata().partitionSchema();
        Set candidateSetOld = ((TraversableOnce)candidateFiles$1.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.path(), Seq$.MODULE$.canBuildFrom())).toSet();
        if (candidateSetOld.subsetOf((GenSet)(candidateSetNew = ((TraversableOnce)newTxn.filterFiles($this.partitionPredicate, newTxn.filterFiles$default$2()).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.path(), Seq$.MODULE$.canBuildFrom())).toSet()))) {
            StructType structType = partitionSchema$1;
            StructType structType2 = newPartitionSchema;
            if (structType == null) {
                if (structType2 == null) return true;
            } else if (structType.equals(structType2)) {
                return true;
            }
        }
        Set deleted = (Set)candidateSetOld.$minus$minus((GenTraversableOnce)candidateSetNew);
        $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(86).append("The following compacted files were delete ").append("during checkpoint ").append(deleted.mkString(",")).append(". Aborting the compaction.").toString());
        return false;
    }

    public static final /* synthetic */ long $anonfun$optimize$17(RemoveFile x$12) {
        return BoxesRunTime.unboxToLong((Object)x$12.size().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    private static final boolean shouldCompactBecauseOfDeletedRows$1(AddFile file, double maxDeletedRowsRatio$1) {
        return file.deletionVector() != null && file.numPhysicalRecords().isEmpty() || BoxesRunTime.unboxToDouble((Object)file.deletedToPhysicalRecordsRatio().getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0)) > maxDeletedRowsRatio$1;
    }

    public static final /* synthetic */ boolean $anonfun$pruneCandidateFileList$2(long minFileSize$1, double maxDeletedRowsRatio$1, AddFile addFile) {
        return addFile.size() < minFileSize$1 || OptimizeExecutor.shouldCompactBecauseOfDeletedRows$1(addFile, maxDeletedRowsRatio$1);
    }

    public static final /* synthetic */ void $anonfun$groupFilesIntoBins$3(OptimizeExecutor $this, LongRef currentBinSize$1, long maxTargetFileSize$1, ArrayBuffer bins$1, ArrayBuffer currentBin$1, AddFile file) {
        if (file.size() + currentBinSize$1.elem > maxTargetFileSize$1 && !$this.isMultiDimClustering()) {
            bins$1.$plus$eq((Object)currentBin$1.toVector());
            currentBin$1.clear();
            currentBin$1.$plus$eq((Object)file);
            currentBinSize$1.elem = file.size();
        } else {
            currentBin$1.$plus$eq((Object)file);
            currentBinSize$1.elem += file.size();
        }
    }

    public static final /* synthetic */ boolean $anonfun$groupFilesIntoBins$4(OptimizeExecutor $this, Seq bin) {
        return bin.size() > 1 || bin.size() == 1 && ((AddFile)bin.apply(0)).deletionVector() != null || $this.isMultiDimClustering();
    }

    private static final SQLMetric setAndReturnMetric$1(String description, long value, SparkContext sparkContext$1) {
        SQLMetric metric = SQLMetrics$.MODULE$.createMetric(sparkContext$1, description);
        metric.set(value);
        return metric;
    }

    public static final /* synthetic */ void $anonfun$createMetrics$1(LongRef totalSize$2, FileAction file) {
        long l;
        FileAction fileAction = file;
        if (fileAction instanceof AddFile) {
            AddFile addFile = (AddFile)fileAction;
            l = addFile.size();
        } else if (fileAction instanceof RemoveFile) {
            RemoveFile removeFile = (RemoveFile)fileAction;
            l = BoxesRunTime.unboxToLong((Object)removeFile.size().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        } else {
            throw new IllegalArgumentException(new StringBuilder(25).append("Unknown FileAction type: ").append(fileAction.getClass()).toString());
        }
        long fileSize = l;
        totalSize$2.elem += fileSize;
    }

    private static final long totalSize$1(Seq actions) {
        LongRef totalSize = LongRef.create((long)0L);
        actions.foreach((Function1 & Serializable & scala.Serializable)file -> {
            OptimizeExecutor.$anonfun$createMetrics$1(totalSize, file);
            return BoxedUnit.UNIT;
        });
        return totalSize.elem;
    }

    public OptimizeExecutor(SparkSession sparkSession, OptimisticTransaction txn, Seq<Expression> partitionPredicate, Seq<String> zOrderByColumns) {
        this.sparkSession = sparkSession;
        this.txn = txn;
        this.partitionPredicate = partitionPredicate;
        this.zOrderByColumns = zOrderByColumns;
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$((DeltaProgressReporter)this);
        DatabricksLogging.$init$((DatabricksLogging)this);
        DeltaLogging.$init$((DeltaLogging)this);
        DeltaCommand.$init$((DeltaCommand)this);
        SQLMetricsReporting.$init$((SQLMetricsReporting)this);
        this.operationTimestamp = new SystemClock().getTimeMillis();
        this.isMultiDimClustering = zOrderByColumns.nonEmpty();
    }
}

