/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.lang.Nullable;
import springfox.documentation.schema.CollectionType;
import springfox.documentation.schema.Maps;

public class Collections {
    private Collections() {
        throw new UnsupportedOperationException();
    }

    public static ResolvedType collectionElementType(ResolvedType type) {
        if (List.class.isAssignableFrom(type.getErasedType())) {
            return Collections.elementType(type, List.class);
        }
        if (Set.class.isAssignableFrom(type.getErasedType())) {
            return Collections.elementType(type, Set.class);
        }
        if (type.isArray()) {
            return type.getArrayElementType();
        }
        if (Collection.class.isAssignableFrom(type.getErasedType()) && !Maps.isMapType(type)) {
            return Collections.elementType(type, Collection.class);
        }
        return null;
    }

    public static boolean isContainerType(@Nullable ResolvedType type) {
        if (type == null) {
            return false;
        }
        return List.class.isAssignableFrom(type.getErasedType()) || Set.class.isAssignableFrom(type.getErasedType()) || Collection.class.isAssignableFrom(type.getErasedType()) && !Maps.isMapType(type) || type.isArray();
    }

    public static String containerType(ResolvedType type) {
        if (List.class.isAssignableFrom(type.getErasedType())) {
            return "List";
        }
        if (Set.class.isAssignableFrom(type.getErasedType())) {
            return "Set";
        }
        if (type.isArray()) {
            return "Array";
        }
        if (Collection.class.isAssignableFrom(type.getErasedType()) && !Maps.isMapType(type)) {
            return "List";
        }
        throw new UnsupportedOperationException(String.format("Type is not collection type %s", type));
    }

    public static CollectionType collectionType(ResolvedType type) {
        if (List.class.isAssignableFrom(type.getErasedType())) {
            return CollectionType.LIST;
        }
        if (Set.class.isAssignableFrom(type.getErasedType())) {
            return CollectionType.SET;
        }
        if (type.isArray()) {
            return CollectionType.ARRAY;
        }
        if (Collection.class.isAssignableFrom(type.getErasedType()) && !Maps.isMapType(type)) {
            return CollectionType.LIST;
        }
        throw new UnsupportedOperationException(String.format("Type is not collection type %s", type));
    }

    private static <T extends Collection> ResolvedType elementType(ResolvedType container, Class<T> collectionType) {
        List resolvedTypes = container.typeParametersFor(collectionType);
        if (resolvedTypes.size() == 1) {
            return (ResolvedType)resolvedTypes.get(0);
        }
        return new TypeResolver().resolve(Object.class, new Type[0]);
    }
}

