/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.client.file.FileSystemContext;
import alluxio.client.meta.RetryHandlingMetaMasterConfigClient;
import alluxio.exception.status.UnavailableException;
import alluxio.heartbeat.HeartbeatExecutor;
import alluxio.master.MasterClientContext;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.wire.ConfigHash;
import java.io.IOException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ConfigHashSync
implements HeartbeatExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigHashSync.class);
    private final FileSystemContext mContext;
    private volatile RetryHandlingMetaMasterConfigClient mClient;
    private volatile IOException mException;

    public ConfigHashSync(FileSystemContext context) {
        this.mContext = context;
        this.mClient = new RetryHandlingMetaMasterConfigClient(this.mContext.getMasterClientContext());
    }

    public void resetMetaMasterConfigClient(MasterClientContext context) {
        this.mClient.close();
        this.mClient = new RetryHandlingMetaMasterConfigClient(context);
    }

    public Optional<IOException> getException() {
        if (this.mException == null) {
            return Optional.empty();
        }
        return Optional.of(this.mException);
    }

    @Override
    public synchronized void heartbeat() {
        boolean isPathConfUpdated;
        ConfigHash hash;
        if (!this.mContext.getClientContext().getClusterConf().clusterDefaultsLoaded()) {
            return;
        }
        try {
            hash = this.mClient.getConfigHash();
        }
        catch (IOException e) {
            LOG.error("Failed to heartbeat to meta master to get configuration hash:", (Throwable)e);
            this.mClient.disconnect();
            return;
        }
        boolean isClusterConfUpdated = !hash.getClusterConfigHash().equals(this.mContext.getClientContext().getClusterConfHash());
        boolean bl = isPathConfUpdated = !hash.getPathConfigHash().equals(this.mContext.getClientContext().getPathConfHash());
        if (isClusterConfUpdated || isPathConfUpdated) {
            try {
                this.mContext.reinit(isClusterConfUpdated, isPathConfUpdated);
                this.mException = null;
            }
            catch (UnavailableException e) {
                LOG.error("Failed to reinitialize FileSystemContext:", (Throwable)e);
            }
            catch (IOException e) {
                LOG.error("Failed to close FileSystemContext, interrupting the heartbeat thread", (Throwable)e);
                this.mException = e;
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void close() {
        this.mClient.close();
    }
}

