/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.client.file.cache.DefaultMetaStore;
import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.PageInfo;
import alluxio.client.file.cache.QuotaMetaStore;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.PageNotFoundException;

public interface MetaStore {
    public static MetaStore create(AlluxioConfiguration conf) {
        if (conf.getBoolean(PropertyKey.USER_CLIENT_CACHE_QUOTA_ENABLED)) {
            return new QuotaMetaStore(conf);
        }
        return new DefaultMetaStore(conf);
    }

    public boolean hasPage(PageId var1);

    public void addPage(PageId var1, PageInfo var2);

    public PageInfo getPageInfo(PageId var1) throws PageNotFoundException;

    public PageInfo removePage(PageId var1) throws PageNotFoundException;

    public long bytes();

    public long pages();

    public void reset();

    public PageInfo evict();
}

