/*
 * Decompiled with CFR 0.152.
 */
package alluxio.concurrent;

import alluxio.annotation.SuppressFBWarnings;
import alluxio.concurrent.ForwardingLock;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class WeakSafeReentrantReadWriteLock
implements ReadWriteLock {
    private final ReentrantReadWriteLock mDelegate = new ReentrantReadWriteLock();

    @Override
    public Lock readLock() {
        return new WeakSafeLock(this.mDelegate.readLock(), this);
    }

    @Override
    public Lock writeLock() {
        return new WeakSafeLock(this.mDelegate.writeLock(), this);
    }

    public int getReadHoldCount() {
        return this.mDelegate.getReadHoldCount();
    }

    public int getWriteHoldCount() {
        return this.mDelegate.getWriteHoldCount();
    }

    private static final class WeakSafeLock
    extends ForwardingLock {
        private final Lock mDelegate;
        @SuppressFBWarnings(value={"URF_UNREAD_FIELD"}, justification="We just want a reference to prevent gc")
        private final WeakSafeReentrantReadWriteLock mStrongReference;

        WeakSafeLock(Lock delegate, WeakSafeReentrantReadWriteLock strongReference) {
            this.mDelegate = delegate;
            this.mStrongReference = strongReference;
        }

        @Override
        Lock delegate() {
            return this.mDelegate;
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException("newCondition is not currently supported");
        }
    }
}

