/*
 * Decompiled with CFR 0.152.
 */
package alluxio.grpc;

import alluxio.grpc.BlockWorkerGrpc;
import alluxio.grpc.Chunk;
import alluxio.grpc.DataMessage;
import alluxio.grpc.DataMessageMarshaller;
import alluxio.grpc.GrpcSerializationUtils;
import alluxio.grpc.ReadResponse;
import alluxio.grpc.ReadableDataBuffer;
import alluxio.network.protocol.databuffer.DataBuffer;
import alluxio.network.protocol.databuffer.NettyDataBuffer;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.protobuf.CodedOutputStream;
import alluxio.shaded.client.com.google.protobuf.UnsafeByteOperations;
import alluxio.shaded.client.io.grpc.internal.ReadableBuffer;
import alluxio.shaded.client.io.grpc.internal.ReadableBuffers;
import alluxio.shaded.client.io.netty.buffer.ByteBuf;
import alluxio.shaded.client.io.netty.buffer.Unpooled;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import alluxio.util.proto.ProtoUtils;
import java.io.IOException;
import java.io.InputStream;

@NotThreadSafe
public class ReadResponseMarshaller
extends DataMessageMarshaller<ReadResponse> {
    public ReadResponseMarshaller() {
        super(BlockWorkerGrpc.getReadBlockMethod().getResponseMarshaller());
    }

    @Override
    protected ByteBuf[] serialize(ReadResponse message) throws IOException {
        Object chunkBuffer = this.pollBuffer(message);
        if (chunkBuffer == null) {
            if (!message.hasChunk() || !message.getChunk().hasData()) {
                return new ByteBuf[0];
            }
            chunkBuffer = new NettyDataBuffer(Unpooled.wrappedBuffer(message.getChunk().getData().asReadOnlyByteBuffer()));
        }
        int size = message.getSerializedSize() - chunkBuffer.readableBytes();
        byte[] header = new byte[size];
        CodedOutputStream stream = CodedOutputStream.newInstance(header);
        stream.writeTag(1, 2);
        stream.writeUInt32NoTag(message.getChunk().getSerializedSize());
        stream.writeTag(1, 2);
        stream.writeUInt32NoTag(chunkBuffer.readableBytes());
        return new ByteBuf[]{Unpooled.wrappedBuffer(header), (ByteBuf)chunkBuffer.getNettyOutput()};
    }

    @Override
    protected ReadResponse deserialize(ReadableBuffer buffer) throws IOException {
        if (buffer.readableBytes() == 0) {
            return ReadResponse.getDefaultInstance();
        }
        try (InputStream is = ReadableBuffers.openStream(buffer, false);){
            Preconditions.checkState(ProtoUtils.readRawVarint32(is) == GrpcSerializationUtils.makeTag(1, 2));
            int messageSize = ProtoUtils.readRawVarint32(is);
            Preconditions.checkState(messageSize == buffer.readableBytes());
            Preconditions.checkState(ProtoUtils.readRawVarint32(is) == GrpcSerializationUtils.makeTag(1, 2));
            int chunkSize = ProtoUtils.readRawVarint32(is);
            Preconditions.checkState(chunkSize == buffer.readableBytes());
            ReadResponse response = ReadResponse.newBuilder().build();
            this.offerBuffer(new ReadableDataBuffer(buffer), response);
            ReadResponse readResponse = response;
            return readResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReadResponse combineData(DataMessage<ReadResponse, DataBuffer> message) {
        if (message == null) {
            return null;
        }
        DataBuffer buffer = message.getBuffer();
        if (buffer == null) {
            return message.getMessage();
        }
        try {
            byte[] bytes = new byte[buffer.readableBytes()];
            buffer.readBytes(bytes, 0, bytes.length);
            ReadResponse readResponse = message.getMessage().toBuilder().setChunk(Chunk.newBuilder().setData(UnsafeByteOperations.unsafeWrap(bytes)).build()).build();
            return readResponse;
        }
        finally {
            message.getBuffer().release();
        }
    }
}

