/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.upgrade.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.io.ByteSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataVersionRefresher {
    private static final Logger logger = LoggerFactory.getLogger(MetadataVersionRefresher.class);
    private ResourceStore store;
    private String version;

    public MetadataVersionRefresher(ResourceStore resourceStore, String version) {
        this.store = resourceStore;
        this.version = version;
    }

    public void refresh() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        ArrayList all = Lists.newArrayList();
        MetadataVersionRefresher.collectFiles(this.store, "/", all);
        for (String path : all) {
            ObjectNode objectNode;
            if (!path.endsWith(".json") || path.startsWith("/dict") || path.startsWith("/table_snapshot")) continue;
            logger.info("Updating metadata version of path {}", (Object)path);
            try (InputStream is = this.store.getResource(path).getByteSource().openStream();){
                objectNode = (ObjectNode)mapper.readTree(is);
            }
            objectNode.put("version", this.version);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            mapper.writeValue((OutputStream)baos, (Object)objectNode);
            this.store.checkAndPutResource(path, ByteSource.wrap((byte[])baos.toByteArray()), -1L);
        }
    }

    public static void collectFiles(ResourceStore src, String path, List<String> ret) throws IOException {
        NavigableSet children = src.listResources(path);
        if (children == null) {
            ret.add(path);
        } else {
            for (String child : children) {
                MetadataVersionRefresher.collectFiles(src, child, ret);
            }
        }
    }
}

