/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.bitmap;

import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.measure.bitmap.BitmapCounter;
import org.apache.kylin.measure.bitmap.BitmapCounterFactory;
import org.apache.kylin.measure.bitmap.RoaringBitmapCounterFactory;

public class BitmapAggregator
extends MeasureAggregator<BitmapCounter> {
    private static final BitmapCounterFactory bitmapFactory = RoaringBitmapCounterFactory.INSTANCE;
    private BitmapCounter sum;

    @Override
    public void reset() {
        this.sum = null;
    }

    @Override
    public void aggregate(BitmapCounter value) {
        if (this.sum == null) {
            this.sum = value;
            return;
        }
        this.sum.orWith(value);
    }

    @Override
    public BitmapCounter aggregate(BitmapCounter value1, BitmapCounter value2) {
        BitmapCounter merged = bitmapFactory.newBitmap();
        if (value1 != null) {
            merged.orWith(value1);
        }
        if (value2 != null) {
            merged.orWith(value2);
        }
        return merged;
    }

    @Override
    public BitmapCounter getState() {
        return this.sum;
    }

    @Override
    public int getMemBytesEstimate() {
        return this.sum == null ? 0 : this.sum.getMemBytes();
    }

    public void add(Long value) {
        this.sum.add(value);
    }
}

