/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.hllc;

import java.io.Serializable;
import org.apache.kylin.measure.hllc.DenseRegister;
import org.apache.kylin.measure.hllc.Register;
import org.apache.kylin.measure.hllc.RegisterType;
import org.apache.kylin.measure.hllc.SparseRegister;

public class SingleValueRegister
implements Register,
Serializable {
    private int singleValuePos = -1;
    private byte value;

    @Override
    public void set(int pos, byte value) {
        assert (this.singleValuePos < 0 || this.singleValuePos == pos);
        this.singleValuePos = pos;
        this.value = value;
    }

    @Override
    public byte get(int pos) {
        if (pos != this.singleValuePos) {
            return 0;
        }
        return this.value;
    }

    @Override
    public void merge(Register another) {
        throw new IllegalStateException();
    }

    @Override
    public void clear() {
        this.singleValuePos = -1;
    }

    @Override
    public int getSize() {
        if (this.singleValuePos >= 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public RegisterType getRegisterType() {
        return RegisterType.SINGLE_VALUE;
    }

    public int getSingleValuePos() {
        return this.singleValuePos;
    }

    public byte getValue() {
        return this.value;
    }

    public SparseRegister toSparse() {
        SparseRegister sr = new SparseRegister();
        if (this.singleValuePos >= 0) {
            sr.set(this.singleValuePos, this.value);
        }
        return sr;
    }

    public DenseRegister toDense(int p) {
        DenseRegister dr = new DenseRegister(p);
        if (this.singleValuePos >= 0) {
            dr.set(this.singleValuePos, this.value);
        }
        return dr;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.singleValuePos;
        result = 31 * result + this.value;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SingleValueRegister other = (SingleValueRegister)obj;
        return this.singleValuePos == other.singleValuePos && this.value == other.value;
    }
}

