/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.cuboid;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableCollection;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableMultimap;
import org.apache.kylin.guava30.shaded.common.collect.Iterables;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.cuboid.ChooserContext;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.model.AntiFlatChecker;
import org.apache.kylin.metadata.model.ColExcludedChecker;
import org.apache.kylin.metadata.model.DeriveInfo;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.model.util.scd2.Scd2Simplifier;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IndexMatcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IndexMatcher.class);
    final SQLDigest sqlDigest;
    final String project;
    final NDataflow dataflow;
    final NDataModel model;
    final boolean isBatchFusionModel;
    boolean valid;
    final ChooserContext chooserContext;
    final Map<TblColRef, Integer> tblColMap;
    final Map<String, List<Integer>> primaryKeyColumnIds;
    final Map<String, List<Integer>> foreignKeyColumnIds;
    final ImmutableMultimap<Integer, Integer> fk2Pk;
    Set<Integer> sqlColumns;
    ColExcludedChecker excludedChecker;
    AntiFlatChecker antiFlatChecker;
    final Map<Integer, DeriveInfo> toManyDerivedInfoMap = Maps.newHashMap();

    IndexMatcher(SQLDigest sqlDigest, ChooserContext chooserContext, NDataflow dataflow, ColExcludedChecker excludedChecker, AntiFlatChecker antiFlatChecker) {
        this.sqlDigest = sqlDigest;
        this.dataflow = dataflow;
        this.project = dataflow.getProject();
        this.model = chooserContext.getModel();
        this.chooserContext = chooserContext;
        this.isBatchFusionModel = chooserContext.isBatchFusionModel();
        this.fk2Pk = chooserContext.getFk2Pk();
        this.tblColMap = chooserContext.getTblColMap();
        this.primaryKeyColumnIds = chooserContext.getPrimaryKeyColumnIds();
        this.foreignKeyColumnIds = chooserContext.getForeignKeyColumnIds();
        this.excludedChecker = excludedChecker;
        this.antiFlatChecker = antiFlatChecker;
        this.model.getJoinTables().forEach(joinTableDesc -> {
            if (antiFlatChecker.getAntiFlattenLookups().contains(joinTableDesc.getTable())) {
                JoinDesc join = joinTableDesc.getJoin();
                if (!joinTableDesc.isToManyJoinRelation() || !this.needJoinSnapshot(join)) {
                    return;
                }
                int foreignKeyId = this.foreignKeyColumnIds.get(joinTableDesc.getAlias()).get(0);
                int primaryKeyId = this.primaryKeyColumnIds.get(joinTableDesc.getAlias()).get(0);
                this.toManyDerivedInfoMap.put(primaryKeyId, new DeriveInfo(DeriveInfo.DeriveType.LOOKUP, join, Lists.newArrayList((Object[])new Integer[]{foreignKeyId}), false));
            }
        });
    }

    protected abstract boolean fastValidCheckBeforeMatch();

    abstract MatchResult match(LayoutEntity var1);

    protected abstract boolean canSkipIndexMatch(IndexEntity var1);

    Set<Integer> initUnmatchedColumnIds(LayoutEntity layout) {
        HashSet unmatchedCols = Sets.newHashSet();
        unmatchedCols.addAll(this.sqlColumns);
        if (this.isBatchFusionModel) {
            unmatchedCols.removeAll((Collection<?>)layout.getStreamingColumns().keySet());
        }
        unmatchedCols.removeAll((Collection<?>)layout.getOrderedDimensions().keySet());
        Set<Integer> excludedColSet = this.filterExcludedDims(layout);
        if (!excludedColSet.isEmpty()) {
            log.debug("Excluded columns of layout need to derive. The id set is: {}", excludedColSet);
            unmatchedCols.addAll(excludedColSet);
        }
        return unmatchedCols;
    }

    Set<Integer> filterExcludedDims(LayoutEntity layout) {
        if (!NProjectManager.getProjectConfig(this.project).isSnapshotPreferred()) {
            return Sets.newHashSet();
        }
        return layout.getOrderedDimensions().entrySet().stream().filter(entry -> this.excludedChecker.isExcludedCol((TblColRef)entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    void goThruDerivedDims(IndexEntity indexEntity, Map<Integer, DeriveInfo> needDeriveCollector, Set<Integer> unmatchedDims) {
        Iterator<Integer> unmatchedDimItr = unmatchedDims.iterator();
        while (unmatchedDimItr.hasNext()) {
            Integer unmatchedDim = unmatchedDimItr.next();
            if (this.model.isLookupTable(unmatchedDim) && this.model.isQueryDerivedEnabled(unmatchedDim) && this.goThruDerivedDimsFromLookupTable(indexEntity, needDeriveCollector, unmatchedDimItr, unmatchedDim)) continue;
            this.goThruDerivedDimsFromFactTable(indexEntity, needDeriveCollector, unmatchedDimItr, unmatchedDim);
        }
        needDeriveCollector.putAll(this.toManyDerivedInfoMap);
    }

    private boolean needJoinSnapshot(JoinDesc join) {
        ArrayList sqlDigestJoins = this.sqlDigest.getJoinDescs() == null ? Lists.newArrayList() : this.sqlDigest.getJoinDescs();
        for (JoinDesc digestJoin : sqlDigestJoins) {
            HashSet digestPKs = Sets.newHashSet((Object[])digestJoin.getPrimaryKeyColumns());
            HashSet digestFKs = Sets.newHashSet((Object[])digestJoin.getForeignKeyColumns());
            HashSet joinPKs = Sets.newHashSet((Object[])join.getPrimaryKeyColumns());
            HashSet joinFKs = Sets.newHashSet((Object[])join.getForeignKeyColumns());
            if (CollectionUtils.isEmpty((Collection)digestFKs) || CollectionUtils.isEmpty((Collection)digestPKs) || CollectionUtils.isEmpty((Collection)joinFKs) || CollectionUtils.isEmpty((Collection)joinPKs) || !digestFKs.containsAll(joinFKs) || !digestPKs.containsAll(joinPKs) || !joinFKs.containsAll(digestFKs) || !joinPKs.containsAll(digestPKs)) continue;
            return true;
        }
        return false;
    }

    private void goThruDerivedDimsFromFactTable(IndexEntity indexEntity, Map<Integer, DeriveInfo> needDeriveCollector, Iterator<Integer> unmatchedDimItr, Integer unmatchedDim) {
        ImmutableCollection pks = this.fk2Pk.get((Object)unmatchedDim);
        Iterable pksOnIndex = Iterables.filter((Iterable)pks, xva$0 -> indexEntity.dimensionsDerive((Integer)xva$0));
        Integer pk = (Integer)Iterables.getFirst((Iterable)pksOnIndex, null);
        if (pk != null) {
            JoinDesc joinByPKSide = this.model.getJoinByPKSide(pk);
            Preconditions.checkNotNull((Object)joinByPKSide);
            if (!joinByPKSide.isInnerJoin()) {
                return;
            }
            needDeriveCollector.put(unmatchedDim, new DeriveInfo(DeriveInfo.DeriveType.PK_FK, joinByPKSide, Lists.newArrayList((Object[])new Integer[]{pk}), true));
            unmatchedDimItr.remove();
        }
    }

    private boolean goThruDerivedDimsFromLookupTable(IndexEntity indexEntity, Map<Integer, DeriveInfo> needDeriveCollector, Iterator<Integer> unmatchedDimItr, Integer unmatchedDim) {
        JoinDesc joinByPKSide = this.model.getJoinByPKSide(unmatchedDim);
        Preconditions.checkNotNull((Object)joinByPKSide);
        String alias = joinByPKSide.getPKSide().getAlias();
        List<Integer> foreignKeyColumns = this.foreignKeyColumnIds.get(alias);
        List<Integer> primaryKeyColumns = this.primaryKeyColumnIds.get(alias);
        if (joinByPKSide.isInnerJoin() && primaryKeyColumns.contains(unmatchedDim)) {
            Integer relatedCol = foreignKeyColumns.get(primaryKeyColumns.indexOf(unmatchedDim));
            if (indexEntity.dimensionsDerive(relatedCol)) {
                needDeriveCollector.put(unmatchedDim, new DeriveInfo(DeriveInfo.DeriveType.PK_FK, joinByPKSide, Lists.newArrayList((Object[])new Integer[]{relatedCol}), true));
                unmatchedDimItr.remove();
                return true;
            }
        } else if (indexEntity.dimensionsDerive(foreignKeyColumns) && this.model.getColRef(unmatchedDim) != null) {
            boolean present;
            TableRef tableRef = this.model.getAliasMap().get(alias);
            String tableIdentity = tableRef.getTableIdentity();
            KylinConfig projectConfig = NProjectManager.getProjectConfig(this.model.getProject());
            NTableMetadataManager tableMgr = NTableMetadataManager.getInstance(projectConfig, this.project);
            TableDesc tableDesc = tableMgr.getTableDesc(tableIdentity);
            boolean bl = present = tableDesc != null && (projectConfig.isInternalTableEnabled() && tableDesc.isHasInternal() || !projectConfig.isInternalTableEnabled() && !StringUtils.isBlank((CharSequence)tableDesc.getLastSnapshotPath()));
            if (present) {
                DeriveInfo.DeriveType deriveType = this.matchNonEquiJoinFks(indexEntity, joinByPKSide) ? DeriveInfo.DeriveType.LOOKUP_NON_EQUI : DeriveInfo.DeriveType.LOOKUP;
                needDeriveCollector.put(unmatchedDim, new DeriveInfo(deriveType, joinByPKSide, foreignKeyColumns, false));
                unmatchedDimItr.remove();
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean matchNonEquiJoinFks(IndexEntity indexEntity, JoinDesc joinDesc) {
        if (!joinDesc.isNonEquiJoin()) return false;
        if (!indexEntity.dimensionsDerive(Stream.of(Scd2Simplifier.INSTANCE.extractNeqFks(joinDesc)).map(this.tblColMap::get).collect(Collectors.toList()))) return false;
        return true;
    }

    @Generated
    public boolean isValid() {
        return this.valid;
    }

    public static class MatchResult {
        boolean isMatched;
        Map<Integer, DeriveInfo> needDerive = Maps.newHashMap();
        CapabilityResult.IncapableCause incapableCause;
        private int penalty = 0;
        private double influenceFactor = 1.0;
        public List<CapabilityResult.CapabilityInfluence> influences = Lists.newArrayList();

        public MatchResult(boolean isMatched, int penalty, Map<Integer, DeriveInfo> needDerive) {
            this.isMatched = isMatched;
            this.needDerive = needDerive;
            this.penalty = penalty;
            this.influenceFactor += (double)penalty;
        }

        public MatchResult(boolean isMatched, Map<Integer, DeriveInfo> needDerive, CapabilityResult.IncapableCause reason, List<CapabilityResult.CapabilityInfluence> influences) {
            this.isMatched = isMatched;
            this.needDerive = needDerive;
            this.incapableCause = reason;
            this.influences = influences;
        }

        @Generated
        public boolean isMatched() {
            return this.isMatched;
        }

        @Generated
        public Map<Integer, DeriveInfo> getNeedDerive() {
            return this.needDerive;
        }

        @Generated
        public CapabilityResult.IncapableCause getIncapableCause() {
            return this.incapableCause;
        }

        @Generated
        public int getPenalty() {
            return this.penalty;
        }

        @Generated
        public double getInfluenceFactor() {
            return this.influenceFactor;
        }

        @Generated
        public List<CapabilityResult.CapabilityInfluence> getInfluences() {
            return this.influences;
        }

        @Generated
        public MatchResult() {
        }
    }
}

