/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.gridtable;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.cube.gridtable.GridTableMapping;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.dimension.IDimensionEncodingMap;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSet;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TblColRef;

public class NLayoutToGridTableMapping
extends GridTableMapping {
    private final LayoutEntity layoutEntity;
    private boolean isBatchOfHybrid = false;

    public NLayoutToGridTableMapping(LayoutEntity layoutEntity) {
        this.layoutEntity = layoutEntity;
        this.init();
    }

    public NLayoutToGridTableMapping(LayoutEntity layoutEntity, boolean isBatchOfHybrid) {
        this.layoutEntity = layoutEntity;
        this.isBatchOfHybrid = isBatchOfHybrid;
        this.init();
    }

    private void init() {
        int gtColIdx = 0;
        this.gtDataTypes = Lists.newArrayList();
        this.gtColBlocks = Lists.newArrayList();
        this.dim2gt = Maps.newHashMap();
        BitSet pk = new BitSet();
        ArrayList<TblColRef> columns = new ArrayList<TblColRef>();
        if (this.isBatchOfHybrid) {
            columns.addAll((Collection<TblColRef>)this.layoutEntity.getStreamingColumns().values());
        } else {
            columns.addAll(this.layoutEntity.getColumns());
        }
        for (TblColRef dimension : columns) {
            this.gtDataTypes.add(dimension.getType());
            this.dim2gt.put(dimension, gtColIdx);
            pk.set(gtColIdx);
            ++gtColIdx;
        }
        this.gtPrimaryKey = new ImmutableBitSet(pk);
        this.gtColBlocks.add(this.gtPrimaryKey);
        this.nDimensions = gtColIdx;
        assert (this.nDimensions == this.layoutEntity.getColumns().size());
        ArrayList metricsColBlocks = Lists.newArrayList();
        for (int i = 0; i < this.layoutEntity.getOrderedMeasures().size(); ++i) {
            metricsColBlocks.add(new BitSet());
        }
        this.metrics2gt = Maps.newHashMap();
        int mColBlock = 0;
        ArrayList measureDescs = new ArrayList();
        if (this.isBatchOfHybrid) {
            measureDescs.addAll(this.layoutEntity.getStreamingMeasures().values());
        } else {
            measureDescs.addAll(this.layoutEntity.getOrderedMeasures().values());
        }
        for (NDataModel.Measure measure : measureDescs) {
            FunctionDesc func = measure.getFunction();
            this.metrics2gt.put(func, gtColIdx);
            this.gtDataTypes.add(func.getReturnDataType());
            ((BitSet)metricsColBlocks.get(mColBlock++)).set(gtColIdx++);
        }
        for (BitSet set : metricsColBlocks) {
            this.gtColBlocks.add(new ImmutableBitSet(set));
        }
        this.nMetrics = gtColIdx - this.nDimensions;
        assert (this.nMetrics == this.layoutEntity.getOrderedMeasures().size());
    }

    @Override
    public List<TblColRef> getCuboidDimensionsInGTOrder() {
        return this.layoutEntity.getColumns();
    }

    @Override
    public DimensionEncoding[] getDimensionEncodings(IDimensionEncodingMap dimEncMap) {
        List<TblColRef> dims = this.layoutEntity.getColumns();
        DimensionEncoding[] dimEncs = new DimensionEncoding[dims.size()];
        for (int i = 0; i < dimEncs.length; ++i) {
            dimEncs[i] = dimEncMap.get(dims.get(i));
        }
        return dimEncs;
    }

    @Override
    public Map<Integer, Integer> getDependentMetricsMap() {
        HashMap result = Maps.newHashMap();
        ImmutableSet measures = this.layoutEntity.getOrderedMeasures().values();
        for (NDataModel.Measure child : this.layoutEntity.getOrderedMeasures().values()) {
            if (child.getDependentMeasureRef() == null) continue;
            boolean ok = false;
            for (NDataModel.Measure parent : measures) {
                if (!parent.getName().equals(child.getDependentMeasureRef())) continue;
                int childIndex = this.getIndexOf(child.getFunction());
                int parentIndex = this.getIndexOf(parent.getFunction());
                result.put(childIndex, parentIndex);
                ok = true;
                break;
            }
            if (ok) continue;
            throw new IllegalStateException("Cannot find dependent measure: " + child.getDependentMeasureRef());
        }
        return result.isEmpty() ? Collections.emptyMap() : result;
    }

    @Override
    public String getTableName() {
        return "Cuboid " + this.layoutEntity.getId();
    }
}

