/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.model;

import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RawResourceFilter;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataLayoutDetails;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NDataLayoutDetailsManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NDataLayoutDetailsManager.class);
    private KylinConfig kylinConfig;
    private final String project;
    private CachedCrudAssist<NDataLayoutDetails> crud;

    public static NDataLayoutDetailsManager getInstance(KylinConfig config, String project) {
        return (NDataLayoutDetailsManager)config.getManager(project, NDataLayoutDetailsManager.class);
    }

    static NDataLayoutDetailsManager newInstance(KylinConfig config, String project) {
        return new NDataLayoutDetailsManager(config, project);
    }

    private NDataLayoutDetailsManager(KylinConfig config, String project) {
        if (!UnitOfWork.isAlreadyInTransaction()) {
            log.info("Initializing NDataLayoutDetailsManager with KylinConfig Id: {} for project {}", (Object)System.identityHashCode(config), (Object)project);
        }
        this.kylinConfig = config;
        this.project = project;
        this.crud = new CachedCrudAssist<NDataLayoutDetails>(this.getStore(), MetadataType.LAYOUT_DETAILS, project, NDataLayoutDetails.class){

            @Override
            protected NDataLayoutDetails initEntityAfterReload(NDataLayoutDetails entity, String resourceName) {
                return entity;
            }
        };
        this.crud.setCheckCopyOnWrite(true);
    }

    public ResourceStore getStore() {
        return ResourceStore.getKylinMetaStore((KylinConfig)this.kylinConfig);
    }

    public KylinConfig getConfig() {
        return this.kylinConfig;
    }

    public List<NDataLayoutDetails> listNDataLayoutDetailsByModel(String modelId) {
        return this.crud.listByFilter(RawResourceFilter.equalFilter((String)"dataflowId", (String)modelId));
    }

    public NDataLayoutDetails getNDataLayoutDetails(String modelId, long layoutId) {
        return this.crud.get(modelId + "-" + layoutId);
    }

    public void save(NDataLayoutDetails fragment) {
        this.crud.save(fragment);
    }

    public void updateLayoutDetails(String modelId, long layoutId, NDataLayoutDetailsUpdater updater) {
        NDataLayoutDetails details = new NDataLayoutDetails();
        details.setProject(this.project);
        details.setModelId(modelId);
        details.setLayoutId(layoutId);
        if (this.crud.contains(details.resourceName())) {
            details = this.crud.get(details.resourceName());
        }
        details = this.copyForWrite(details);
        updater.modify(details);
        this.crud.save(details);
    }

    public void removeFragmentBySegment(NDataflow df, NDataSegment segment) {
        String modelId = df.getId();
        List<LayoutEntity> layoutId = df.getIndexPlan().getAllLayouts();
        for (LayoutEntity layoutEntity : layoutId) {
            this.updateLayoutDetails(modelId, layoutEntity.getId(), copyForWrite -> copyForWrite.getFragmentRangeSet().remove(segment.getRange()));
        }
    }

    public void removeDetails(String modelId, Set<Long> layoutIds) {
        for (long layoutId : layoutIds) {
            this.crud.delete(modelId + "-" + layoutId);
        }
    }

    public NDataLayoutDetails copyForWrite(NDataLayoutDetails details) {
        Preconditions.checkNotNull((Object)details);
        return this.crud.copyForWrite(details);
    }

    public static interface NDataLayoutDetailsUpdater {
        public void modify(NDataLayoutDetails var1);
    }
}

