/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.cube.model.validation.ValidateContext;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.cube.cuboid.CuboidScheduler;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.validation.NIndexPlanValidator;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NIndexPlanManager {
    private static final Logger logger = LoggerFactory.getLogger(NIndexPlanManager.class);
    private KylinConfig config;
    private String project;
    private CachedCrudAssist<IndexPlan> crud;

    public static NIndexPlanManager getInstance(KylinConfig config, String project) {
        return (NIndexPlanManager)config.getManager(project, NIndexPlanManager.class);
    }

    static NIndexPlanManager newInstance(KylinConfig config, String project) {
        return new NIndexPlanManager(config, project);
    }

    private NIndexPlanManager(KylinConfig cfg, final String project) {
        if (!UnitOfWork.isAlreadyInTransaction()) {
            logger.info("Initializing NIndexPlanManager with KylinConfig Id: {} for project {}", (Object)System.identityHashCode(cfg), (Object)project);
        }
        this.config = cfg;
        this.project = project;
        this.crud = new CachedCrudAssist<IndexPlan>(this.getStore(), MetadataType.INDEX_PLAN, project, IndexPlan.class){

            @Override
            protected IndexPlan initEntityAfterReload(IndexPlan indexPlan, String resourceName) {
                indexPlan.initAfterReload(NIndexPlanManager.this.config, project);
                return indexPlan;
            }

            @Override
            protected IndexPlan initBrokenEntity(IndexPlan entity, String resourceName) {
                IndexPlan indexPlan = super.initBrokenEntity(entity, resourceName);
                indexPlan.setProject(project);
                indexPlan.setConfig(KylinConfigExt.createInstance((KylinConfig)NIndexPlanManager.this.config, (Map)Maps.newHashMap()));
                indexPlan.setDependencies(indexPlan.calcDependencies());
                return indexPlan;
            }
        };
        this.crud.setCheckCopyOnWrite(true);
    }

    public IndexPlan copyForWrite(IndexPlan plan) {
        if (plan.getProject() == null) {
            plan.setProject(this.project);
        }
        return this.crud.copyForWrite(plan);
    }

    public IndexPlan copy(IndexPlan plan) {
        return this.crud.copyBySerialization(plan);
    }

    public IndexPlan getIndexPlan(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        return this.crud.get(id);
    }

    public IndexPlan getIndexPlanByModelAlias(String name) {
        return this.listAllIndexPlans(true).stream().filter(indexPlan -> Objects.equals(indexPlan.getModelAlias(), name)).findFirst().orElse(null);
    }

    public List<IndexPlan> listAllIndexPlans() {
        return this.listAllIndexPlans(false);
    }

    public List<IndexPlan> listAllIndexPlans(boolean includeBroken) {
        return this.crud.listAll().stream().filter(cp -> includeBroken || !cp.isBroken()).collect(Collectors.toList());
    }

    public IndexPlan createIndexPlan(IndexPlan indexPlan) {
        if (indexPlan.getUuid() == null) {
            throw new IllegalArgumentException();
        }
        try {
            if (indexPlan.getConfig() == null) {
                indexPlan.initAfterReload(this.config, this.project);
            }
        }
        catch (Exception e) {
            logger.warn("Broken cube plan " + indexPlan, (Throwable)e);
            indexPlan.addError(e.getMessage());
        }
        IndexPlan copy = this.copyForWrite(indexPlan);
        if (this.crud.contains(copy.getUuid())) {
            throw new IllegalArgumentException("IndexPlan '" + indexPlan.getUuid() + "' already exists");
        }
        if (!copy.getError().isEmpty()) {
            throw new IllegalArgumentException(copy.getErrorMsg());
        }
        NIndexPlanValidator validator = new NIndexPlanValidator();
        ValidateContext context = validator.validate(copy);
        if (!context.ifPass()) {
            throw new IllegalArgumentException(copy.getErrorMsg());
        }
        return this.save(copy);
    }

    public IndexPlan updateIndexPlan(String indexPlanId, NIndexPlanUpdater updater) {
        IndexPlan cached = this.getIndexPlan(indexPlanId);
        IndexPlan copy = this.copyForWrite(cached);
        updater.modify(copy);
        return this.innerUpdateIndexPlan(copy);
    }

    @Deprecated
    public IndexPlan updateIndexPlan(IndexPlan indexPlan) {
        return this.updateIndexPlan(indexPlan.getUuid(), arg_0 -> ((IndexPlan)indexPlan).copyPropertiesTo(arg_0));
    }

    private IndexPlan innerUpdateIndexPlan(IndexPlan indexPlan) {
        if (indexPlan.isCachedAndShared()) {
            throw new IllegalStateException();
        }
        if (indexPlan.getUuid() == null) {
            throw new IllegalArgumentException();
        }
        String name = indexPlan.getUuid();
        if (!this.crud.contains(name)) {
            throw new IllegalArgumentException("IndexPlan '" + name + "' does not exist.");
        }
        try {
            if (indexPlan.getConfig() == null) {
                indexPlan.initAfterReload(this.config, this.project);
            }
        }
        catch (Exception e) {
            logger.warn("Broken cube desc " + indexPlan, (Throwable)e);
            indexPlan.addError(e.getMessage());
            throw new IllegalArgumentException(indexPlan.getErrorMsg());
        }
        return this.save(indexPlan);
    }

    public void dropIndexPlan(IndexPlan indexPlan) {
        this.crud.delete(indexPlan);
    }

    public void dropIndexPlan(String planId) {
        IndexPlan indexPlan = this.getIndexPlan(planId);
        this.dropIndexPlan(indexPlan);
    }

    private ResourceStore getStore() {
        return ResourceStore.getKylinMetaStore((KylinConfig)this.config);
    }

    private IndexPlan save(IndexPlan indexPlan) {
        this.validatePlan(indexPlan);
        indexPlan.setIndexes(indexPlan.getIndexes().stream().peek(cuboid -> cuboid.setLayouts(cuboid.getLayouts().stream().filter(l -> l.isBase() || l.isAuto() || IndexEntity.isTableIndex(l.getId())).collect(Collectors.toList()))).filter(cuboid -> cuboid.getLayouts().size() > 0).collect(Collectors.toList()));
        NDataflowManager dataflowManager = NDataflowManager.getInstance(this.config, this.project);
        NDataflow dataflow = dataflowManager.getDataflow(indexPlan.getUuid());
        if (dataflow != null && dataflow.getLatestReadySegment() != null) {
            Set livedIds = indexPlan.getAllLayouts().stream().map(LayoutEntity::getId).collect(Collectors.toSet());
            HashSet<Long> layoutIds = new HashSet<Long>();
            for (NDataSegment segment : dataflow.getSegments()) {
                layoutIds.addAll(segment.getLayoutIds());
            }
            layoutIds.removeAll(livedIds);
            dataflowManager.removeLayouts(dataflow, layoutIds);
        }
        return this.crud.save(indexPlan);
    }

    private void validatePlan(IndexPlan indexPlan) {
        for (IndexEntity indexEntity : indexPlan.getIndexes()) {
            List<LayoutEntity> layouts = indexEntity.getLayouts();
            for (LayoutEntity layout : layouts) {
                Preconditions.checkState((boolean)CollectionUtils.isEqualCollection((Collection)layout.getColOrder().stream().filter(col -> col >= 100000).collect(Collectors.toSet()), indexEntity.getMeasures()), (Object)("layout " + layout.getId() + "'s measure is illegal " + layout.getColOrder() + ", " + indexEntity.getMeasures()));
                Preconditions.checkState((boolean)CollectionUtils.isEqualCollection((Collection)layout.getColOrder().stream().filter(col -> col < 100000).collect(Collectors.toSet()), indexEntity.getDimensions()), (Object)("layout " + layout.getId() + "'s dimension is illegal"));
            }
        }
        Set selectedColumnIds = NDataModelManager.getInstance(this.config, indexPlan.getProject()).getDataModelDesc(indexPlan.getUuid()).getAllSelectedColumns().stream().map(NDataModel.NamedColumn::getId).collect(Collectors.toSet());
        for (IndexEntity index3 : indexPlan.getAllIndexes(false)) {
            if (!index3.isTableIndex()) continue;
            for (Integer dimId : index3.getDimensions()) {
                if (selectedColumnIds.contains(dimId)) continue;
                throw new IllegalStateException(String.format(Locale.ROOT, MsgPicker.getMsg().getDimensionNotfound(), indexPlan.getModel().getNonDimensionNameById(dimId)));
            }
        }
        this.validateSameIdWithDifferentLayout(indexPlan);
        this.validateDifferentIdWithSameLayout(indexPlan);
        List<IndexEntity> list = indexPlan.getAllIndexes(false);
        long tableIndexSize = list.stream().filter(IndexEntity::isTableIndex).map(IndexEntity::getDimensionBitset).distinct().count();
        long aggIndexSize = list.stream().filter(i -> !i.isTableIndex()).map(index -> index.getMeasureBitset().or(index.getDimensionBitset())).distinct().count();
        Preconditions.checkState((tableIndexSize + aggIndexSize == (long)list.size() ? 1 : 0) != 0, (Object)"there are duplicate indexes in index_plan");
        if (indexPlan.getRuleBasedIndex() != null) {
            CuboidScheduler scheduler = CuboidScheduler.getInstance(indexPlan, indexPlan.getRuleBasedIndex());
            scheduler.updateOrder();
        }
    }

    private void validateSameIdWithDifferentLayout(IndexPlan indexPlan) {
        HashMap seen = Maps.newHashMap();
        boolean allDistinct = Stream.concat(indexPlan.getRuleBaseLayouts().stream(), indexPlan.getWhitelistLayouts().stream()).allMatch(layout -> {
            if (seen.containsKey(layout.getId())) {
                return Objects.equals(seen.get(layout.getId()), layout);
            }
            seen.put(layout.getId(), layout);
            return true;
        });
        Preconditions.checkState((boolean)allDistinct, (Object)"there are different layout that have same id");
    }

    private void validateDifferentIdWithSameLayout(IndexPlan indexPlan) {
        HashMap seen = Maps.newHashMap();
        boolean allDistinct = Stream.concat(indexPlan.getRuleBaseLayouts().stream(), indexPlan.getWhitelistLayouts().stream()).allMatch(layout -> {
            if (seen.containsKey(layout)) {
                return Objects.equals(seen.get(layout), layout.getId());
            }
            seen.put(layout, layout.getId());
            return true;
        });
        Preconditions.checkState((boolean)allDistinct, (Object)"there are same layout that have different id");
    }

    public long getAvailableIndexesCount(String project, String id) {
        NDataflowManager dataflowManager = NDataflowManager.getInstance(this.config, project);
        NDataflow dataflow = dataflowManager.getDataflow(id);
        if (dataflow == null) {
            return 0L;
        }
        NDataSegment readySegments = dataflow.getLatestReadySegment();
        if (readySegments == null) {
            return 0L;
        }
        Set<Long> readLayouts = readySegments.getLayoutsMap().keySet();
        return dataflow.getIndexPlan().getAllLayoutsReadOnly().stream().filter(layoutEntityPair -> readLayouts.contains(((LayoutEntity)layoutEntityPair.getLeft()).getId()) && (Boolean)layoutEntityPair.getRight() == false).count();
    }

    public static interface NIndexPlanUpdater {
        public void modify(IndexPlan var1);
    }
}

