/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.cube.model.LayoutPartition;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.PartitionStatusEnum;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class SegmentPartition
implements Serializable {
    @JsonBackReference
    private NDataSegment segment;
    @JsonProperty(value="partition_id")
    private long partitionId;
    @JsonProperty(value="create_time_utc")
    private long createTimeUTC;
    @JsonProperty(value="status")
    private PartitionStatusEnum status;
    @JsonProperty(value="last_build_time")
    private long lastBuildTime;
    @JsonProperty(value="source_count")
    private long sourceCount = -1L;
    @JsonProperty(value="column_source_bytes")
    private Map<String, Long> columnSourceBytes = Maps.newHashMap();
    private long storageSize = -1L;

    public SegmentPartition() {
    }

    public SegmentPartition(long partitionId) {
        this.partitionId = partitionId;
        this.status = PartitionStatusEnum.NEW;
        this.setCreateTimeUTC(System.currentTimeMillis());
    }

    public void setSegment(NDataSegment segment) {
        this.checkIsNotCachedAndShared();
        this.segment = segment;
    }

    public void setPartitionId(long partitionId) {
        this.checkIsNotCachedAndShared();
        this.partitionId = partitionId;
    }

    public void setCreateTimeUTC(long createTimeUTC) {
        this.checkIsNotCachedAndShared();
        this.createTimeUTC = createTimeUTC;
    }

    public void setStatus(PartitionStatusEnum status) {
        this.checkIsNotCachedAndShared();
        this.status = status;
    }

    public void setLastBuildTime(long lastBuildTime) {
        this.checkIsNotCachedAndShared();
        this.lastBuildTime = lastBuildTime;
    }

    public void setSourceCount(long sourceCount) {
        this.checkIsNotCachedAndShared();
        this.sourceCount = sourceCount;
    }

    public void setColumnSourceBytes(Map<String, Long> columnSourceBytes) {
        this.checkIsNotCachedAndShared();
        this.columnSourceBytes = columnSourceBytes;
    }

    public void setStorageSize(Long storageSize) {
        this.checkIsNotCachedAndShared();
        this.storageSize = storageSize;
    }

    public void checkIsNotCachedAndShared() {
        if (this.isCachedAndShared()) {
            throw new IllegalStateException();
        }
    }

    public boolean isCachedAndShared() {
        if (this.segment == null || !this.segment.isCachedAndShared()) {
            return false;
        }
        for (SegmentPartition partition : this.segment.getMultiPartitions()) {
            if (partition != this) continue;
            return true;
        }
        return false;
    }

    public long getSourceCount() {
        if (this.sourceCount == -1L) {
            return 0L;
        }
        return this.sourceCount;
    }

    public long getStorageSize() {
        if (this.storageSize == -1L) {
            NDataSegment dataSegment = this.getSegment();
            if (Objects.isNull(dataSegment)) {
                return 0L;
            }
            this.storageSize = dataSegment.getSegDetails().getEffectiveLayouts().stream().flatMap(layout -> layout.getMultiPartition().stream()).filter(partition -> partition.getPartitionId() == this.partitionId).mapToLong(LayoutPartition::getByteSize).sum();
        }
        return this.storageSize;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.segment == null ? 0 : this.segment.hashCode());
        result = 31 * result + Long.valueOf(this.partitionId).hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SegmentPartition other = (SegmentPartition)obj;
        if (this.segment == null ? other.segment != null : !this.segment.equals(other.segment)) {
            return false;
        }
        return this.partitionId == other.partitionId;
    }

    @Generated
    public NDataSegment getSegment() {
        return this.segment;
    }

    @Generated
    public long getPartitionId() {
        return this.partitionId;
    }

    @Generated
    public long getCreateTimeUTC() {
        return this.createTimeUTC;
    }

    @Generated
    public PartitionStatusEnum getStatus() {
        return this.status;
    }

    @Generated
    public long getLastBuildTime() {
        return this.lastBuildTime;
    }

    @Generated
    public Map<String, Long> getColumnSourceBytes() {
        return this.columnSourceBytes;
    }
}

