/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.optimization;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import lombok.Generated;
import org.apache.kylin.common.util.TimeUtil;
import org.apache.kylin.metadata.favorite.FavoriteRule;
import org.apache.kylin.metadata.favorite.FavoriteRuleManager;

public class FrequencyMap
implements Serializable {
    @JsonIgnore
    private NavigableMap<Long, Integer> dateFrequency = new TreeMap<Long, Integer>();

    @JsonAnySetter
    public void add(String key, Integer value) {
        this.dateFrequency.put(Long.parseLong(key), value);
    }

    @JsonAnyGetter
    public Map<Long, Integer> getMap() {
        return this.dateFrequency;
    }

    public void incFrequency(long time) {
        long date = this.getDateInMillis(time);
        Integer freq = (Integer)this.dateFrequency.get(date);
        if (freq != null) {
            Integer n = freq;
            Integer n2 = freq = Integer.valueOf(freq + 1);
            this.dateFrequency.put(date, freq);
        } else {
            this.dateFrequency.put(date, 1);
        }
    }

    public FrequencyMap merge(FrequencyMap other) {
        other.getDateFrequency().forEach((k, v) -> this.dateFrequency.merge((Long)k, (Integer)v, Integer::sum));
        return this;
    }

    @JsonIgnore
    public long getFrequency(String project) {
        FavoriteRuleManager ruleManager = FavoriteRuleManager.getInstance(project);
        Integer timeWindow = FavoriteRule.getTimeWindowLength(ruleManager.getValue("frequency_time_window"));
        return this.getFrequency(timeWindow);
    }

    @JsonIgnore
    public int getFrequency(Integer timeWindowDays) {
        long frequencyInitialCollectDate = this.getDateBeforeFrequencyTimeWindow(timeWindowDays);
        return this.dateFrequency.subMap(frequencyInitialCollectDate, Long.MAX_VALUE).values().stream().reduce(Integer::sum).orElse(0);
    }

    @JsonIgnore
    public boolean isLowFrequency(Integer timeWindow, Integer lowFrequencyThreshold) {
        int frequency = this.getFrequency(timeWindow);
        return frequency < lowFrequencyThreshold;
    }

    private long getDateBeforeFrequencyTimeWindow(Integer timeWindowDays) {
        return TimeUtil.minusDays((long)this.getDateInMillis(System.currentTimeMillis()), (int)timeWindowDays);
    }

    private long getDateInMillis(long queryTime) {
        return TimeUtil.getDayStart((long)queryTime);
    }

    @Generated
    public NavigableMap<Long, Integer> getDateFrequency() {
        return this.dateFrequency;
    }

    @Generated
    public void setDateFrequency(NavigableMap<Long, Integer> dateFrequency) {
        this.dateFrequency = dateFrequency;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FrequencyMap)) {
            return false;
        }
        FrequencyMap other = (FrequencyMap)o;
        if (!other.canEqual(this)) {
            return false;
        }
        NavigableMap<Long, Integer> this$dateFrequency = this.getDateFrequency();
        NavigableMap<Long, Integer> other$dateFrequency = other.getDateFrequency();
        return !(this$dateFrequency == null ? other$dateFrequency != null : !this$dateFrequency.equals(other$dateFrequency));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FrequencyMap;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NavigableMap<Long, Integer> $dateFrequency = this.getDateFrequency();
        result = result * 59 + ($dateFrequency == null ? 43 : $dateFrequency.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FrequencyMap(dateFrequency=" + this.getDateFrequency() + ")";
    }

    @Generated
    public FrequencyMap(NavigableMap<Long, Integer> dateFrequency) {
        this.dateFrequency = dateFrequency;
    }

    @Generated
    public FrequencyMap() {
    }
}

