/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.optimization;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.annotation.Clarification;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.optimization.AbstractOptStrategy;
import org.apache.kylin.metadata.cube.optimization.GarbageLayoutType;
import org.apache.kylin.metadata.project.NProjectManager;

@Clarification(priority=Clarification.Priority.MAJOR, msg="Enterprise")
public class IndexOptimizer {
    private boolean needLog;
    private final List<AbstractOptStrategy> strategiesForAuto = Lists.newArrayList();
    private final List<AbstractOptStrategy> strategiesForManual = Lists.newArrayList();

    public IndexOptimizer(boolean needLog) {
        this.needLog = needLog;
    }

    protected List<LayoutEntity> filterAutoLayouts(NDataflow dataflow) {
        return dataflow.extractReadyLayouts().stream().filter(layout -> !layout.isManual() && layout.isAuto()).filter(layout -> !layout.isBase()).filter(layout -> !layout.isToBeDeleted()).collect(Collectors.toList());
    }

    protected List<LayoutEntity> filterManualLayouts(NDataflow dataflow) {
        return dataflow.extractReadyLayouts().stream().filter(LayoutEntity::isManual).filter(layout -> !layout.isBase()).collect(Collectors.toList());
    }

    public Map<Long, GarbageLayoutType> getGarbageLayoutMap(NDataflow dataflow) {
        if (NProjectManager.getInstance(KylinConfig.getInstanceFromEnv()).getProject(dataflow.getProject()).isExpertMode()) {
            return Maps.newHashMap();
        }
        HashMap garbageLayoutTypeMap = Maps.newHashMap();
        List<LayoutEntity> autoLayouts = this.filterAutoLayouts(dataflow);
        for (AbstractOptStrategy strategy : this.getStrategiesForAuto()) {
            strategy.collectGarbageLayouts(autoLayouts, dataflow, this.needLog).forEach(id -> garbageLayoutTypeMap.put(id, strategy.getType()));
        }
        for (AbstractOptStrategy strategy : this.getStrategiesForManual()) {
            strategy.collectGarbageLayouts(this.filterManualLayouts(dataflow), dataflow, this.needLog).forEach(id -> garbageLayoutTypeMap.put(id, strategy.getType()));
        }
        return garbageLayoutTypeMap;
    }

    @VisibleForTesting
    public static Set<Long> findGarbageLayouts(NDataflow dataflow, AbstractOptStrategy strategy) {
        List<LayoutEntity> allLayouts = dataflow.getIndexPlan().getAllLayouts();
        return strategy.collectGarbageLayouts(allLayouts, dataflow, false);
    }

    @Generated
    public List<AbstractOptStrategy> getStrategiesForAuto() {
        return this.strategiesForAuto;
    }

    @Generated
    public List<AbstractOptStrategy> getStrategiesForManual() {
        return this.strategiesForManual;
    }
}

