/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.planner.algorithm;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.cube.planner.algorithm.CuboidBenefitModel;
import org.apache.kylin.metadata.cube.planner.algorithm.CuboidStatsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuboidStats {
    private static final Logger logger = LoggerFactory.getLogger(CuboidStats.class);
    static final double WEIGHT_FOR_UN_QUERY = 0.2;
    static final double BPUS_MIN_BENEFIT_RATIO = 0.001;
    private String key;
    private BigInteger baseCuboid;
    private double bpusMinBenefitRatio;
    private ImmutableSet<BigInteger> mandatoryCuboidSet;
    private ImmutableSet<BigInteger> selectionCuboidSet;
    private ImmutableMap<BigInteger, Long> cuboidCountMap;
    private ImmutableMap<BigInteger, Double> cuboidSizeMap;
    private ImmutableMap<BigInteger, Double> cuboidHitProbabilityMap;
    private ImmutableMap<BigInteger, Long> cuboidScanCountMap;
    private ImmutableMap<BigInteger, List<BigInteger>> directChildrenCache;
    private Map<BigInteger, Set<BigInteger>> allDescendantsCache;

    private CuboidStats(String key, BigInteger baseCuboidId, double queryUncertaintyRatio, double bpusMinBenefitRatio, Set<BigInteger> mandatoryCuboids, Map<BigInteger, Long> statistics, Map<BigInteger, Double> size, Map<BigInteger, Long> hitFrequencyMap, Map<BigInteger, Map<BigInteger, Long>> scanCountSourceMap) {
        this.key = key;
        this.baseCuboid = baseCuboidId;
        this.bpusMinBenefitRatio = bpusMinBenefitRatio;
        HashSet cuboidsForMandatory = Sets.newHashSet(mandatoryCuboids);
        if (!cuboidsForMandatory.contains(this.baseCuboid)) {
            cuboidsForMandatory.add(this.baseCuboid);
        }
        logger.info("Mandatory cuboids: " + cuboidsForMandatory);
        HashSet cuboidsForSelection = Sets.newHashSet(statistics.keySet());
        cuboidsForSelection.removeAll(cuboidsForMandatory);
        this.mandatoryCuboidSet = ImmutableSet.builder().addAll((Iterable)cuboidsForMandatory).build();
        this.selectionCuboidSet = ImmutableSet.builder().addAll((Iterable)cuboidsForSelection).build();
        if (this.selectionCuboidSet.isEmpty()) {
            logger.warn("The selection set should not be empty!!!");
        }
        this.cuboidCountMap = ImmutableMap.builder().putAll(statistics).build();
        this.cuboidSizeMap = ImmutableMap.builder().putAll(size).build();
        Map<BigInteger, Double> tmpCuboidHitProbabilityMap = CuboidStatsUtil.calculateCuboidHitProbability(this.selectionCuboidSet, hitFrequencyMap, BigInteger.valueOf(this.selectionCuboidSet.size()), queryUncertaintyRatio);
        this.cuboidHitProbabilityMap = ImmutableMap.builder().putAll(tmpCuboidHitProbabilityMap).build();
        HashMap tmpCuboidScanCountMap = Maps.newHashMapWithExpectedSize((int)(1 + this.selectionCuboidSet.size()));
        tmpCuboidScanCountMap.put(this.baseCuboid, this.getExpScanCount(this.baseCuboid, statistics, scanCountSourceMap));
        for (BigInteger cuboid : this.selectionCuboidSet) {
            tmpCuboidScanCountMap.put(cuboid, this.getExpScanCount(cuboid, statistics, scanCountSourceMap));
        }
        this.cuboidScanCountMap = ImmutableMap.builder().putAll((Map)tmpCuboidScanCountMap).build();
        this.directChildrenCache = ImmutableMap.builder().putAll(CuboidStatsUtil.createDirectChildrenCache(statistics.keySet())).build();
        this.allDescendantsCache = Maps.newConcurrentMap();
    }

    private long getExpScanCount(BigInteger sourceCuboid, Map<BigInteger, Long> statistics, Map<BigInteger, Map<BigInteger, Long>> scanCountSourceMap) {
        Preconditions.checkNotNull((Object)statistics.get(sourceCuboid), (Object)("The statistics for source cuboid " + sourceCuboid + " does not exist!!!"));
        if (scanCountSourceMap == null || scanCountSourceMap.get(sourceCuboid) == null || scanCountSourceMap.get(sourceCuboid).size() <= 0) {
            return statistics.get(sourceCuboid);
        }
        Map<BigInteger, Long> scanCountTargetMap = scanCountSourceMap.get(sourceCuboid);
        long totalEstScanCount = 0L;
        for (Map.Entry<BigInteger, Long> subEntry : scanCountTargetMap.entrySet()) {
            BigInteger targetCuboid = subEntry.getKey();
            Preconditions.checkNotNull((Object)statistics.get(targetCuboid), (Object)("The statistics for target cuboid " + targetCuboid + " does not exist!!!"));
            totalEstScanCount += subEntry.getValue() * statistics.get(sourceCuboid) / statistics.get(targetCuboid);
        }
        return totalEstScanCount / (long)scanCountTargetMap.size();
    }

    public double getBpusMinBenefitRatio() {
        return this.bpusMinBenefitRatio;
    }

    public Set<BigInteger> getAllDescendants(BigInteger cuboid) {
        LinkedHashSet allDescendants = Sets.newLinkedHashSet();
        if (this.selectionCuboidSet.contains((Object)cuboid)) {
            if (this.allDescendantsCache.get(cuboid) != null) {
                return this.allDescendantsCache.get(cuboid);
            }
            this.getAllDescendants(cuboid, allDescendants);
            this.allDescendantsCache.put(cuboid, allDescendants);
        }
        return allDescendants;
    }

    private void getAllDescendants(BigInteger cuboid, Set<BigInteger> allDescendants) {
        if (allDescendants.contains(cuboid)) {
            return;
        }
        allDescendants.add(cuboid);
        for (BigInteger directChild : (List)this.directChildrenCache.get((Object)cuboid)) {
            this.getAllDescendants(directChild, allDescendants);
        }
    }

    public ImmutableSet<BigInteger> getAllCuboidsForSelection() {
        return this.selectionCuboidSet;
    }

    public ImmutableSet<BigInteger> getAllCuboidsForMandatory() {
        return this.mandatoryCuboidSet;
    }

    public Long getCuboidQueryCost(BigInteger cuboid) {
        return (Long)this.cuboidScanCountMap.get((Object)cuboid);
    }

    public Long getCuboidCount(BigInteger cuboid) {
        return (Long)this.cuboidCountMap.get((Object)cuboid);
    }

    public Double getCuboidSize(BigInteger cuboid) {
        return (Double)this.cuboidSizeMap.get((Object)cuboid);
    }

    public double getCuboidHitProbability(BigInteger cuboid) {
        if (this.mandatoryCuboidSet.contains((Object)cuboid)) {
            return 1.0;
        }
        return this.cuboidHitProbabilityMap.get((Object)cuboid) == null ? 0.0 : (Double)this.cuboidHitProbabilityMap.get((Object)cuboid);
    }

    public Map<BigInteger, Long> getStatistics() {
        return this.cuboidCountMap;
    }

    public double getBaseCuboidSize() {
        return this.getCuboidSize(this.baseCuboid);
    }

    public BigInteger getBaseCuboid() {
        return this.baseCuboid;
    }

    public String getKey() {
        return this.key;
    }

    public CuboidBenefitModel.CuboidModel getCuboidModel(BigInteger cuboid) {
        return new CuboidBenefitModel.CuboidModel(cuboid, this.getCuboidCount(cuboid), this.getCuboidSize(cuboid), this.getCuboidHitProbability(cuboid), this.getCuboidQueryCost(cuboid));
    }

    public static class Builder {
        private static final long THRESHOLD_ROLL_UP_FOR_MANDATORY = 1000L;
        private String key;
        private BigInteger nTotalCuboids;
        private BigInteger baseCuboid;
        private double queryUncertaintyRatio = 0.2;
        private double bpusMinBenefitRatio = 0.001;
        private Map<BigInteger, Long> statistics;
        private Map<BigInteger, Double> size;
        private Set<BigInteger> mandatoryCuboids = null;
        private Map<BigInteger, Map<BigInteger, Pair<Long, Long>>> rollingUpCountSourceMap = null;
        private Map<BigInteger, Long> hitFrequencyMap = null;
        private Map<BigInteger, Map<BigInteger, Long>> scanCountSourceMap = null;

        public Builder(String key, BigInteger nTotalCuboids, BigInteger baseCuboid, Map<BigInteger, Long> statistics, Map<BigInteger, Double> size) {
            this.key = key;
            this.nTotalCuboids = nTotalCuboids;
            this.baseCuboid = baseCuboid;
            this.statistics = statistics;
            this.size = size;
        }

        public Builder setQueryUncertaintyRatio(double queryUncertaintyRatio) {
            this.queryUncertaintyRatio = queryUncertaintyRatio;
            return this;
        }

        public Builder setBPUSMinBenefitRatio(double bpusMinBenefitRatio) {
            this.bpusMinBenefitRatio = bpusMinBenefitRatio;
            return this;
        }

        public Builder setRollingUpCountSourceMap(Map<BigInteger, Map<BigInteger, Pair<Long, Long>>> rollingUpCountSourceMap) {
            this.rollingUpCountSourceMap = rollingUpCountSourceMap;
            return this;
        }

        public Builder setMandatoryCuboids(Set<BigInteger> mandatoryCuboids) {
            this.mandatoryCuboids = mandatoryCuboids;
            return this;
        }

        public Builder setHitFrequencyMap(Map<BigInteger, Long> hitFrequencyMap) {
            this.hitFrequencyMap = hitFrequencyMap;
            return this;
        }

        public Builder setScanCountSourceMap(Map<BigInteger, Map<BigInteger, Long>> scanCountSourceMap) {
            this.scanCountSourceMap = scanCountSourceMap;
            return this;
        }

        public Map<BigInteger, Double> estimateCuboidsSize(Map<BigInteger, Long> statistics) {
            return null;
        }

        public CuboidStats build() {
            Preconditions.checkNotNull((Object)this.key, (Object)"key should not be null");
            Preconditions.checkNotNull((Object)this.baseCuboid, (Object)"baseCuboid should not be null");
            Preconditions.checkNotNull(this.statistics, (Object)"statistics should not be null");
            Preconditions.checkNotNull(this.size, (Object)"size should not be null");
            Preconditions.checkNotNull((Object)this.statistics.get(this.baseCuboid), (Object)("row count should exist for base cuboid " + this.baseCuboid));
            Preconditions.checkState((boolean)this.statistics.keySet().equals(this.size.keySet()), (Object)"statistics & size should own the same key set");
            this.statistics = CuboidStatsUtil.adjustCuboidStats(this.statistics);
            if (this.hitFrequencyMap != null && this.rollingUpCountSourceMap != null) {
                Map<BigInteger, Double> cuboidHitProbabilityMap = CuboidStatsUtil.calculateCuboidHitProbability(this.hitFrequencyMap.keySet(), this.hitFrequencyMap, this.nTotalCuboids, this.queryUncertaintyRatio);
                Map<BigInteger, Long> srcCuboidsStats = CuboidStatsUtil.generateSourceCuboidStats(this.statistics, cuboidHitProbabilityMap, this.rollingUpCountSourceMap);
                this.statistics.putAll(srcCuboidsStats);
                Map<BigInteger, Double> estimatedSize = this.estimateCuboidsSize(this.statistics);
                if (estimatedSize != null && !estimatedSize.isEmpty()) {
                    this.size = Maps.newHashMap(estimatedSize);
                }
            }
            if (this.mandatoryCuboids == null) {
                this.mandatoryCuboids = Sets.newHashSet();
            } else if (!this.mandatoryCuboids.isEmpty()) {
                this.statistics.putAll(CuboidStatsUtil.complementRowCountForCuboids(this.statistics, this.mandatoryCuboids));
            }
            return new CuboidStats(this.key, this.baseCuboid, this.queryUncertaintyRatio, this.bpusMinBenefitRatio, this.mandatoryCuboids, this.statistics, this.size, this.hitFrequencyMap, this.scanCountSourceMap);
        }
    }
}

