/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.storage;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.optimization.IndexOptimizer;
import org.apache.kylin.metadata.cube.optimization.IndexOptimizerFactory;
import org.apache.kylin.metadata.cube.storage.StorageInfoCollector;
import org.apache.kylin.metadata.cube.storage.StorageInfoEnum;
import org.apache.kylin.metadata.cube.storage.StorageVolumeInfo;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GarbageStorageCollector
implements StorageInfoCollector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GarbageStorageCollector.class);

    @Override
    public void doCollect(KylinConfig config, String project, StorageVolumeInfo storageVolumeInfo) {
        HashMap garbageIndexMap = Maps.newHashMap();
        long storageSize = 0L;
        for (NDataModel model : this.getModels(project)) {
            NDataflow dataflow = this.getDataflow(model).copy();
            IndexOptimizer indexOptimizer = IndexOptimizerFactory.getOptimizer(dataflow, false, false);
            Set<Long> garbageLayouts = indexOptimizer.getGarbageLayoutMap(dataflow).keySet();
            if (!CollectionUtils.isNotEmpty(garbageLayouts)) continue;
            storageSize += this.calculateLayoutSize(garbageLayouts, dataflow);
            garbageIndexMap.put(model.getId(), garbageLayouts);
        }
        storageVolumeInfo.setGarbageModelIndexMap(garbageIndexMap);
        storageVolumeInfo.setGarbageStorageSize(storageSize);
    }

    @Override
    public StorageInfoEnum getType() {
        return StorageInfoEnum.GARBAGE_STORAGE;
    }

    private List<NDataModel> getModels(String project) {
        NDataflowManager dataflowManager = NDataflowManager.getInstance(KylinConfig.getInstanceFromEnv(), project);
        return dataflowManager.listUnderliningDataModels();
    }

    private NDataflow getDataflow(NDataModel model) {
        NDataflowManager dataflowManager = NDataflowManager.getInstance(KylinConfig.getInstanceFromEnv(), model.getProject());
        return dataflowManager.getDataflow(model.getUuid());
    }

    private long calculateLayoutSize(Set<Long> cuboidLayoutIdSet, NDataflow dataflow) {
        long cuboidLayoutSize = 0L;
        for (NDataSegment segment : dataflow.getSegments(SegmentStatusEnum.READY, SegmentStatusEnum.WARNING)) {
            for (Long cuboidLayoutId : cuboidLayoutIdSet) {
                NDataLayout dataCuboid = segment.getSegDetails().getLayoutById(cuboidLayoutId);
                if (dataCuboid == null) continue;
                cuboidLayoutSize += dataCuboid.getByteSize();
            }
        }
        return cuboidLayoutSize;
    }
}

