/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.favorite;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.type.JdbcType;
import org.apache.kylin.common.Singletons;
import org.apache.kylin.common.logging.LogOutputStream;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.metadata.favorite.QueryHistoryIdOffsetMapper;
import org.mybatis.spring.transaction.SpringManagedTransactionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryHistoryIdOffsetUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryHistoryIdOffsetUtil.class);
    private static final Charset DEFAULT_CHARSET = Charset.defaultCharset();
    public static final String CREATE_OFFSET_TABLE = "create.queryhistoryoffset.store.table";

    private QueryHistoryIdOffsetUtil() {
    }

    public static SqlSessionFactory getSqlSessionFactory(DataSource dataSource, String tableName) {
        return (SqlSessionFactory)Singletons.getInstance((String)"query-history-offset-sql-session-factory", SqlSessionFactory.class, clz -> {
            log.info("Start to build SqlSessionFactory");
            SpringManagedTransactionFactory transactionFactory = new SpringManagedTransactionFactory();
            Environment environment = new Environment("query history offset", (TransactionFactory)transactionFactory, dataSource);
            Configuration configuration = new Configuration(environment);
            configuration.setUseGeneratedKeys(true);
            configuration.setJdbcTypeForNull(JdbcType.NULL);
            configuration.addMapper(QueryHistoryIdOffsetMapper.class);
            QueryHistoryIdOffsetUtil.createTableIfNotExist((BasicDataSource)dataSource, tableName);
            return new SqlSessionFactoryBuilder().build(configuration);
        });
    }

    private static void createTableIfNotExist(BasicDataSource dataSource, String tableName) throws IOException, SQLException {
        if (JdbcUtil.isTableExists((Connection)dataSource.getConnection(), (String)tableName)) {
            log.info("{} already existed in database", (Object)tableName);
            return;
        }
        Properties properties = JdbcUtil.getProperties((BasicDataSource)dataSource);
        String createTableStmt = String.format(Locale.ROOT, properties.getProperty(CREATE_OFFSET_TABLE), tableName);
        try (Connection connection = dataSource.getConnection();){
            ScriptRunner sr = new ScriptRunner(connection);
            sr.setLogWriter(new PrintWriter(new OutputStreamWriter((OutputStream)new LogOutputStream(log), DEFAULT_CHARSET)));
            log.debug("start to create table({})", (Object)tableName);
            sr.runScript((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(createTableStmt.getBytes(DEFAULT_CHARSET)), DEFAULT_CHARSET));
            log.debug("create table finished");
        }
        if (!JdbcUtil.isTableExists((Connection)dataSource.getConnection(), (String)tableName)) {
            log.debug("failed to create table({})", (Object)tableName);
            throw new IllegalStateException(String.format(Locale.ROOT, "create table(%s) failed", tableName));
        }
        log.debug("table({}) already exists.", (Object)tableName);
    }
}

