/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.NativeQueryRealization;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.model.FusionModel;
import org.apache.kylin.metadata.model.NDataModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FusionModelManager {
    private static final Logger logger = LoggerFactory.getLogger(FusionModelManager.class);
    private KylinConfig config;
    private String project;
    private CachedCrudAssist<FusionModel> crud;

    public static FusionModelManager getInstance(KylinConfig config, String project) {
        return (FusionModelManager)config.getManager(project, FusionModelManager.class);
    }

    static FusionModelManager newInstance(KylinConfig config, String project) {
        return new FusionModelManager(config, project);
    }

    private FusionModelManager(final KylinConfig config, final String project) {
        this.config = config;
        this.project = project;
        this.crud = new CachedCrudAssist<FusionModel>(this.getStore(), MetadataType.FUSION_MODEL, project, FusionModel.class){

            @Override
            protected FusionModel initEntityAfterReload(FusionModel t, String resourceName) {
                t.init(config, project);
                return t;
            }
        };
        this.crud.reloadAll();
    }

    public KylinConfig getConfig() {
        return this.config;
    }

    public ResourceStore getStore() {
        return ResourceStore.getKylinMetaStore((KylinConfig)this.config);
    }

    public FusionModel getFusionModel(String modelId) {
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            return null;
        }
        return this.crud.get(modelId);
    }

    public FusionModel dropModel(String id) {
        FusionModel model = this.getFusionModel(id);
        if (model == null) {
            return null;
        }
        this.crud.delete(model);
        return model;
    }

    private FusionModel copyForWrite(FusionModel desc) {
        return this.crud.copyForWrite(desc);
    }

    public FusionModel createModel(FusionModel desc) {
        if (desc == null) {
            throw new IllegalArgumentException();
        }
        FusionModel copy = this.copyForWrite(desc);
        if (this.crud.contains(copy.resourceName())) {
            throw new IllegalArgumentException("Fusion Model  '" + copy.getAlias() + "' already exists");
        }
        return this.crud.save(copy);
    }

    public String getModelId(NativeQueryRealization realization) {
        String modelId = realization.getModelId();
        FusionModel fusionModel = this.getFusionModel(modelId);
        if (!realization.isStreamingLayout() && !Objects.isNull(fusionModel)) {
            NDataModel dataModel = fusionModel.getBatchModel();
            modelId = Optional.ofNullable(dataModel).map(RootPersistentEntity::getId).orElse("");
        }
        return modelId;
    }
}

