/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Objects;
import lombok.Generated;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.model.TblColRef;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class ParameterDesc
implements Serializable {
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="value")
    private String value;
    private TblColRef colRef = null;

    public static ParameterDesc newInstance(Object obj) {
        ParameterDesc param = new ParameterDesc();
        if (obj instanceof TblColRef) {
            TblColRef col = (TblColRef)obj;
            param.type = "column";
            param.value = col.getIdentity();
            param.colRef = col;
        } else {
            param.type = "constant";
            param.value = (String)obj;
        }
        return param;
    }

    public byte[] getBytes() throws UnsupportedEncodingException {
        return this.value.getBytes(StandardCharsets.UTF_8);
    }

    public void setColRef(TblColRef colRef) {
        this.colRef = colRef;
    }

    public boolean isColumnType() {
        return "column".equals(this.type);
    }

    public boolean isConstant() {
        return "constant".equalsIgnoreCase(this.type);
    }

    public boolean isConstantParameterDesc() {
        TblColRef colRef = this.getColRef();
        if (colRef == null || this.isConstant()) {
            return true;
        }
        HashSet collector = Sets.newHashSet();
        TblColRef.collectSourceColumns(colRef, collector);
        return collector.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterDesc p = this;
        ParameterDesc q = (ParameterDesc)o;
        if (!Objects.equals(this.type, q.type)) {
            return false;
        }
        if (p.isColumnType() != q.isColumnType()) {
            return false;
        }
        if (p.isColumnType() && p.getColRef() != null && Objects.equals(q.getColRef(), p.getColRef())) {
            return true;
        }
        return p.value.equals(q.value);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.colRef != null ? this.colRef.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.isColumnType() && this.colRef != null ? this.colRef.toString() : this.value;
    }

    public String toStringWithoutAlias() {
        return this.isColumnType() && this.colRef != null ? this.colRef.getColumnWithTableAndSchema() : this.value;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public void setValue(String value) {
        this.value = value;
    }

    @Generated
    public TblColRef getColRef() {
        return this.colRef;
    }
}

