/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model.schema.strategy;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kylin.guava30.shaded.common.base.Objects;
import org.apache.kylin.guava30.shaded.common.collect.MapDifference;
import org.apache.kylin.metadata.model.schema.SchemaChangeCheckResult;
import org.apache.kylin.metadata.model.schema.SchemaNode;
import org.apache.kylin.metadata.model.schema.SchemaNodeType;
import org.apache.kylin.metadata.model.schema.SchemaUtil;
import org.apache.kylin.metadata.model.schema.strategy.SchemaChangeStrategy;

public class ComputedColumnStrategy
implements SchemaChangeStrategy {
    @Override
    public List<SchemaNodeType> supportedSchemaNodeTypes() {
        return Collections.singletonList(SchemaNodeType.MODEL_CC);
    }

    @Override
    public List<SchemaChangeCheckResult.ChangedItem> newItemFunction(SchemaUtil.SchemaDifference difference, Map.Entry<SchemaNode.SchemaNodeIdentifier, SchemaNode> entry, Set<String> importModels, Set<String> originalModels, Set<String> originalBrokenModels) {
        List<SchemaNode> allComputedColumns = difference.getSourceGraph().nodes().stream().filter(schemaNode -> this.supportedSchemaNodeTypes().contains((Object)schemaNode.getType())).collect(Collectors.toList());
        String modelAlias = entry.getValue().getSubject();
        if (this.hasComputedColumnNameWithDifferentExpression(entry.getValue(), allComputedColumns)) {
            return Collections.singletonList(SchemaChangeCheckResult.ChangedItem.createUnImportableSchemaNode(entry.getKey().getType(), entry.getValue(), SchemaChangeCheckResult.UN_IMPORT_REASON.SAME_CC_NAME_HAS_DIFFERENT_EXPR, null, this.hasSameName(modelAlias, originalModels), this.hasSameWithBroken(modelAlias, originalBrokenModels)));
        }
        Optional<SchemaNode> optional = this.hasExpressionWithDifferentComputedColumn(entry.getValue(), allComputedColumns);
        if (optional.isPresent()) {
            return Collections.singletonList(SchemaChangeCheckResult.ChangedItem.createUnImportableSchemaNode(entry.getKey().getType(), entry.getValue(), SchemaChangeCheckResult.UN_IMPORT_REASON.DIFFERENT_CC_NAME_HAS_SAME_EXPR, optional.get().getDetail(), this.hasSameName(modelAlias, originalModels), this.hasSameWithBroken(modelAlias, originalBrokenModels)));
        }
        if (this.overwritable(importModels, originalModels, modelAlias)) {
            return Collections.singletonList(SchemaChangeCheckResult.ChangedItem.createOverwritableSchemaNode(entry.getKey().getType(), entry.getValue(), this.hasSameName(modelAlias, originalModels), this.hasSameWithBroken(modelAlias, originalBrokenModels)));
        }
        return Collections.singletonList(SchemaChangeCheckResult.ChangedItem.createCreatableSchemaNode(entry.getKey().getType(), entry.getValue(), this.hasSameName(modelAlias, originalModels), this.hasSameWithBroken(modelAlias, originalBrokenModels)));
    }

    @Override
    public List<SchemaChangeCheckResult.UpdatedItem> updateItemFunction(SchemaUtil.SchemaDifference difference, MapDifference.ValueDifference<SchemaNode> diff, Set<String> importModels, Set<String> originalModels, Set<String> originalBrokenModels) {
        List<SchemaNode> allComputedColumns = difference.getSourceGraph().nodes().stream().filter(schemaNode -> this.supportedSchemaNodeTypes().contains((Object)schemaNode.getType())).collect(Collectors.toList());
        SchemaNode schemaNode2 = (SchemaNode)diff.rightValue();
        String modelAlias = ((SchemaNode)diff.rightValue()).getSubject();
        if (this.hasComputedColumnNameWithDifferentExpression(schemaNode2, allComputedColumns)) {
            SchemaChangeCheckResult.BaseItemParameter parameter = new SchemaChangeCheckResult.BaseItemParameter(this.hasSameName(modelAlias, originalModels), this.hasSameWithBroken(modelAlias, originalBrokenModels), false, false, false);
            return Collections.singletonList(SchemaChangeCheckResult.UpdatedItem.getSchemaUpdate((SchemaNode)diff.leftValue(), (SchemaNode)diff.rightValue(), modelAlias, SchemaChangeCheckResult.UN_IMPORT_REASON.SAME_CC_NAME_HAS_DIFFERENT_EXPR, null, parameter));
        }
        Optional<SchemaNode> optional = this.hasExpressionWithDifferentComputedColumn(schemaNode2, allComputedColumns);
        if (optional.isPresent()) {
            SchemaChangeCheckResult.BaseItemParameter parameter = new SchemaChangeCheckResult.BaseItemParameter(this.hasSameName(modelAlias, originalModels), this.hasSameWithBroken(modelAlias, originalBrokenModels), false, false, false);
            return Collections.singletonList(SchemaChangeCheckResult.UpdatedItem.getSchemaUpdate((SchemaNode)diff.leftValue(), (SchemaNode)diff.rightValue(), modelAlias, SchemaChangeCheckResult.UN_IMPORT_REASON.DIFFERENT_CC_NAME_HAS_SAME_EXPR, optional.get().getDetail(), parameter));
        }
        boolean overwritable = this.overwritable(importModels, originalModels, modelAlias);
        SchemaChangeCheckResult.BaseItemParameter parameter = new SchemaChangeCheckResult.BaseItemParameter(this.hasSameName(modelAlias, originalModels), this.hasSameWithBroken(modelAlias, originalBrokenModels), true, true, overwritable);
        return Collections.singletonList(SchemaChangeCheckResult.UpdatedItem.getSchemaUpdate((SchemaNode)diff.leftValue(), (SchemaNode)diff.rightValue(), modelAlias, parameter));
    }

    @Override
    public List<SchemaChangeCheckResult.ChangedItem> reduceItemFunction(SchemaUtil.SchemaDifference difference, Map.Entry<SchemaNode.SchemaNodeIdentifier, SchemaNode> entry, Set<String> importModels, Set<String> originalModels, Set<String> originalBrokenModels) {
        String modelAlias = entry.getValue().getSubject();
        boolean overwritable = this.overwritable(importModels, originalModels, modelAlias);
        if (overwritable) {
            return Collections.singletonList(SchemaChangeCheckResult.ChangedItem.createOverwritableSchemaNode(entry.getKey().getType(), entry.getValue(), this.hasSameName(modelAlias, originalModels), this.hasSameWithBroken(modelAlias, originalBrokenModels)));
        }
        return Collections.singletonList(SchemaChangeCheckResult.ChangedItem.createCreatableSchemaNode(entry.getKey().getType(), entry.getValue(), this.hasSameName(modelAlias, originalModels), this.hasSameWithBroken(modelAlias, originalBrokenModels)));
    }

    private boolean hasComputedColumnNameWithDifferentExpression(SchemaNode node, List<SchemaNode> allComputedColumns) {
        String ccName = node.getDetail();
        String expression = (String)node.getAttributes().get("expression");
        return allComputedColumns.stream().anyMatch(schemaNode -> Objects.equal((Object)node.getAttributes().get("fact_table"), (Object)schemaNode.getAttributes().get("fact_table")) && schemaNode.getDetail().equals(ccName) && !schemaNode.getAttributes().get("expression").equals(expression));
    }

    private Optional<SchemaNode> hasExpressionWithDifferentComputedColumn(SchemaNode node, List<SchemaNode> allComputedColumns) {
        String ccName = node.getDetail();
        String expression = (String)node.getAttributes().get("expression");
        return allComputedColumns.stream().filter(schemaNode -> Objects.equal((Object)node.getAttributes().get("fact_table"), (Object)schemaNode.getAttributes().get("fact_table")) && !schemaNode.getDetail().equals(ccName) && schemaNode.getAttributes().get("expression").equals(expression)).findAny();
    }
}

