/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.query;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.metadata.query.QueryHistorySqlParam;

@JsonIgnoreProperties(ignoreUnknown=true)
public class QueryHistorySql {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    @JsonProperty(value="sql")
    private String sql;
    @JsonProperty(value="normalized_sql")
    private String normalizedSql;
    @JsonProperty(value="params")
    private List<QueryHistorySqlParam> params;

    @JsonIgnore
    public String getSqlWithParameterBindingComment() {
        if (CollectionUtils.isEmpty(this.params)) {
            return this.sql;
        }
        StringBuilder sb = new StringBuilder(this.sql);
        sb.append(LINE_SEPARATOR);
        sb.append(LINE_SEPARATOR);
        sb.append("-- [PARAMETER BINDING]");
        sb.append(LINE_SEPARATOR);
        for (QueryHistorySqlParam p : this.params) {
            sb.append(String.format(Locale.ROOT, "-- Binding parameter [%s] as [%s] - [%s]", p.getPos(), p.getDataType(), p.getValue()));
            sb.append(LINE_SEPARATOR);
        }
        sb.append("-- [PARAMETER BINDING END]");
        return sb.toString();
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public String getNormalizedSql() {
        return this.normalizedSql;
    }

    @Generated
    public List<QueryHistorySqlParam> getParams() {
        return this.params;
    }

    @Generated
    public void setSql(String sql) {
        this.sql = sql;
    }

    @Generated
    public void setNormalizedSql(String normalizedSql) {
        this.normalizedSql = normalizedSql;
    }

    @Generated
    public void setParams(List<QueryHistorySqlParam> params) {
        this.params = params;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryHistorySql)) {
            return false;
        }
        QueryHistorySql other = (QueryHistorySql)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$sql = this.getSql();
        String other$sql = other.getSql();
        if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
            return false;
        }
        String this$normalizedSql = this.getNormalizedSql();
        String other$normalizedSql = other.getNormalizedSql();
        if (this$normalizedSql == null ? other$normalizedSql != null : !this$normalizedSql.equals(other$normalizedSql)) {
            return false;
        }
        List<QueryHistorySqlParam> this$params = this.getParams();
        List<QueryHistorySqlParam> other$params = other.getParams();
        return !(this$params == null ? other$params != null : !((Object)this$params).equals(other$params));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QueryHistorySql;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sql = this.getSql();
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        String $normalizedSql = this.getNormalizedSql();
        result = result * 59 + ($normalizedSql == null ? 43 : $normalizedSql.hashCode());
        List<QueryHistorySqlParam> $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "QueryHistorySql(sql=" + this.getSql() + ", normalizedSql=" + this.getNormalizedSql() + ", params=" + this.getParams() + ")";
    }

    @Generated
    public QueryHistorySql() {
    }

    @Generated
    public QueryHistorySql(String sql, String normalizedSql, List<QueryHistorySqlParam> params) {
        this.sql = sql;
        this.normalizedSql = normalizedSql;
        this.params = params;
    }
}

