/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.query;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.nio.charset.Charset;
import java.sql.CallableStatement;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.util.TimeZone;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.metadata.query.QueryHistoryInfo;
import org.mybatis.dynamic.sql.SqlColumn;
import org.mybatis.dynamic.sql.SqlTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryHistoryTable
extends SqlTable {
    public final SqlColumn<String> sql = this.column("sql_text", JDBCType.VARCHAR);
    public final SqlColumn<String> sqlPattern = this.column("sql_pattern", JDBCType.VARCHAR);
    public final SqlColumn<Long> queryTime = this.column("query_time", JDBCType.BIGINT);
    public final SqlColumn<String> month_h2 = this.column("`month`", JDBCType.VARCHAR);
    public final SqlColumn<String> month = this.column("month", JDBCType.VARCHAR);
    public final SqlColumn<Long> queryFirstDayOfMonth = this.column("query_first_day_of_month", JDBCType.BIGINT);
    public final SqlColumn<Long> queryFirstDayOfWeek = this.column("query_first_day_of_week", JDBCType.BIGINT);
    public final SqlColumn<Long> queryDay = this.column("query_day", JDBCType.BIGINT);
    public final SqlColumn<Long> duration = this.column("duration", JDBCType.BIGINT);
    public final SqlColumn<String> queryRealizations = this.column("realizations", JDBCType.VARCHAR);
    public final SqlColumn<String> hostName = this.column("server", JDBCType.VARCHAR);
    public final SqlColumn<String> querySubmitter = this.column("submitter", JDBCType.VARCHAR);
    public final SqlColumn<String> queryStatus = this.column("query_status", JDBCType.VARCHAR);
    public final SqlColumn<String> queryId = this.column("query_id", JDBCType.VARCHAR);
    public final SqlColumn<Long> id = this.column("id", JDBCType.BIGINT);
    public final SqlColumn<Long> totalScanCount = this.column("total_scan_count", JDBCType.BIGINT);
    public final SqlColumn<Long> totalScanBytes = this.column("total_scan_bytes", JDBCType.BIGINT);
    public final SqlColumn<Long> resultRowCount = this.column("result_row_count", JDBCType.BIGINT);
    public final SqlColumn<Boolean> cacheHit = this.column("cache_hit", JDBCType.BOOLEAN);
    public final SqlColumn<Boolean> indexHit = this.column("index_hit", JDBCType.BOOLEAN);
    public final SqlColumn<String> engineType = this.column("engine_type", JDBCType.VARCHAR);
    public final SqlColumn<String> projectName = this.column("project_name", JDBCType.BIGINT);
    public final SqlColumn<String> errorType = this.column("error_type", JDBCType.VARCHAR);
    public final SqlColumn<QueryHistoryInfo> queryHistoryInfo = this.column("reserved_field_3", JDBCType.BLOB, QueryHistoryInfoHandler.class.getName());

    public QueryHistoryTable(String tableName) {
        super(tableName);
    }

    public static class InstantHandler
    implements TypeHandler<Instant> {
        public void setParameter(PreparedStatement ps, int i, Instant parameter, JdbcType jdbcType) throws SQLException {
            ps.setLong(i, parameter.toEpochMilli());
        }

        public Instant getResult(ResultSet rs, String columnName) throws SQLException {
            int offset = TimeZone.getTimeZone(KylinConfig.getInstanceFromEnv().getTimeZone()).getRawOffset();
            long offetTime = Instant.ofEpochMilli(rs.getLong(columnName)).plusMillis(offset).toEpochMilli();
            return Instant.ofEpochMilli(offetTime);
        }

        public Instant getResult(ResultSet rs, int columnIndex) throws SQLException {
            int offset = TimeZone.getTimeZone(KylinConfig.getInstanceFromEnv().getTimeZone()).getRawOffset();
            long offetTime = Instant.ofEpochMilli(rs.getLong(columnIndex)).plusMillis(offset).toEpochMilli();
            return Instant.ofEpochMilli(offetTime);
        }

        public Instant getResult(CallableStatement cs, int columnIndex) throws SQLException {
            int offset = TimeZone.getTimeZone(KylinConfig.getInstanceFromEnv().getTimeZone()).getRawOffset();
            long offetTime = Instant.ofEpochMilli(cs.getLong(columnIndex)).plusMillis(offset).toEpochMilli();
            return Instant.ofEpochMilli(offetTime);
        }
    }

    public static class QueryHistoryInfoHandler
    implements TypeHandler<QueryHistoryInfo> {
        private static final Logger logger = LoggerFactory.getLogger(QueryHistoryInfoHandler.class);

        public void setParameter(PreparedStatement ps, int i, QueryHistoryInfo parameter, JdbcType jdbcType) throws SQLException {
            byte[] bytes = "".getBytes(Charset.defaultCharset());
            try {
                bytes = JsonUtil.writeValueAsBytes((Object)parameter);
            }
            catch (JsonProcessingException e) {
                logger.error("Fail transform object to json", (Throwable)e);
            }
            ps.setBytes(i, bytes);
        }

        public QueryHistoryInfo getResult(ResultSet rs, String columnName) throws SQLException {
            if (rs.getBytes(columnName) == null) {
                return null;
            }
            return (QueryHistoryInfo)JsonUtil.readValueQuietly((byte[])rs.getBytes(columnName), QueryHistoryInfo.class);
        }

        public QueryHistoryInfo getResult(ResultSet rs, int columnIndex) throws SQLException {
            if (rs.getBytes(columnIndex) == null) {
                return null;
            }
            return (QueryHistoryInfo)JsonUtil.readValueQuietly((byte[])rs.getBytes(columnIndex), QueryHistoryInfo.class);
        }

        public QueryHistoryInfo getResult(CallableStatement cs, int columnIndex) throws SQLException {
            if (cs.getBytes(columnIndex) == null) {
                return null;
            }
            return (QueryHistoryInfo)JsonUtil.readValueQuietly((byte[])cs.getBytes(columnIndex), QueryHistoryInfo.class);
        }
    }
}

