/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.recommendation.candidate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.exception.CommonErrorCode;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.persistence.metadata.JdbcDataSource;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.favorite.FavoriteRuleManager;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.schema.ImportModelContext;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.recommendation.candidate.RawRecItem;
import org.apache.kylin.metadata.recommendation.candidate.RawRecItemMapper;
import org.apache.kylin.metadata.recommendation.candidate.RawRecItemTable;
import org.apache.kylin.metadata.recommendation.candidate.RawRecManager;
import org.apache.kylin.metadata.recommendation.util.RawRecStoreUtil;
import org.apache.kylin.metadata.recommendation.util.RawRecUtil;
import org.mybatis.dynamic.sql.AndOrCriteriaGroup;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.SortSpecification;
import org.mybatis.dynamic.sql.SqlBuilder;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.VisitableCondition;
import org.mybatis.dynamic.sql.delete.DeleteDSL;
import org.mybatis.dynamic.sql.delete.DeleteModel;
import org.mybatis.dynamic.sql.delete.render.DeleteStatementProvider;
import org.mybatis.dynamic.sql.insert.InsertDSL;
import org.mybatis.dynamic.sql.insert.render.InsertStatementProvider;
import org.mybatis.dynamic.sql.render.RenderingStrategies;
import org.mybatis.dynamic.sql.select.QueryExpressionDSL;
import org.mybatis.dynamic.sql.select.SelectModel;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;
import org.mybatis.dynamic.sql.update.UpdateDSL;
import org.mybatis.dynamic.sql.update.UpdateModel;
import org.mybatis.dynamic.sql.update.render.UpdateStatementProvider;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

public class JdbcRawRecStore {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcRawRecStore.class);
    public static final String RECOMMENDATION_CANDIDATE = "_rec_candidate_v2";
    private static final int NON_EXIST_MODEL_SEMANTIC_VERSION = Integer.MIN_VALUE;
    private static final int LAG_SEMANTIC_VERSION = 1;
    private static final List<RawRecItem.RawRecState> FINAL_STATE = Arrays.asList(RawRecItem.RawRecState.APPLIED, RawRecItem.RawRecState.BROKEN);
    private final RawRecItemTable table;
    @VisibleForTesting
    private final SqlSessionTemplate sqlSessionTemplate;
    private final DataSourceTransactionManager transactionManager;

    public JdbcRawRecStore(KylinConfig config) throws Exception {
        this(config, JdbcRawRecStore.genRawRecTableName(config));
    }

    public JdbcRawRecStore(KylinConfig config, String tableName) throws Exception {
        StorageURL url = KylinConfig.getInstanceFromEnv().isUTEnv() ? config.getQueryHistoryUrl() : config.getJDBCDistributedLockURL();
        Properties props = JdbcUtil.datasourceParameters((StorageURL)url);
        DataSource dataSource = JdbcDataSource.getDataSource((Properties)props);
        this.table = new RawRecItemTable(tableName);
        this.transactionManager = new DataSourceTransactionManager(dataSource);
        this.sqlSessionTemplate = new SqlSessionTemplate(RawRecStoreUtil.getSqlSessionFactory(dataSource, this.table.tableNameAtRuntime()));
    }

    private static String genRawRecTableName(KylinConfig config) {
        StorageURL url = config.getQueryHistoryUrl();
        String tablePrefix = config.isUTEnv() ? "test_opt" : url.getIdentifier();
        return tablePrefix + RECOMMENDATION_CANDIDATE;
    }

    public void save(RawRecItem recItem) {
        InsertStatementProvider<RawRecItem> insertStatement;
        RawRecItemMapper mapper = (RawRecItemMapper)this.sqlSessionTemplate.getMapper(RawRecItemMapper.class);
        int rows = mapper.insert(insertStatement = this.getInsertProvider(recItem, false));
        if (rows <= 0) {
            throw new KylinException((ErrorCodeSupplier)CommonErrorCode.FAILED_UPDATE_METADATA, String.format(Locale.ROOT, "Failed to insert recommendation (uniqueFlag: %s, content: %s", recItem.getUniqueFlag(), RawRecUtil.getContent(recItem)));
        }
        log.debug("Insert one raw recommendation({}) into database.", (Object)recItem.getUniqueFlag());
    }

    public void saveWithoutCheck(List<RawRecItem> recItems, boolean reserveId) {
        long startTime = System.currentTimeMillis();
        JdbcUtil.withTransaction((DataSourceTransactionManager)this.transactionManager, () -> {
            RawRecItemMapper mapper = (RawRecItemMapper)this.sqlSessionTemplate.getMapper(RawRecItemMapper.class);
            ArrayList providers = Lists.newArrayList();
            recItems.forEach(recItem -> providers.add(this.getInsertProvider((RawRecItem)recItem, reserveId)));
            providers.forEach(mapper::insert);
            log.info("Insert {} raw recommendations into database takes {} ms", (Object)recItems.size(), (Object)(System.currentTimeMillis() - startTime));
            return null;
        });
    }

    public RawRecItem queryById(int id) {
        RawRecItemMapper mapper = (RawRecItemMapper)this.sqlSessionTemplate.getMapper(RawRecItemMapper.class);
        SelectStatementProvider statementProvider = this.getSelectByIdStatementProvider(id);
        return mapper.selectOne(statementProvider);
    }

    public RawRecItem queryByUniqueFlag(String project, String modelId, String uniqueFlag, Integer semanticVersion) {
        RawRecItemMapper mapper = (RawRecItemMapper)this.sqlSessionTemplate.getMapper(RawRecItemMapper.class);
        SelectStatementProvider statementProvider = this.getSelectUniqueFlagIdStatementProvider(project, modelId, uniqueFlag, semanticVersion);
        return mapper.selectOne(statementProvider);
    }

    public List<RawRecItem> queryAll() {
        RawRecItemMapper mapper = (RawRecItemMapper)this.sqlSessionTemplate.getMapper(RawRecItemMapper.class);
        SelectStatementProvider statementProvider = ((SelectModel)SqlBuilder.select((BasicColumn[])this.getSelectFields(this.table)).from((SqlTable)this.table).build()).render(RenderingStrategies.MYBATIS3);
        return mapper.selectMany(statementProvider);
    }

    private List<RawRecItem> list(String project, String model, Integer semanticVersion, int limit) {
        long startTime = System.currentTimeMillis();
        RawRecItemMapper mapper = (RawRecItemMapper)this.sqlSessionTemplate.getMapper(RawRecItemMapper.class);
        QueryExpressionDSL.QueryExpressionWhereBuilder statement = (QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])this.getSelectFields(this.table)).from((SqlTable)this.table).where(this.table.project, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).and(this.table.modelID, (VisitableCondition)SqlBuilder.isEqualTo((Object)model), new AndOrCriteriaGroup[0]);
        if (semanticVersion != null) {
            statement = (QueryExpressionDSL.QueryExpressionWhereBuilder)statement.and(this.table.semanticVersion, (VisitableCondition)SqlBuilder.isEqualTo((Object)semanticVersion), new AndOrCriteriaGroup[0]);
        }
        List<RawRecItem> rawRecItems = mapper.selectMany(((SelectModel)statement.limit((long)limit).build()).render(RenderingStrategies.MYBATIS3));
        log.info("List all raw recommendations of model({}/{}, semanticVersion: {}) takes {} ms.", new Object[]{project, model, semanticVersion, System.currentTimeMillis() - startTime});
        return rawRecItems;
    }

    public List<RawRecItem> listAll(String project, String model, int semanticVersion, int limit) {
        return this.list(project, model, semanticVersion, limit);
    }

    public List<RawRecItem> listAll(String project, String model, int limit) {
        return this.list(project, model, null, limit);
    }

    public List<RawRecItem> queryAdditionalLayoutRecItems(String project, String model) {
        int semanticVersion = this.getSemanticVersion(project, model);
        if (semanticVersion == Integer.MIN_VALUE) {
            log.debug("queryAdditionalLayoutRecItems - model({}/{}) does not exist.", (Object)project, (Object)model);
            return Lists.newArrayList();
        }
        long startTime = System.currentTimeMillis();
        RawRecItemMapper mapper = (RawRecItemMapper)this.sqlSessionTemplate.getMapper(RawRecItemMapper.class);
        SelectStatementProvider statementProvider = ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])this.getSelectFields(this.table)).from((SqlTable)this.table).where(this.table.project, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).and(this.table.semanticVersion, (VisitableCondition)SqlBuilder.isEqualTo((Object)semanticVersion), new AndOrCriteriaGroup[0])).and(this.table.modelID, (VisitableCondition)SqlBuilder.isEqualTo((Object)model), new AndOrCriteriaGroup[0])).and(this.table.type, (VisitableCondition)SqlBuilder.isEqualTo((Object)((Object)RawRecItem.RawRecType.ADDITIONAL_LAYOUT)), new AndOrCriteriaGroup[0])).and(this.table.state, (VisitableCondition)SqlBuilder.isEqualTo((Object)((Object)RawRecItem.RawRecState.RECOMMENDED)), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
        List<RawRecItem> rawRecItems = mapper.selectMany(statementProvider);
        log.info("Query raw recommendations can add indexes to model({}/{}, semanticVersion: {}) takes {} ms.", new Object[]{project, model, semanticVersion, System.currentTimeMillis() - startTime});
        return rawRecItems;
    }

    public List<RawRecItem> queryFrom(BasicColumn[] cols, int startId, int limit) {
        RawRecItemMapper mapper = (RawRecItemMapper)this.sqlSessionTemplate.getMapper(RawRecItemMapper.class);
        SelectStatementProvider statementProvider = ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])cols).from((SqlTable)this.table).where(this.table.id, (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo((Object)startId), new AndOrCriteriaGroup[0])).orderBy(new SortSpecification[]{this.table.id}).limit((long)limit).build()).render(RenderingStrategies.MYBATIS3);
        return mapper.selectMany(statementProvider);
    }

    public List<RawRecItem> chooseTopNCandidates(String project, String model, double minCost, int topN, int offset, RawRecItem.RawRecState state) {
        int semanticVersion = this.getSemanticVersion(project, model);
        if (semanticVersion == Integer.MIN_VALUE) {
            log.debug("chooseTopNCandidates - model({}/{}) does not exist.", (Object)project, (Object)model);
            return Lists.newArrayList();
        }
        long startTime = System.currentTimeMillis();
        RawRecItemMapper mapper = (RawRecItemMapper)this.sqlSessionTemplate.getMapper(RawRecItemMapper.class);
        QueryExpressionDSL.QueryExpressionWhereBuilder queryBuilder = (QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])this.getSelectFields(this.table)).from((SqlTable)this.table).where(this.table.project, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).and(this.table.semanticVersion, (VisitableCondition)SqlBuilder.isEqualTo((Object)semanticVersion), new AndOrCriteriaGroup[0])).and(this.table.modelID, (VisitableCondition)SqlBuilder.isEqualTo((Object)model), new AndOrCriteriaGroup[0])).and(this.table.type, (VisitableCondition)SqlBuilder.isEqualTo((Object)((Object)RawRecItem.RawRecType.ADDITIONAL_LAYOUT)), new AndOrCriteriaGroup[0])).and(this.table.state, (VisitableCondition)SqlBuilder.isEqualTo((Object)((Object)state)), new AndOrCriteriaGroup[0]);
        if (minCost > 0.0) {
            queryBuilder = (QueryExpressionDSL.QueryExpressionWhereBuilder)queryBuilder.and(this.table.cost, (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo((Object)minCost), new AndOrCriteriaGroup[0]);
        }
        SelectStatementProvider statementProvider = ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)queryBuilder.and(this.table.recSource, (VisitableCondition)SqlBuilder.isNotIn((Object[])new String[]{"IMPORTED", "INDEX_PLANNER"}), new AndOrCriteriaGroup[0])).orderBy(new SortSpecification[]{this.table.cost.descending(), this.table.hitCount.descending(), this.table.id.descending()}).limit((long)topN).offset((long)offset).build()).render(RenderingStrategies.MYBATIS3);
        List<RawRecItem> rawRecItems = mapper.selectMany(statementProvider);
        log.info("Query topN({}) recommendations for adding to model({}/{}, semanticVersion: {}) takes {} ms.", new Object[]{topN, project, model, semanticVersion, System.currentTimeMillis() - startTime});
        return rawRecItems;
    }

    public List<RawRecItem> chooseTopNCandidates(String project, String model, int topN, int offset, RawRecItem.RawRecState state) {
        return this.chooseTopNCandidates(project, model, -1.0, topN, offset, state);
    }

    public List<RawRecItem> chooseIndexPlannerCandidates(String project, String model) {
        int semanticVersion = this.getSemanticVersion(project, model);
        if (semanticVersion == Integer.MIN_VALUE) {
            log.debug("chooseIndexPlannerCandidates - model({}/{}) does not exist.", (Object)project, (Object)model);
            return Lists.newArrayList();
        }
        long startTime = System.currentTimeMillis();
        RawRecItemMapper mapper = (RawRecItemMapper)this.sqlSessionTemplate.getMapper(RawRecItemMapper.class);
        QueryExpressionDSL.QueryExpressionWhereBuilder queryBuilder = (QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])this.getSelectFields(this.table)).from((SqlTable)this.table).where(this.table.project, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).and(this.table.semanticVersion, (VisitableCondition)SqlBuilder.isEqualTo((Object)semanticVersion), new AndOrCriteriaGroup[0])).and(this.table.modelID, (VisitableCondition)SqlBuilder.isEqualTo((Object)model), new AndOrCriteriaGroup[0])).and(this.table.type, (VisitableCondition)SqlBuilder.isEqualTo((Object)((Object)RawRecItem.RawRecType.ADDITIONAL_LAYOUT)), new AndOrCriteriaGroup[0])).and(this.table.state, (VisitableCondition)SqlBuilder.isEqualTo((Object)((Object)RawRecItem.RawRecState.RECOMMENDED)), new AndOrCriteriaGroup[0]);
        SelectStatementProvider statementProvider = ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)queryBuilder.and(this.table.recSource, (VisitableCondition)SqlBuilder.isEqualTo((Object)"INDEX_PLANNER"), new AndOrCriteriaGroup[0])).orderBy(new SortSpecification[]{this.table.cost.descending(), this.table.hitCount.descending(), this.table.id.descending()}).build()).render(RenderingStrategies.MYBATIS3);
        List<RawRecItem> rawRecItems = mapper.selectMany(statementProvider);
        log.info("Query IndexPlannerCandidates for adding to model({}/{}, semanticVersion: {}) takes {} ms.", new Object[]{project, model, semanticVersion, System.currentTimeMillis() - startTime});
        return rawRecItems;
    }

    public List<RawRecItem> queryImportedRawRecItems(String project, String model, RawRecItem.RawRecState state) {
        int semanticVersion = this.getSemanticVersion(project, model);
        if (semanticVersion == Integer.MIN_VALUE) {
            log.debug("queryImportedRawRecItems - model({}/{}) does not exist.", (Object)project, (Object)model);
            return Lists.newArrayList();
        }
        long startTime = System.currentTimeMillis();
        RawRecItemMapper mapper = (RawRecItemMapper)this.sqlSessionTemplate.getMapper(RawRecItemMapper.class);
        SelectStatementProvider statementProvider = ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])this.getSelectFields(this.table)).from((SqlTable)this.table).where(this.table.project, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).and(this.table.semanticVersion, (VisitableCondition)SqlBuilder.isEqualTo((Object)semanticVersion), new AndOrCriteriaGroup[0])).and(this.table.modelID, (VisitableCondition)SqlBuilder.isEqualTo((Object)model), new AndOrCriteriaGroup[0])).and(this.table.type, (VisitableCondition)SqlBuilder.isEqualTo((Object)((Object)RawRecItem.RawRecType.ADDITIONAL_LAYOUT)), new AndOrCriteriaGroup[0])).and(this.table.state, (VisitableCondition)SqlBuilder.isEqualTo((Object)((Object)state)), new AndOrCriteriaGroup[0])).and(this.table.recSource, (VisitableCondition)SqlBuilder.isEqualTo((Object)"IMPORTED"), new AndOrCriteriaGroup[0])).orderBy(new SortSpecification[]{this.table.id.descending()}).build()).render(RenderingStrategies.MYBATIS3);
        List<RawRecItem> rawRecItems = mapper.selectMany(statementProvider);
        log.info("Query recommendations generated from imported sql for adding to model({}/{}, semanticVersion: {}) takes {} ms.", new Object[]{project, model, semanticVersion, System.currentTimeMillis() - startTime});
        return rawRecItems;
    }

    public List<RawRecItem> queryNonAppliedLayoutRecItems(String project, String model, boolean isAdditionalRec) {
        int semanticVersion = this.getSemanticVersion(project, model);
        if (semanticVersion == Integer.MIN_VALUE) {
            log.debug("queryNonAppliedLayoutRecItems - model({}/{}) does not exist.", (Object)project, (Object)model);
            return Lists.newArrayList();
        }
        RawRecItem.RawRecType type = isAdditionalRec ? RawRecItem.RawRecType.ADDITIONAL_LAYOUT : RawRecItem.RawRecType.REMOVAL_LAYOUT;
        long start = System.currentTimeMillis();
        RawRecItemMapper mapper = (RawRecItemMapper)this.sqlSessionTemplate.getMapper(RawRecItemMapper.class);
        SelectStatementProvider statementProvider = ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])this.getSelectFields(this.table)).from((SqlTable)this.table).where(this.table.project, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).and(this.table.semanticVersion, (VisitableCondition)SqlBuilder.isEqualTo((Object)semanticVersion), new AndOrCriteriaGroup[0])).and(this.table.modelID, (VisitableCondition)SqlBuilder.isEqualTo((Object)model), new AndOrCriteriaGroup[0])).and(this.table.type, (VisitableCondition)SqlBuilder.isEqualTo((Object)((Object)type)), new AndOrCriteriaGroup[0])).and(this.table.state, (VisitableCondition)SqlBuilder.isNotIn((Object[])new RawRecItem.RawRecState[]{RawRecItem.RawRecState.APPLIED, RawRecItem.RawRecState.BROKEN}), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
        List<RawRecItem> recItems = mapper.selectMany(statementProvider);
        log.info("Query raw recommendations of model({}/{}, semanticVersion: {}, type: {}) takes {} ms", new Object[]{project, model, semanticVersion, type.name(), System.currentTimeMillis() - start});
        return recItems;
    }

    public Pair<String, RawRecItem> queryRecItemByMd5(String md5, String content) {
        long start = System.currentTimeMillis();
        RawRecItemMapper mapper = (RawRecItemMapper)this.sqlSessionTemplate.getMapper(RawRecItemMapper.class);
        SelectStatementProvider statementProvider = ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])this.getSelectFields(this.table)).from((SqlTable)this.table).where(this.table.uniqueFlag, (VisitableCondition)SqlBuilder.isEqualTo((Object)md5), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
        RawRecItem recItem = mapper.selectOne(statementProvider);
        Pair result = null;
        if (recItem != null && content.equals(RawRecUtil.getContent(recItem))) {
            result = new Pair((Object)md5, (Object)recItem);
        } else {
            statementProvider = ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])this.getSelectFields(this.table)).from((SqlTable)this.table).where(this.table.uniqueFlag, (VisitableCondition)SqlBuilder.isLike((Object)(md5 + "_%")), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
            List<RawRecItem> recItems = mapper.selectMany(statementProvider);
            int maxItemId = 0;
            for (RawRecItem item : recItems) {
                if (RawRecUtil.getContent(item).equals(content)) {
                    result = new Pair((Object)item.getUniqueFlag(), (Object)item);
                    break;
                }
                maxItemId = Math.max(item.getId(), maxItemId);
            }
            if (result == null) {
                String newUniqueFlag;
                if (recItem == null) {
                    result = new Pair((Object)md5, null);
                } else if (recItems.isEmpty()) {
                    newUniqueFlag = String.format(Locale.ROOT, "%s_%d", md5, recItem.getId());
                    result = new Pair((Object)newUniqueFlag, null);
                } else {
                    newUniqueFlag = String.format(Locale.ROOT, "%s_%d", md5, maxItemId);
                    result = new Pair((Object)newUniqueFlag, null);
                }
            }
        }
        log.info("Query raw recommendations of content ({}) takes {} ms", (Object)content, (Object)(System.currentTimeMillis() - start));
        return result;
    }

    public List<RawRecItem> queryNonLayoutRecItems(String project, String model) {
        int semanticVersion = this.getSemanticVersion(project, model);
        if (semanticVersion == Integer.MIN_VALUE) {
            log.debug("queryNonLayoutRecItems - model({}/{}) does not exist.", (Object)project, (Object)model);
            return Lists.newArrayList();
        }
        long start = System.currentTimeMillis();
        RawRecItemMapper mapper = (RawRecItemMapper)this.sqlSessionTemplate.getMapper(RawRecItemMapper.class);
        SelectStatementProvider statementProvider = ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])this.getSelectFields(this.table)).from((SqlTable)this.table).where(this.table.project, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).and(this.table.semanticVersion, (VisitableCondition)SqlBuilder.isEqualTo((Object)semanticVersion), new AndOrCriteriaGroup[0])).and(this.table.modelID, (VisitableCondition)SqlBuilder.isEqualTo((Object)model), new AndOrCriteriaGroup[0])).and(this.table.state, (VisitableCondition)SqlBuilder.isNotEqualTo((Object)((Object)RawRecItem.RawRecState.BROKEN)), new AndOrCriteriaGroup[0])).and(this.table.type, (VisitableCondition)SqlBuilder.isNotIn((Object[])new RawRecItem.RawRecType[]{RawRecItem.RawRecType.ADDITIONAL_LAYOUT, RawRecItem.RawRecType.REMOVAL_LAYOUT}), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
        List<RawRecItem> recItems = mapper.selectMany(statementProvider);
        log.info("Query non-index raw recommendations of model({}/{}, semanticVersion: {}) takes {} ms", new Object[]{project, model, semanticVersion, System.currentTimeMillis() - start});
        return recItems;
    }

    public List<RawRecItem> queryNonLayoutRecItems(String project) {
        long start = System.currentTimeMillis();
        RawRecItemMapper mapper = (RawRecItemMapper)this.sqlSessionTemplate.getMapper(RawRecItemMapper.class);
        SelectStatementProvider statementProvider = ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])this.getSelectFields(this.table)).from((SqlTable)this.table).where(this.table.project, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).and(this.table.state, (VisitableCondition)SqlBuilder.isNotEqualTo((Object)((Object)RawRecItem.RawRecState.BROKEN)), new AndOrCriteriaGroup[0])).and(this.table.type, (VisitableCondition)SqlBuilder.isNotIn((Object[])new RawRecItem.RawRecType[]{RawRecItem.RawRecType.ADDITIONAL_LAYOUT, RawRecItem.RawRecType.REMOVAL_LAYOUT}), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
        List<RawRecItem> recItems = mapper.selectMany(statementProvider);
        log.info("Query non-index raw recommendations of project({}) takes {} ms", (Object)project, (Object)(System.currentTimeMillis() - start));
        return recItems;
    }

    private int getSemanticVersion(String project, String model) {
        NDataModelManager modelManager = NDataModelManager.getInstance(KylinConfig.getInstanceFromEnv(), project);
        NDataModel dataModel = modelManager.getDataModelDesc(model);
        if (dataModel == null || dataModel.isBroken()) {
            return Integer.MIN_VALUE;
        }
        return dataModel.getSemanticVersion();
    }

    public void updateState(List<Integer> idList, RawRecItem.RawRecState state) {
        long start = System.currentTimeMillis();
        JdbcUtil.withTransaction((DataSourceTransactionManager)this.transactionManager, () -> {
            RawRecItemMapper mapper = (RawRecItemMapper)this.sqlSessionTemplate.getMapper(RawRecItemMapper.class);
            ArrayList providers = Lists.newArrayList();
            long updateTime = System.currentTimeMillis();
            idList.forEach(id -> providers.add(this.changeRecStateProvider((int)id, state, updateTime)));
            if (FINAL_STATE.contains((Object)state)) {
                idList.forEach(id -> providers.add(this.clearFlagProvider((int)id, updateTime)));
            }
            providers.forEach(mapper::update);
            log.info("Update {} raw recommendation(s) to state({}) takes {} ms", new Object[]{idList.size(), state.name(), System.currentTimeMillis() - start});
            return null;
        });
    }

    public void update(RawRecItem recItem) {
        UpdateStatementProvider updateStatement;
        RawRecItemMapper mapper = (RawRecItemMapper)this.sqlSessionTemplate.getMapper(RawRecItemMapper.class);
        int rows = mapper.update(updateStatement = this.getUpdateProvider(recItem));
        if (rows <= 0) {
            throw new KylinException((ErrorCodeSupplier)CommonErrorCode.FAILED_UPDATE_METADATA, String.format(Locale.ROOT, "Failed to update recommendation (uniqueFlag: %s, content: %s", recItem.getUniqueFlag(), RawRecUtil.getContent(recItem)));
        }
        log.debug("Update one raw recommendation({})", (Object)recItem.getUniqueFlag());
    }

    public void batchAddOrUpdate(List<RawRecItem> recItems) {
        if (recItems == null || recItems.isEmpty()) {
            log.info("No raw recommendations need to add or update.");
            return;
        }
        recItems.forEach(this::addOrUpdate);
    }

    public void addOrUpdate(RawRecItem recItem) {
        if (recItem.getId() == 0) {
            this.save(recItem);
        } else {
            this.update(recItem);
        }
    }

    public void importRecommendations(String project, String modelId, List<RawRecItem> rawRecItems) {
        JdbcUtil.withTransaction((DataSourceTransactionManager)this.transactionManager, () -> {
            RawRecManager manager = RawRecManager.getInstance(project);
            int baseId = manager.getMaxId() + 100;
            HashMap<Integer, Integer> idChangedMap = new HashMap<Integer, Integer>();
            HashMap layoutRecommendations = new HashMap();
            HashMap md5ToUuid = new HashMap();
            AtomicInteger index = new AtomicInteger(0);
            List<RawRecItem> tmpRawRecItems = rawRecItems.stream().map(rawRecItem -> {
                rawRecItem.setProject(project);
                if (!modelId.equals(rawRecItem.getModelID())) {
                    rawRecItem.setModelID(modelId);
                    String content = RawRecUtil.getContent(rawRecItem);
                    String md5 = RawRecUtil.computeMD5(content);
                    Pair<String, RawRecItem> recItemPair = RawRecUtil.getRawRecItemFromMap(md5, content, md5ToUuid, layoutRecommendations);
                    rawRecItem.setUniqueFlag((String)recItemPair.getFirst());
                }
                String uniqueFlag = rawRecItem.getUniqueFlag();
                RawRecItem originalRawRecItem = manager.getRawRecItemByUniqueFlag(rawRecItem.getProject(), rawRecItem.getModelID(), uniqueFlag, rawRecItem.getSemanticVersion());
                int newId = originalRawRecItem != null ? originalRawRecItem.getId() : index.incrementAndGet() + baseId;
                idChangedMap.put(-rawRecItem.getId(), -newId);
                rawRecItem.setId(newId);
                return rawRecItem;
            }).collect(Collectors.toList());
            ImportModelContext.reorderRecommendations(tmpRawRecItems, idChangedMap);
            RawRecItemMapper mapper = (RawRecItemMapper)this.sqlSessionTemplate.getMapper(RawRecItemMapper.class);
            ArrayList updaters = Lists.newArrayList();
            ArrayList inserts = Lists.newArrayList();
            tmpRawRecItems.forEach(item -> {
                if (this.queryByUniqueFlag(item.getProject(), item.getModelID(), item.getUniqueFlag(), item.getSemanticVersion()) != null) {
                    updaters.add(this.getUpdateProvider((RawRecItem)item));
                } else {
                    inserts.add(this.getInsertProvider((RawRecItem)item, true));
                }
            });
            updaters.forEach(mapper::update);
            inserts.forEach(mapper::insert);
            return null;
        });
    }

    private void delete(String project) {
        long startTime = System.currentTimeMillis();
        try {
            RawRecItemMapper mapper = (RawRecItemMapper)this.sqlSessionTemplate.getMapper(RawRecItemMapper.class);
            DeleteModel deleteStatement = project != null ? (DeleteModel)((DeleteDSL.DeleteWhereBuilder)SqlBuilder.deleteFrom((SqlTable)this.table).where(this.table.project, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).build() : (DeleteModel)SqlBuilder.deleteFrom((SqlTable)this.table).build();
            int rows = mapper.delete(deleteStatement.render(RenderingStrategies.MYBATIS3));
            log.info("Delete {} row(s) raw recommendation takes {} ms.", (Object)rows, (Object)(System.currentTimeMillis() - startTime));
        }
        catch (Exception e) {
            if (project != null) {
                log.error("Fail to delete raw recommendations for deleted project({}).", (Object)project, (Object)e);
            }
            log.error("Fail to delete raw recommendations.", (Throwable)e);
        }
    }

    public void deleteByProject(String project) {
        this.delete(project);
    }

    public void deleteAll() {
        this.delete(null);
    }

    public void cleanForDeletedProject(List<String> projectList) {
        long startTime = System.currentTimeMillis();
        try {
            RawRecItemMapper mapper = (RawRecItemMapper)this.sqlSessionTemplate.getMapper(RawRecItemMapper.class);
            DeleteStatementProvider deleteStatement = ((DeleteModel)((DeleteDSL.DeleteWhereBuilder)SqlBuilder.deleteFrom((SqlTable)this.table).where(this.table.project, (VisitableCondition)SqlBuilder.isNotIn(projectList), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
            int rows = mapper.delete(deleteStatement);
            log.info("Delete {} row(s) residual raw recommendation takes {} ms", (Object)rows, (Object)(System.currentTimeMillis() - startTime));
        }
        catch (Exception e) {
            log.error("Fail to clean raw recommendations for deleted projects({})", (Object)projectList.toString(), (Object)e);
        }
    }

    public void deleteById(List<Integer> ids) {
        long startTime = System.currentTimeMillis();
        RawRecItemMapper mapper = (RawRecItemMapper)this.sqlSessionTemplate.getMapper(RawRecItemMapper.class);
        DeleteStatementProvider deleteStatement = ((DeleteModel)((DeleteDSL.DeleteWhereBuilder)SqlBuilder.deleteFrom((SqlTable)this.table).where(this.table.id, (VisitableCondition)SqlBuilder.isIn(ids), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
        int deleteSize = mapper.delete(deleteStatement);
        log.info("Delete {} row(s) raw recommendation takes {} ms", (Object)deleteSize, (Object)(System.currentTimeMillis() - startTime));
    }

    public void discardRecItemsOfBrokenModel(String model) {
        long startTime = System.currentTimeMillis();
        RawRecItem.RawRecType[] rawRecTypes = new RawRecItem.RawRecType[]{RawRecItem.RawRecType.ADDITIONAL_LAYOUT, RawRecItem.RawRecType.REMOVAL_LAYOUT};
        RawRecItemMapper mapper = (RawRecItemMapper)this.sqlSessionTemplate.getMapper(RawRecItemMapper.class);
        UpdateStatementProvider updateProvider = ((UpdateModel)((UpdateDSL.UpdateWhereBuilder)((UpdateDSL.UpdateWhereBuilder)SqlBuilder.update((SqlTable)this.table).set(this.table.updateTime).equalTo((Object)startTime).set(this.table.state).equalTo((Object)RawRecItem.RawRecState.DISCARD).where(this.table.modelID, (VisitableCondition)SqlBuilder.isEqualTo((Object)model), new AndOrCriteriaGroup[0])).and(this.table.type, (VisitableCondition)SqlBuilder.isIn((Object[])rawRecTypes), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
        int rows = mapper.update(updateProvider);
        log.info("Discard {} row(s) raw recommendation of broken model takes {} ms", (Object)rows, (Object)(System.currentTimeMillis() - startTime));
    }

    public int getRecItemCountByProject(String project, RawRecItem.RawRecType type) {
        SelectStatementProvider statementProvider = ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])new BasicColumn[]{SqlBuilder.count(this.table.id)}).from((SqlTable)this.table).where(this.table.project, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).and(this.table.type, (VisitableCondition)SqlBuilder.isEqualTo((Object)((Object)type)), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
        RawRecItemMapper mapper = (RawRecItemMapper)this.sqlSessionTemplate.getMapper(RawRecItemMapper.class);
        return mapper.selectAsInt(statementProvider);
    }

    public Set<String> updateAllCost(String project) {
        int batchToUpdate = 1000;
        long currentTime = System.currentTimeMillis();
        int effectiveDays = Integer.parseInt(FavoriteRuleManager.getInstance(project).getValue("effective_days"));
        RawRecItem.CostMethod costMethod = RawRecItem.CostMethod.getCostMethod(project);
        HashSet updateModels = Sets.newHashSet();
        return (Set)JdbcUtil.withTransaction((DataSourceTransactionManager)this.transactionManager, () -> {
            RawRecItemMapper mapper = (RawRecItemMapper)this.sqlSessionTemplate.getMapper(RawRecItemMapper.class);
            if (mapper.selectAsInt(this.getContStarProvider()) == 0) {
                return Sets.newHashSet();
            }
            int totalUpdated = 0;
            int i = 0;
            while (true) {
                List<RawRecItem> rawRecItems = mapper.selectMany(this.getSelectLayoutProvider(project, 1000, 1000 * i, RawRecItem.RawRecState.INITIAL, RawRecItem.RawRecState.RECOMMENDED));
                int size = rawRecItems.size();
                this.updateCost(effectiveDays, costMethod, currentTime, mapper, rawRecItems);
                rawRecItems.forEach(item -> updateModels.add(item.getModelID()));
                totalUpdated += size;
                if (size < 1000) break;
                ++i;
            }
            log.info("Update the cost of all {} raw recommendation takes {} ms", (Object)totalUpdated, (Object)(System.currentTimeMillis() - currentTime));
            return updateModels;
        });
    }

    public List<RawRecItem> list(Collection<Integer> rawRecIds) {
        if (rawRecIds.isEmpty()) {
            return Collections.emptyList();
        }
        long startTime = System.currentTimeMillis();
        RawRecItemMapper mapper = (RawRecItemMapper)this.sqlSessionTemplate.getMapper(RawRecItemMapper.class);
        QueryExpressionDSL.QueryExpressionWhereBuilder statement = (QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])this.getSelectFields(this.table)).from((SqlTable)this.table).where(this.table.id, (VisitableCondition)SqlBuilder.isIn(rawRecIds), new AndOrCriteriaGroup[0]);
        List<RawRecItem> rawRecItems = mapper.selectMany(((SelectModel)statement.build()).render(RenderingStrategies.MYBATIS3));
        log.info("List all raw recommendations id in {}) takes {} ms.", (Object)rawRecIds.stream().map(String::valueOf).collect(Collectors.joining(", ")), (Object)(System.currentTimeMillis() - startTime));
        return rawRecItems;
    }

    private void updateCost(int effectiveDays, RawRecItem.CostMethod costMethod, long currentTime, RawRecItemMapper mapper, List<RawRecItem> oneBatch) {
        if (oneBatch.isEmpty()) {
            return;
        }
        oneBatch.forEach(recItem -> {
            if ("IMPORTED".equalsIgnoreCase(recItem.getRecSource())) {
                recItem.setUpdateTime(currentTime);
                return;
            }
            recItem.updateCost(costMethod, currentTime, effectiveDays);
            recItem.setUpdateTime(currentTime);
        });
        ArrayList providers = Lists.newArrayList();
        oneBatch.forEach(item -> providers.add(this.getUpdateProvider((RawRecItem)item)));
        providers.forEach(mapper::update);
    }

    private SelectStatementProvider getSelectLayoutProvider(String project, int limit, int offset, RawRecItem.RawRecState ... states) {
        return ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])this.getSelectFields(this.table)).from((SqlTable)this.table).where(this.table.project, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).and(this.table.type, (VisitableCondition)SqlBuilder.isEqualTo((Object)((Object)RawRecItem.RawRecType.ADDITIONAL_LAYOUT)), new AndOrCriteriaGroup[0])).and(this.table.state, (VisitableCondition)SqlBuilder.isIn((Object[])states), new AndOrCriteriaGroup[0])).limit((long)limit).offset((long)offset).build()).render(RenderingStrategies.MYBATIS3);
    }

    SelectStatementProvider getMinIdProvider() {
        return ((SelectModel)SqlBuilder.select((BasicColumn[])new BasicColumn[]{SqlBuilder.min(this.table.id)}).from((SqlTable)this.table).build()).render(RenderingStrategies.MYBATIS3);
    }

    SelectStatementProvider getMaxIdProvider() {
        return ((SelectModel)SqlBuilder.select((BasicColumn[])new BasicColumn[]{SqlBuilder.max(this.table.id)}).from((SqlTable)this.table).build()).render(RenderingStrategies.MYBATIS3);
    }

    SelectStatementProvider getContStarProvider() {
        return ((SelectModel)SqlBuilder.select((BasicColumn[])new BasicColumn[]{SqlBuilder.count(this.table.id)}).from((SqlTable)this.table).build()).render(RenderingStrategies.MYBATIS3);
    }

    public SelectStatementProvider getSelectByIdStatementProvider(int id) {
        return ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])this.getSelectFields(this.table)).from((SqlTable)this.table).where(this.table.id, (VisitableCondition)SqlBuilder.isEqualTo((Object)id), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
    }

    SelectStatementProvider getSelectUniqueFlagIdStatementProvider(String project, String modelId, String uniqueFlag, Integer semanticVersion) {
        return ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])this.getSelectFields(this.table)).from((SqlTable)this.table).where(this.table.uniqueFlag, (VisitableCondition)SqlBuilder.isEqualTo((Object)uniqueFlag), new AndOrCriteriaGroup[0])).and(this.table.project, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).and(this.table.modelID, (VisitableCondition)SqlBuilder.isEqualTo((Object)modelId), new AndOrCriteriaGroup[0])).and(this.table.semanticVersion, (VisitableCondition)SqlBuilder.isEqualTo((Object)semanticVersion), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
    }

    public InsertStatementProvider<RawRecItem> getInsertProvider(RawRecItem recItem, boolean reserveId) {
        InsertDSL provider = SqlBuilder.insert((Object)recItem).into((SqlTable)this.table);
        if (reserveId) {
            provider = provider.map(this.table.id).toProperty("id");
        }
        return provider.map(this.table.project).toProperty("project").map(this.table.modelID).toProperty("modelID").map(this.table.uniqueFlag).toProperty("uniqueFlag").map(this.table.semanticVersion).toProperty("semanticVersion").map(this.table.type).toProperty("type").map(this.table.recEntity).toProperty("recEntity").map(this.table.state).toProperty("state").map(this.table.createTime).toProperty("createTime").map(this.table.updateTime).toProperty("updateTime").map(this.table.dependIDs).toPropertyWhenPresent("dependIDs", recItem::getDependIDs).map(this.table.mvcc).toProperty("mvcc").map(this.table.layoutMetric).toPropertyWhenPresent("layoutMetric", recItem::getLayoutMetric).map(this.table.cost).toPropertyWhenPresent("cost", recItem::getCost).map(this.table.totalLatencyOfLastDay).toPropertyWhenPresent("totalLatencyOfLastDay", recItem::getTotalLatencyOfLastDay).map(this.table.hitCount).toPropertyWhenPresent("hitCount", recItem::getHitCount).map(this.table.totalTime).toPropertyWhenPresent("totalTime", recItem::getMaxTime).map(this.table.maxTime).toPropertyWhenPresent("maxTime", recItem::getMinTime).map(this.table.minTime).toPropertyWhenPresent("minTime", recItem::getMinTime).map(this.table.queryHistoryInfo).toPropertyWhenPresent("queryHistoryInfo", recItem::getQueryHistoryInfo).map(this.table.recSource).toPropertyWhenPresent("recSource", recItem::getRecSource).build().render(RenderingStrategies.MYBATIS3);
    }

    UpdateStatementProvider changeRecStateProvider(int id, RawRecItem.RawRecState state, long updateTime) {
        return ((UpdateModel)((UpdateDSL.UpdateWhereBuilder)SqlBuilder.update((SqlTable)this.table).set(this.table.state).equalTo((Object)state).set(this.table.updateTime).equalTo((Object)updateTime).set(this.table.mvcc).equalTo((BasicColumn)SqlBuilder.add(this.table.mvcc, (BasicColumn)SqlBuilder.constant((String)"1"), (BasicColumn[])new BasicColumn[0])).where(this.table.id, (VisitableCondition)SqlBuilder.isEqualTo((Object)id), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
    }

    UpdateStatementProvider clearFlagProvider(int id, long updateTime) {
        return ((UpdateModel)((UpdateDSL.UpdateWhereBuilder)((UpdateDSL.UpdateWhereBuilder)SqlBuilder.update((SqlTable)this.table).set(this.table.uniqueFlag).equalToNull().set(this.table.updateTime).equalTo((Object)updateTime).set(this.table.mvcc).equalTo((BasicColumn)SqlBuilder.add(this.table.mvcc, (BasicColumn)SqlBuilder.constant((String)"1"), (BasicColumn[])new BasicColumn[0])).where(this.table.id, (VisitableCondition)SqlBuilder.isEqualTo((Object)id), new AndOrCriteriaGroup[0])).and(this.table.type, (VisitableCondition)SqlBuilder.isIn((Object[])new RawRecItem.RawRecType[]{RawRecItem.RawRecType.ADDITIONAL_LAYOUT, RawRecItem.RawRecType.REMOVAL_LAYOUT}), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
    }

    UpdateStatementProvider getUpdateProvider(RawRecItem recItem) {
        return ((UpdateModel)((UpdateDSL.UpdateWhereBuilder)((UpdateDSL.UpdateWhereBuilder)SqlBuilder.update((SqlTable)this.table).set(this.table.uniqueFlag).equalTo(recItem::getUniqueFlag).set(this.table.semanticVersion).equalTo(recItem::getSemanticVersion).set(this.table.state).equalTo(recItem::getState).set(this.table.updateTime).equalTo(recItem::getUpdateTime).set(this.table.recEntity).equalTo(recItem::getRecEntity).set(this.table.dependIDs).equalToWhenPresent(recItem::getDependIDs).set(this.table.layoutMetric).equalToWhenPresent(recItem::getLayoutMetric).set(this.table.cost).equalToWhenPresent(recItem::getCost).set(this.table.totalLatencyOfLastDay).equalToWhenPresent(recItem::getTotalLatencyOfLastDay).set(this.table.hitCount).equalToWhenPresent(recItem::getHitCount).set(this.table.totalTime).equalToWhenPresent(recItem::getTotalTime).set(this.table.maxTime).equalToWhenPresent(recItem::getMaxTime).set(this.table.minTime).equalToWhenPresent(recItem::getMinTime).set(this.table.queryHistoryInfo).equalToWhenPresent(recItem::getQueryHistoryInfo).set(this.table.recSource).equalTo(recItem::getRecSource).set(this.table.mvcc).equalTo((Object)(recItem.getMvcc() + 1L)).where(this.table.id, (VisitableCondition)SqlBuilder.isEqualTo(recItem::getId), new AndOrCriteriaGroup[0])).and(this.table.mvcc, (VisitableCondition)SqlBuilder.isEqualTo(recItem::getMvcc), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
    }

    private BasicColumn[] getSelectFields(RawRecItemTable recItemTable) {
        return BasicColumn.columnList((BasicColumn[])new BasicColumn[]{recItemTable.id, recItemTable.project, recItemTable.modelID, recItemTable.uniqueFlag, recItemTable.semanticVersion, recItemTable.type, recItemTable.recEntity, recItemTable.dependIDs, recItemTable.mvcc, recItemTable.state, recItemTable.createTime, recItemTable.updateTime, recItemTable.layoutMetric, recItemTable.cost, recItemTable.totalLatencyOfLastDay, recItemTable.hitCount, recItemTable.totalTime, recItemTable.maxTime, recItemTable.minTime, recItemTable.queryHistoryInfo, recItemTable.recSource});
    }

    public int getMaxId() {
        RawRecItemMapper mapper = (RawRecItemMapper)this.sqlSessionTemplate.getMapper(RawRecItemMapper.class);
        if (mapper.selectAsInt(this.getContStarProvider()) == 0) {
            return 0;
        }
        return mapper.selectAsInt(this.getMaxIdProvider());
    }

    public int getMinId() {
        RawRecItemMapper mapper = (RawRecItemMapper)this.sqlSessionTemplate.getMapper(RawRecItemMapper.class);
        if (mapper.selectAsInt(this.getContStarProvider()) == 0) {
            return 0;
        }
        return mapper.selectAsInt(this.getMinIdProvider());
    }

    public void deleteOutdated() {
        List<RawRecItem> items;
        int batch = 1000;
        int maxId = this.getMaxId();
        int currentId = this.getMinId() - 1;
        ArrayList outDatedItems = Lists.newArrayList();
        BasicColumn[] cols = BasicColumn.columnList((BasicColumn[])new BasicColumn[]{this.table.id, this.table.project, this.table.modelID, this.table.semanticVersion});
        while (currentId < maxId && !CollectionUtils.isEmpty(items = this.queryFrom(cols, currentId, batch))) {
            for (RawRecItem item : items) {
                currentId = Math.max(currentId, item.getId());
                if (!this.outDated(item)) continue;
                outDatedItems.add(item.getId());
                if (outDatedItems.size() != batch) continue;
                this.deleteById(outDatedItems);
                outDatedItems = Lists.newArrayList();
            }
        }
        if (!outDatedItems.isEmpty()) {
            this.deleteById(outDatedItems);
        }
    }

    private boolean outDated(RawRecItem item) {
        String project = item.getProject();
        String modelId = item.getModelID();
        if (NProjectManager.getInstance(KylinConfig.getInstanceFromEnv()).getProject(project) == null) {
            return true;
        }
        NDataModelManager modelManager = NDataModelManager.getInstance(KylinConfig.getInstanceFromEnv(), project);
        NDataModel dataModel = modelManager.getDataModelDesc(modelId);
        if (dataModel == null) {
            return true;
        }
        if (dataModel.isBroken()) {
            return false;
        }
        return item.getSemanticVersion() < dataModel.getSemanticVersion() - 1;
    }

    @Generated
    public SqlSessionTemplate getSqlSessionTemplate() {
        return this.sqlSessionTemplate;
    }

    @Generated
    public DataSourceTransactionManager getTransactionManager() {
        return this.transactionManager;
    }
}

