/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.state;

import java.util.HashMap;
import java.util.List;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.Singletons;
import org.apache.kylin.common.state.IStateSwitch;
import org.apache.kylin.common.util.AddressUtil;
import org.apache.kylin.metadata.state.MetadataStateSwitch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryShareStateManager {
    private static final Logger logger = LoggerFactory.getLogger(QueryShareStateManager.class);
    private static final String SHARE_STATE_CLOSE = "close";
    private static final String INSTANCE_NAME = AddressUtil.concatInstanceName();
    private IStateSwitch stateSwitch;

    public static QueryShareStateManager getInstance() {
        QueryShareStateManager instance = null;
        try {
            instance = (QueryShareStateManager)Singletons.getInstance(QueryShareStateManager.class);
        }
        catch (RuntimeException e) {
            logger.error("QueryShareStateManager init failed: ", (Throwable)e);
        }
        return instance;
    }

    private QueryShareStateManager() {
        if (!QueryShareStateManager.isShareStateSwitchEnabled()) {
            return;
        }
        this.stateSwitch = new MetadataStateSwitch();
        HashMap<String, String> initStateMap = new HashMap<String, String>();
        initStateMap.put("QueryLimit", "false");
        this.stateSwitch.init(INSTANCE_NAME, initStateMap);
    }

    public static boolean isShareStateSwitchEnabled() {
        return !SHARE_STATE_CLOSE.equals(KapConfig.getInstanceFromEnv().getShareStateSwitchImplement());
    }

    public void setState(List<String> instanceNameList, String stateName, String stateValue) {
        if (!QueryShareStateManager.isShareStateSwitchEnabled()) {
            return;
        }
        logger.info("Receive state set signal, instance:{}, stateName:{}, stateValue:{}", new Object[]{instanceNameList, stateName, stateValue});
        for (String instance : instanceNameList) {
            this.stateSwitch.put(instance, stateName, stateValue);
        }
    }

    public String getState(String stateName) {
        String stateValue = null;
        if (QueryShareStateManager.isShareStateSwitchEnabled()) {
            stateValue = this.stateSwitch.get(INSTANCE_NAME, stateName);
            logger.info("Get state value, instance:{}, stateName:{}, stateValue:{}", new Object[]{INSTANCE_NAME, stateName, stateValue});
        }
        return stateValue;
    }
}

