/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.streaming;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Maps;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class KafkaConfig
extends RootPersistentEntity
implements Serializable {
    @JsonProperty(value="database")
    private String database;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="project")
    private String project;
    @JsonProperty(value="kafka_bootstrap_servers")
    private String kafkaBootstrapServers;
    @JsonProperty(value="subscribe")
    private String subscribe;
    @JsonProperty(value="starting_offsets")
    private String startingOffsets;
    @JsonProperty(value="batch_table_identity")
    private String batchTable;
    @JsonProperty(value="parser_name")
    private String parserName;
    private Map<String, String> kafkaParam;

    public KafkaConfig() {
    }

    public KafkaConfig(KafkaConfig other) {
        this.uuid = other.uuid;
        this.lastModified = other.lastModified;
        this.createTime = other.createTime;
        this.name = other.name;
        this.kafkaBootstrapServers = other.kafkaBootstrapServers;
        this.subscribe = other.subscribe;
        this.startingOffsets = other.startingOffsets;
        this.project = other.project;
        this.parserName = other.parserName;
        this.batchTable = other.batchTable;
    }

    public Map<String, String> getKafkaParam() {
        Preconditions.checkState((this.kafkaBootstrapServers != null && this.subscribe != null && this.startingOffsets != null ? 1 : 0) != 0, (Object)"table are not streaming table");
        if (this.kafkaParam == null) {
            this.kafkaParam = Maps.newHashMap();
            this.kafkaParam.put("kafka.bootstrap.servers", this.kafkaBootstrapServers);
            this.kafkaParam.put("subscribe", this.subscribe);
            this.kafkaParam.put("startingOffsets", this.startingOffsets);
            this.kafkaParam.put("failOnDataLoss", "false");
        }
        return this.kafkaParam;
    }

    public String getIdentity() {
        String originIdentity = String.format(Locale.ROOT, "%s.%s", this.database, this.name);
        return originIdentity.toUpperCase(Locale.ROOT);
    }

    public String resourceName() {
        return KafkaConfig.generateResourceName(this.getProject(), this.getIdentity());
    }

    public static String generateResourceName(String project, String identity) {
        return project + "." + identity;
    }

    public MetadataType resourceType() {
        return MetadataType.KAFKA_CONFIG;
    }

    public String getBatchTableAlias() {
        return this.batchTable.split("\\.")[1];
    }

    public boolean hasBatchTable() {
        return StringUtils.isNotEmpty((CharSequence)this.batchTable);
    }

    @Generated
    public String getDatabase() {
        return this.database;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getProject() {
        return this.project;
    }

    @Generated
    public String getKafkaBootstrapServers() {
        return this.kafkaBootstrapServers;
    }

    @Generated
    public String getSubscribe() {
        return this.subscribe;
    }

    @Generated
    public String getStartingOffsets() {
        return this.startingOffsets;
    }

    @Generated
    public String getBatchTable() {
        return this.batchTable;
    }

    @Generated
    public String getParserName() {
        return this.parserName;
    }

    @Generated
    public void setDatabase(String database) {
        this.database = database;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setProject(String project) {
        this.project = project;
    }

    @Generated
    public void setKafkaBootstrapServers(String kafkaBootstrapServers) {
        this.kafkaBootstrapServers = kafkaBootstrapServers;
    }

    @Generated
    public void setSubscribe(String subscribe) {
        this.subscribe = subscribe;
    }

    @Generated
    public void setStartingOffsets(String startingOffsets) {
        this.startingOffsets = startingOffsets;
    }

    @Generated
    public void setBatchTable(String batchTable) {
        this.batchTable = batchTable;
    }

    @Generated
    public void setParserName(String parserName) {
        this.parserName = parserName;
    }

    @Generated
    public void setKafkaParam(Map<String, String> kafkaParam) {
        this.kafkaParam = kafkaParam;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaConfig)) {
            return false;
        }
        KafkaConfig other = (KafkaConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$project = this.getProject();
        String other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        String this$kafkaBootstrapServers = this.getKafkaBootstrapServers();
        String other$kafkaBootstrapServers = other.getKafkaBootstrapServers();
        if (this$kafkaBootstrapServers == null ? other$kafkaBootstrapServers != null : !this$kafkaBootstrapServers.equals(other$kafkaBootstrapServers)) {
            return false;
        }
        String this$subscribe = this.getSubscribe();
        String other$subscribe = other.getSubscribe();
        if (this$subscribe == null ? other$subscribe != null : !this$subscribe.equals(other$subscribe)) {
            return false;
        }
        String this$startingOffsets = this.getStartingOffsets();
        String other$startingOffsets = other.getStartingOffsets();
        if (this$startingOffsets == null ? other$startingOffsets != null : !this$startingOffsets.equals(other$startingOffsets)) {
            return false;
        }
        String this$batchTable = this.getBatchTable();
        String other$batchTable = other.getBatchTable();
        if (this$batchTable == null ? other$batchTable != null : !this$batchTable.equals(other$batchTable)) {
            return false;
        }
        String this$parserName = this.getParserName();
        String other$parserName = other.getParserName();
        if (this$parserName == null ? other$parserName != null : !this$parserName.equals(other$parserName)) {
            return false;
        }
        Map<String, String> this$kafkaParam = this.getKafkaParam();
        Map<String, String> other$kafkaParam = other.getKafkaParam();
        return !(this$kafkaParam == null ? other$kafkaParam != null : !((Object)this$kafkaParam).equals(other$kafkaParam));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KafkaConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        String $kafkaBootstrapServers = this.getKafkaBootstrapServers();
        result = result * 59 + ($kafkaBootstrapServers == null ? 43 : $kafkaBootstrapServers.hashCode());
        String $subscribe = this.getSubscribe();
        result = result * 59 + ($subscribe == null ? 43 : $subscribe.hashCode());
        String $startingOffsets = this.getStartingOffsets();
        result = result * 59 + ($startingOffsets == null ? 43 : $startingOffsets.hashCode());
        String $batchTable = this.getBatchTable();
        result = result * 59 + ($batchTable == null ? 43 : $batchTable.hashCode());
        String $parserName = this.getParserName();
        result = result * 59 + ($parserName == null ? 43 : $parserName.hashCode());
        Map<String, String> $kafkaParam = this.getKafkaParam();
        result = result * 59 + ($kafkaParam == null ? 43 : ((Object)$kafkaParam).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "KafkaConfig(database=" + this.getDatabase() + ", name=" + this.getName() + ", project=" + this.getProject() + ", kafkaBootstrapServers=" + this.getKafkaBootstrapServers() + ", subscribe=" + this.getSubscribe() + ", startingOffsets=" + this.getStartingOffsets() + ", batchTable=" + this.getBatchTable() + ", parserName=" + this.getParserName() + ", kafkaParam=" + this.getKafkaParam() + ")";
    }
}

