/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.tuple;

import java.math.BigDecimal;
import java.util.List;
import net.sf.ehcache.pool.sizeof.annotations.IgnoreSizeOf;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.metadata.datatype.DoubleMutable;
import org.apache.kylin.metadata.datatype.LongMutable;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.tuple.ITuple;
import org.apache.kylin.metadata.tuple.TupleInfo;

public class Tuple
implements ITuple {
    @IgnoreSizeOf
    private final TupleInfo info;
    private final Object[] values;

    public Tuple(TupleInfo info) {
        this.info = info;
        this.values = new Object[info.size()];
    }

    @Override
    public List<String> getAllFields() {
        return this.info.getAllFields();
    }

    @Override
    public List<TblColRef> getAllColumns() {
        return this.info.getAllColumns();
    }

    @Override
    public Object[] getAllValues() {
        return this.values;
    }

    public Object clone() {
        return this.makeCopy();
    }

    @Override
    public ITuple makeCopy() {
        Tuple ret = new Tuple(this.info);
        System.arraycopy(this.values, 0, ret.values, 0, this.values.length);
        return ret;
    }

    public TupleInfo getInfo() {
        return this.info;
    }

    public Object getValue(String fieldName) {
        int index = this.info.getFieldIndex(fieldName);
        return this.values[index];
    }

    @Override
    public Object getValue(TblColRef col) {
        int index = this.info.getColumnIndex(col);
        return this.values[index];
    }

    public String getDataTypeName(int idx) {
        return this.info.getDataTypeName(idx);
    }

    public void setDimensionValue(int idx, String fieldValue) {
        Object objectValue;
        this.values[idx] = objectValue = Tuple.convertOptiqCellValue(fieldValue, this.getDataTypeName(idx));
    }

    public void setMeasureValue(int idx, Object fieldValue) {
        fieldValue = this.convertWritableToJava(fieldValue);
        String dataType = this.getDataTypeName(idx);
        if ("double".equals(dataType) && fieldValue instanceof BigDecimal) {
            fieldValue = ((BigDecimal)fieldValue).doubleValue();
        } else if ("decimal".equals(dataType) && fieldValue instanceof BigDecimal) {
            fieldValue = Tuple.normalizeDecimal((BigDecimal)fieldValue);
        } else if ("integer".equals(dataType) && fieldValue instanceof Number) {
            fieldValue = ((Number)fieldValue).intValue();
        } else if ("smallint".equals(dataType) && fieldValue instanceof Number) {
            fieldValue = ((Number)fieldValue).shortValue();
        } else if ("tinyint".equals(dataType)) {
            fieldValue = ((Number)fieldValue).byteValue();
        } else if ("float".equals(dataType) && fieldValue instanceof BigDecimal) {
            fieldValue = Float.valueOf(((BigDecimal)fieldValue).floatValue());
        } else if ("date".equals(dataType) && fieldValue instanceof Long) {
            long millis = (Long)fieldValue;
            fieldValue = (int)(millis / 86400000L);
        } else if ("smallint".equals(dataType) && fieldValue instanceof Long) {
            fieldValue = ((Long)fieldValue).shortValue();
        } else if (!("varchar".equals(dataType) && "char".equals(dataType) || !(fieldValue instanceof String))) {
            fieldValue = Tuple.convertOptiqCellValue((String)fieldValue, dataType);
        } else if ("bigint".equals(dataType) && fieldValue instanceof Double) {
            fieldValue = ((Double)fieldValue).longValue();
        }
        this.values[idx] = fieldValue;
    }

    private Object convertWritableToJava(Object o) {
        if (o instanceof LongMutable) {
            o = ((LongMutable)o).get();
        } else if (o instanceof DoubleMutable) {
            o = ((DoubleMutable)o).get();
        }
        return o;
    }

    private static BigDecimal normalizeDecimal(BigDecimal input) {
        if (input.scale() < 0) {
            return input.setScale(0);
        }
        return input;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String field : this.info.getAllFields()) {
            sb.append(field);
            sb.append("=");
            sb.append(this.getValue(field));
            sb.append(",");
        }
        return sb.toString();
    }

    public static Object convertOptiqCellValue(String strValue, String dataTypeName) {
        if (strValue == null) {
            return null;
        }
        if ((strValue.equals("") || strValue.equals("\\N")) && !dataTypeName.equals("string") && !dataTypeName.startsWith("varchar")) {
            return null;
        }
        switch (dataTypeName) {
            case "date": {
                return Tuple.dateToEpicDays(strValue);
            }
            case "datetime": 
            case "timestamp": {
                return DateFormat.stringToMillis((String)strValue, (boolean)true);
            }
            case "tinyint": {
                return Byte.parseByte(strValue);
            }
            case "smallint": {
                return Short.parseShort(strValue);
            }
            case "integer": {
                return Integer.parseInt(strValue);
            }
            case "bigint": {
                return Long.parseLong(strValue);
            }
            case "double": {
                return Double.parseDouble(strValue);
            }
            case "decimal": {
                return Tuple.normalizeDecimal(new BigDecimal(strValue));
            }
            case "float": {
                return Float.valueOf(Float.parseFloat(strValue));
            }
            case "boolean": {
                return Boolean.parseBoolean(strValue) || "1".equals(strValue);
            }
        }
        return strValue;
    }

    private static int dateToEpicDays(String strValue) {
        long millis = DateFormat.stringToMillis((String)strValue, (boolean)true);
        return (int)(millis / 86400000L);
    }
}

