/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.rest.security.AclPermission;
import org.apache.kylin.rest.security.AclPermissionEnum;
import org.springframework.security.acls.domain.DefaultPermissionFactory;
import org.springframework.security.acls.model.Permission;

public class AclPermissionFactory
extends DefaultPermissionFactory {
    public AclPermissionFactory() {
        this.registerPublicPermissions(AclPermission.class);
    }

    public static List<Permission> getPermissions() {
        Field[] fields = AclPermission.class.getFields();
        ArrayList permissions = Lists.newArrayListWithExpectedSize((int)fields.length);
        for (Field field : fields) {
            try {
                Object fieldValue = field.get(null);
                if (!Permission.class.isAssignableFrom(fieldValue.getClass())) continue;
                Permission perm = (Permission)fieldValue;
                String permissionName = field.getName();
                if (!permissionName.equals(AclPermissionEnum.ADMINISTRATION.name()) && !permissionName.equals(AclPermissionEnum.MANAGEMENT.name()) && !permissionName.equals(AclPermissionEnum.OPERATION.name()) && !permissionName.equals(AclPermissionEnum.READ.name())) continue;
                permissions.add(perm);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return permissions;
    }

    public static Permission getPermission(String perName) {
        Field[] fields;
        for (Field field : fields = AclPermission.class.getFields()) {
            try {
                Object fieldValue = field.get(null);
                if (!Permission.class.isAssignableFrom(fieldValue.getClass()) || !perName.equals(field.getName())) continue;
                return (Permission)fieldValue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static List<Permission> getExtPermissions(List<String> perNames) {
        Field[] fields = AclPermission.class.getFields();
        ArrayList<Permission> ps = new ArrayList<Permission>();
        for (Field field : fields) {
            try {
                Object fieldValue = field.get(null);
                if (!Permission.class.isAssignableFrom(fieldValue.getClass()) || !perNames.contains(field.getName())) continue;
                ps.add((Permission)fieldValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ps;
    }
}

