/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.adhocquery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlHint;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlNameMatchers;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.model.tool.CalciteParser;
import org.apache.kylin.source.adhocquery.IPushDownConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoubleQuotePushDownConverter
implements IPushDownConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DoubleQuotePushDownConverter.class);

    @Override
    public String convert(String originSql, String project, String defaultSchema) {
        return DoubleQuotePushDownConverter.convertDoubleQuote(originSql, project);
    }

    public static String convertDoubleQuote(String originSql) {
        return DoubleQuotePushDownConverter.convertDoubleQuote(originSql, null);
    }

    public static String convertDoubleQuote(String originSql, String project) {
        String sqlParsed = originSql;
        try {
            DoubleQuoteSqlIdentifierConvert sqlIdentifierConvert = new DoubleQuoteSqlIdentifierConvert(originSql, project);
            sqlParsed = sqlIdentifierConvert.convert();
        }
        catch (Exception e) {
            log.warn("convert sql:{} with double quoted with exception", (Object)originSql, (Object)e);
        }
        return sqlParsed;
    }

    private static class DoubleQuoteSqlIdentifierConvert {
        private final String sql;
        private final String project;

        public DoubleQuoteSqlIdentifierConvert(String sql, String project) {
            this.sql = sql;
            this.project = project;
        }

        private SqlNode parse() throws SqlParseException {
            return CalciteParser.parse(this.sql, this.project);
        }

        private Collection<SqlIdentifier> getAllNonHintSqlIdentifiers() throws SqlParseException {
            final HashSet identifiers = Sets.newHashSet();
            SqlBasicVisitor<Void> sqlVisitor = new SqlBasicVisitor<Void>(){

                public Void visit(SqlIdentifier id) {
                    if (!this.isFunctionWithoutParentheses(id)) {
                        identifiers.add(id);
                    }
                    return null;
                }

                public Void visit(SqlCall call) {
                    if (call instanceof SqlHint) {
                        return null;
                    }
                    return (Void)super.visit(call);
                }
            };
            this.parse().accept((SqlVisitor)sqlVisitor);
            return identifiers;
        }

        public String convert() throws SqlParseException {
            StringBuilder sqlConvertedStringBuilder = new StringBuilder(this.sql);
            ArrayList sqlIdentifierList = Lists.newArrayList(this.getAllNonHintSqlIdentifiers());
            CalciteParser.descSortByPosition(sqlIdentifierList);
            sqlIdentifierList.forEach(sqlIdentifier -> {
                Pair<Integer, Integer> replacePos = CalciteParser.getReplacePos((SqlNode)sqlIdentifier, this.sql);
                List toStarNames = SqlIdentifier.toStar((List)sqlIdentifier.names);
                String newIdentifierStr = toStarNames.stream().map(this::convertIdentifier).collect(Collectors.joining("."));
                sqlConvertedStringBuilder.replace((Integer)replacePos.getFirst(), (Integer)replacePos.getSecond(), newIdentifierStr);
            });
            return sqlConvertedStringBuilder.toString();
        }

        private String convertIdentifier(String identifierStr) {
            if (identifierStr.equals("*")) {
                return identifierStr;
            }
            return Quoting.DOUBLE_QUOTE.string + identifierStr + Quoting.DOUBLE_QUOTE.string;
        }

        private boolean isFunctionWithoutParentheses(SqlIdentifier id) {
            if (id.names.size() == 1 && !id.isComponentQuoted(0)) {
                ArrayList list = new ArrayList();
                SqlStdOperatorTable opTab = SqlStdOperatorTable.instance();
                opTab.lookupOperatorOverloads(id, null, SqlSyntax.FUNCTION, list, SqlNameMatchers.withCaseSensitive((boolean)false));
                return list.stream().anyMatch(operator -> operator.getSyntax() == SqlSyntax.FUNCTION_ID);
            }
            return false;
        }
    }
}

