/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.kylin.engine.spark.builder.DictionaryBuilderHelper;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.PartitionStatusEnum;
import org.apache.kylin.metadata.model.TblColRef;

public class PartitionDictionaryBuilderHelper
extends DictionaryBuilderHelper {
    public static Set<TblColRef> extractTreeRelatedGlobalDictToBuild(NDataSegment seg, Collection<IndexEntity> toBuildIndexEntities) {
        Set newPartitions;
        ArrayList toBuildCuboids = Lists.newArrayList();
        for (IndexEntity desc : toBuildIndexEntities) {
            toBuildCuboids.addAll(desc.getLayouts());
        }
        ArrayList buildedLayouts = Lists.newArrayList();
        if (seg.getSegDetails() != null && CollectionUtils.isEmpty(newPartitions = seg.getMultiPartitions().stream().filter(partition -> partition.getStatus() != PartitionStatusEnum.READY).collect(Collectors.toSet()))) {
            for (NDataLayout cuboid : seg.getSegDetails().getEffectiveLayouts()) {
                buildedLayouts.add(cuboid.getLayout());
            }
        }
        Set<TblColRef> buildedColRefSet = PartitionDictionaryBuilderHelper.findNeedDictCols(buildedLayouts);
        Set<TblColRef> toBuildColRefSet = PartitionDictionaryBuilderHelper.findNeedDictCols(toBuildCuboids);
        toBuildColRefSet.removeIf(buildedColRefSet::contains);
        return toBuildColRefSet;
    }
}

