/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job.step.build;

import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.kylin.engine.spark.job.SanityChecker$;
import org.apache.kylin.engine.spark.job.SegmentExec;
import org.apache.kylin.engine.spark.job.SegmentJob;
import org.apache.kylin.engine.spark.job.step.ParamPropagation;
import org.apache.kylin.engine.spark.job.step.StageExec;
import org.apache.kylin.engine.spark.job.step.build.FlatTableStage;
import org.apache.kylin.engine.spark.job.step.build.MaterializeFlatTable$;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Queues;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.datasource.storage.StorageStoreUtils$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\u0005ef\u0001\u0002\u0014(\u0001aB\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\"AQ\n\u0001B\u0001B\u0003%a\nC\u0003S\u0001\u0011\u00051\u000bC\u0004Y\u0001\u0001\u0007I\u0011B-\t\u000f\u0001\u0004\u0001\u0019!C\u0005C\"1q\r\u0001Q!\niCQ\u0001\u001b\u0001\u0005B%DQA\u001b\u0001\u0005\n-DQ\u0001\u001c\u0001\u0005\n-DQ!\u001c\u0001\u0005\n9Da!a\r\u0001\t\u0013I\u0007bBA\u001b\u0001\u0011\u0005\u0013q\u0007\u0005\b\u0003\u0013\u0002A\u0011IA&\r\u0019\ty\u0006\u0001\t\u0002b!Iqp\u0004BC\u0002\u0013\u0005\u0011\u0011\u0001\u0005\u000b\u0003\u0013y!\u0011!Q\u0001\n\u0005\r\u0001BCA7\u001f\t\u0015\r\u0011\"\u0001\u0002p!Q\u0011QQ\b\u0003\u0002\u0003\u0006I!!\u001d\t\rI{A\u0011AAD\u0011\u001d\tyi\u0004C!\u0003o1AA\u001f\u0001\u0011w\"IqP\u0006BC\u0002\u0013\u0005\u0011\u0011\u0001\u0005\u000b\u0003\u00131\"\u0011!Q\u0001\n\u0005\r\u0001BCA\u0006-\t\u0015\r\u0011\"\u0001\u0002\u000e!I\u0011q\u0002\f\u0003\u0002\u0003\u0006I\u0001\u001d\u0005\u0007%Z!\t!!\u0005\b\u000f\u0005Eu\u0005#\u0001\u0002\u0014\u001a1ae\nE\u0001\u0003+CaAU\u000f\u0005\u0002\u0005]\u0005\"CAM;\t\u0007I\u0011AA\u0007\u0011\u001d\tY*\bQ\u0001\nAD\u0011\"!(\u001e\u0005\u0004%\t!!\u0004\t\u000f\u0005}U\u0004)A\u0005a\"9\u0011\u0011U\u000f\u0005\u0002\u0005\r\u0006bBAT;\u0011\u0005\u0011\u0011\u0016\u0005\b\u0003[kB\u0011AAX\u0005Qi\u0015\r^3sS\u0006d\u0017N_3GY\u0006$H+\u00192mK*\u0011\u0001&K\u0001\u0006EVLG\u000e\u001a\u0006\u0003U-\nAa\u001d;fa*\u0011A&L\u0001\u0004U>\u0014'B\u0001\u00180\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0014'\u0001\u0004f]\u001eLg.\u001a\u0006\u0003eM\nQa[=mS:T!\u0001N\u001b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0014aA8sO\u000e\u00011C\u0001\u0001:!\tQ4(D\u0001(\u0013\tatE\u0001\bGY\u0006$H+\u00192mKN#\u0018mZ3\u0002\u0015)|'mQ8oi\u0016DH\u000f\u0005\u0002@\u00016\t1&\u0003\u0002BW\tQ1+Z4nK:$(j\u001c2\u0002\u0017\u0011\fG/Y*fO6,g\u000e\u001e\t\u0003\t.k\u0011!\u0012\u0006\u0003\r\u001e\u000bQ!\\8eK2T!\u0001S%\u0002\t\r,(-\u001a\u0006\u0003\u0015F\n\u0001\"\\3uC\u0012\fG/Y\u0005\u0003\u0019\u0016\u0013AB\u0014#bi\u0006\u001cVmZ7f]R\fa\u0001]1sC6\u001c\bCA(Q\u001b\u0005I\u0013BA)*\u0005A\u0001\u0016M]1n!J|\u0007/Y4bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0005)V3v\u000b\u0005\u0002;\u0001!)Q\b\u0002a\u0001}!)!\t\u0002a\u0001\u0007\")Q\n\u0002a\u0001\u001d\u0006\u0011B-\u0019;b\u0007>,h\u000e^\"iK\u000e\\wi\\8e+\u0005Q\u0006CA._\u001b\u0005a&\"A/\u0002\u000bM\u001c\u0017\r\\1\n\u0005}c&a\u0002\"p_2,\u0017M\\\u0001\u0017I\u0006$\u0018mQ8v]R\u001c\u0005.Z2l\u000f>|Gm\u0018\u0013fcR\u0011!-\u001a\t\u00037\u000eL!\u0001\u001a/\u0003\tUs\u0017\u000e\u001e\u0005\bM\u001a\t\t\u00111\u0001[\u0003\rAH%M\u0001\u0014I\u0006$\u0018mQ8v]R\u001c\u0005.Z2l\u000f>|G\rI\u0001\bKb,7-\u001e;f)\u0005\u0011\u0017AE2iK\u000e\\G)\u0019;b\u0007>,h\u000e\u001e)bgN$\u0012AW\u0001\u000fG\",7m\u001b#bi\u0006\u001cu.\u001e8u\u0003Ia\u0017-_8vi\u000e{WO\u001c;SK\u0012,8-\u001a:\u0015\u0007=\f9\u0002\u0006\u0002qgB\u00111,]\u0005\u0003er\u0013A\u0001T8oO\")Ao\u0003a\u0001k\u00061a-\u001b7uKJ\u0004Ba\u0017<y5&\u0011q\u000f\u0018\u0002\n\rVt7\r^5p]F\u0002\"!\u001f\f\u000e\u0003\u0001\u0011A\u0003R1uC\u000e{WO\u001c;DQ\u0016\u001c7NU3tk2$8C\u0001\f}!\tYV0\u0003\u0002\u007f9\n1\u0011I\\=SK\u001a\fa\u0001\\1z_V$XCAA\u0002!\r!\u0015QA\u0005\u0004\u0003\u000f)%\u0001\u0004'bs>,H/\u00128uSRL\u0018a\u00027bs>,H\u000fI\u0001\u0006G>,h\u000e^\u000b\u0002a\u000611m\\;oi\u0002\"R\u0001_A\n\u0003+Aaa`\u000eA\u0002\u0005\r\u0001BBA\u00067\u0001\u0007\u0001\u000fC\u0004\u0002\u001a-\u0001\r!a\u0007\u0002\u000fI,7/\u001e7ugB)\u0011QDA\u0017q:!\u0011qDA\u0015\u001d\u0011\t\t#a\n\u000e\u0005\u0005\r\"bAA\u0013o\u00051AH]8pizJ\u0011!X\u0005\u0004\u0003Wa\u0016a\u00029bG.\fw-Z\u0005\u0005\u0003_\t\tD\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\tY\u0003X\u0001'IJ\f\u0017N\\#naRLH*Y=pkR|e\u000eR1uC\u000e{WO\u001c;DQ\u0016\u001c7NR1jY\u0016$\u0017\u0001D4fiN#\u0018mZ3OC6,WCAA\u001d!\u0011\tY$a\u0011\u000f\t\u0005u\u0012q\b\t\u0004\u0003Ca\u0016bAA!9\u00061\u0001K]3eK\u001aLA!!\u0012\u0002H\t11\u000b\u001e:j]\u001eT1!!\u0011]\u0003=ygn\u0015;bO\u00164\u0015N\\5tQ\u0016$Gc\u00012\u0002N!I\u0011q\n\b\u0011\u0002\u0003\u0007\u0011\u0011K\u0001\u0006gR\fG/\u001a\t\u0005\u0003'\nY&\u0004\u0002\u0002V)!\u0011qKA-\u0003%)\u00070Z2vi&|gN\u0003\u0002-c%!\u0011QLA+\u0005=)\u00050Z2vi\u0006\u0014G.Z*uCR,'A\u0005#bi\u0006\u001cu.\u001e8u\u0007\",7m\u001b+bg.\u001cBa\u0004?\u0002dA\u0019\u00110!\u001a\n\t\u0005\u001d\u0014\u0011\u000e\u0002\u0005)\u0006\u001c8.C\u0002\u0002l-\u00121bU3h[\u0016tG/\u0012=fG\u0006\u0011Am]\u000b\u0003\u0003c\u0002b!a\u001d\u0002|\u0005}TBAA;\u0015\u0011\t9(!\u001f\u0002\u0007M\fHN\u0003\u0002/g%!\u0011QPA;\u0005\u001d!\u0015\r^1tKR\u0004B!a\u001d\u0002\u0002&!\u00111QA;\u0005\r\u0011vn^\u0001\u0004IN\u0004CCBAE\u0003\u0017\u000bi\t\u0005\u0002z\u001f!1q\u0010\u0006a\u0001\u0003\u0007Aq!!\u001c\u0015\u0001\u0004\t\t(A\u0006hKR$\u0016m]6EKN\u001c\u0017\u0001F'bi\u0016\u0014\u0018.\u00197ju\u00164E.\u0019;UC\ndW\r\u0005\u0002;;M\u0011Q\u0004 \u000b\u0003\u0003'\u000b\u0001#\u00138wC2LGmQ8v]R4E.Y4\u0002#%sg/\u00197jI\u000e{WO\u001c;GY\u0006<\u0007%A\nMCf|W\u000f\u001e(p]\u0016C\u0018n\u001d;t\r2\fw-\u0001\u000bMCf|W\u000f\u001e(p]\u0016C\u0018n\u001d;t\r2\fw\rI\u0001\u000fSNLeN^1mS\u0012\u001cu.\u001e8u)\rQ\u0016Q\u0015\u0005\u0007\u0003\u0017\u0019\u0003\u0019\u00019\u0002\u001d%\u001cH*Y=pkR,\u00050[:ugR\u0019!,a+\t\r\u0005-A\u00051\u0001q\u0003A\u0011w\u000e\u001e5MCf|W\u000f^:Fq&\u001cH\u000fF\u0003[\u0003c\u000b)\f\u0003\u0004\u00024\u0016\u0002\r\u0001]\u0001\u000fC\u001e<G*Y=pkR\u001cu.\u001e8u\u0011\u0019\t9,\na\u0001a\u0006\u0001B/\u00192mK2\u000b\u0017p\\;u\u0007>,h\u000e\u001e")
public class MaterializeFlatTable
extends FlatTableStage {
    private final SegmentJob jobContext;
    private final NDataSegment dataSegment;
    private final ParamPropagation params;
    private boolean dataCountCheckGood;

    public static boolean bothLayoutsExist(long l, long l2) {
        return MaterializeFlatTable$.MODULE$.bothLayoutsExist(l, l2);
    }

    public static boolean isLayoutExists(long l) {
        return MaterializeFlatTable$.MODULE$.isLayoutExists(l);
    }

    public static boolean isInvalidCount(long l) {
        return MaterializeFlatTable$.MODULE$.isInvalidCount(l);
    }

    public static long LayoutNonExistsFlag() {
        return MaterializeFlatTable$.MODULE$.LayoutNonExistsFlag();
    }

    public static long InvalidCountFlag() {
        return MaterializeFlatTable$.MODULE$.InvalidCountFlag();
    }

    private boolean dataCountCheckGood() {
        return this.dataCountCheckGood;
    }

    private void dataCountCheckGood_$eq(boolean x$1) {
        this.dataCountCheckGood = x$1;
    }

    @Override
    public void execute() {
        this.params.setFlatTable(this.createFlatTable());
        this.params.setLightFlatTable(this.createLightFlatTable());
        this.params.setFlatTableStage(this);
        if (!this.checkDataCountPass()) {
            this.drainEmptyLayoutOnDataCountCheckFailed();
            return;
        }
    }

    private boolean checkDataCountPass() {
        if (this.jobContext.getConfig().isDataCountCheckEnabled()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("segment ").append($this.dataSegment.getId()).append(" dataCountCheck is enabled").toString());
            boolean result = this.checkDataCount();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("segment ").append($this.dataSegment.getId()).append(" dataCountCheck result: ").append(result).toString());
            return result;
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("segment ").append($this.dataSegment.getId()).append(" dataCountCheck is not enabled").toString());
        return true;
    }

    private boolean checkDataCount() {
        boolean bl;
        long layoutCount;
        Buffer layouts = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.dataSegment.getSegDetails().getEffectiveLayouts()).asScala()).map((Function1 & Serializable & scala.Serializable)lay -> $this.jobContext.getIndexPlan().getLayoutEntity(Predef$.MODULE$.long2Long(lay.getLayoutId())), Buffer$.MODULE$.canBuildFrom());
        Buffer tasks = (Buffer)layouts.map((Function1 & Serializable & scala.Serializable)layout -> new DataCountCheckTask(this, (LayoutEntity)layout, (Dataset<Row>)StorageStoreUtils$.MODULE$.toDF($this.dataSegment, layout, this.sparkSession())), Buffer$.MODULE$.canBuildFrom());
        LinkedBlockingQueue resultsQueue = Queues.newLinkedBlockingQueue();
        if (layouts.isEmpty()) {
            return true;
        }
        this.slowStartExec(tasks.iterator(), (Function1 & Serializable & scala.Serializable)task -> {
            MaterializeFlatTable.$anonfun$checkDataCount$3(this, resultsQueue, task);
            return BoxedUnit.UNIT;
        });
        Iterable iterable = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)resultsQueue).asScala();
        Function1 & Serializable & scala.Serializable reduceFor = (Function1 & Serializable & scala.Serializable)filter -> BoxesRunTime.boxToLong((long)this.layoutCountReducer((Iterable<DataCountCheckResult>)iterable, (Function1<DataCountCheckResult, Object>)filter));
        long aggLayoutCount = BoxesRunTime.unboxToLong((Object)reduceFor.apply((Function1 & Serializable & scala.Serializable)result -> BoxesRunTime.boxToBoolean((boolean)MaterializeFlatTable.$anonfun$checkDataCount$5(result))));
        long tableLayoutCount = BoxesRunTime.unboxToLong((Object)reduceFor.apply((Function1 & Serializable & scala.Serializable)result -> BoxesRunTime.boxToBoolean((boolean)MaterializeFlatTable.$anonfun$checkDataCount$6(result))));
        if (MaterializeFlatTable$.MODULE$.isInvalidCount(aggLayoutCount) || MaterializeFlatTable$.MODULE$.isInvalidCount(tableLayoutCount)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(140).append("segment ").append($this.dataSegment.getId()).append(" dataCountCheck check1 failed, ").append("count number in agg layouts or table layouts are not same, ").append("agg layouts count: ").append(aggLayoutCount).append(", table layouts count: ").append(tableLayoutCount).toString());
            return false;
        }
        if (MaterializeFlatTable$.MODULE$.bothLayoutsExist(aggLayoutCount, tableLayoutCount) && aggLayoutCount != tableLayoutCount && !this.config().isNonStrictCountCheckAllowed()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(146).append("segment ").append($this.dataSegment.getId()).append(" dataCountCheck check1 failed, ").append("count number between agg layouts and table layouts are not same, ").append("agg layouts count: ").append(aggLayoutCount).append(", table layouts count: ").append(tableLayoutCount).toString());
            return false;
        }
        long l = layoutCount = MaterializeFlatTable$.MODULE$.isLayoutExists(aggLayoutCount) ? aggLayoutCount : tableLayoutCount;
        if (MaterializeFlatTable$.MODULE$.isLayoutExists(layoutCount) && this.params.getSpanningTree().fromFlatTable()) {
            boolean check2Result;
            long flatTableCount = this.params.getFlatTable().count();
            boolean bl2 = check2Result = layoutCount == flatTableCount;
            if (!check2Result) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("segment ").append($this.dataSegment.getId()).append(" dataCountCheck check2 failed, ").append("layouts count: ").append(layoutCount).append(", flat table count: ").append(flatTableCount).toString());
            }
            bl = check2Result;
        } else {
            bl = true;
        }
        return bl;
    }

    private long layoutCountReducer(Iterable<DataCountCheckResult> results, Function1<DataCountCheckResult, Object> filter) {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)results.filter(filter)).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.count()), Iterable$.MODULE$.canBuildFrom())).reduceOption((Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(prev, cur) -> prev == cur ? cur : MaterializeFlatTable$.MODULE$.InvalidCountFlag()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> MaterializeFlatTable$.MODULE$.LayoutNonExistsFlag()));
    }

    private void drainEmptyLayoutOnDataCountCheckFailed() {
        this.dataCountCheckGood_$eq(false);
        this.jobContext.setSkipFollowingStages(this.dataSegment.getId());
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.readOnlyLayouts()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            this.newEmptyDataLayout(x$2, NDataLayout.AbnormalType.DATA_INCONSISTENT);
            return BoxedUnit.UNIT;
        });
        this.drain(this.drain$default$1(), this.drain$default$2());
    }

    @Override
    public String getStageName() {
        return "MaterializeFlatTable";
    }

    @Override
    public void onStageFinished(ExecutableState state) {
        if (this.dataCountCheckGood()) {
            StageExec.onStageFinished$(this, state);
        } else {
            this.updateStageInfo(ExecutableState.WARNING.toString(), null, Maps.newHashMap((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"warning_code"), (Object)NDataLayout.AbnormalType.DATA_INCONSISTENT.name())}))).asJava())));
        }
    }

    public static final /* synthetic */ void $anonfun$checkDataCount$3(MaterializeFlatTable $this, LinkedBlockingQueue resultsQueue$1, DataCountCheckTask task) {
        LayoutEntity layout = task.layout();
        Dataset<Row> ds = task.ds();
        resultsQueue$1.offer(new DataCountCheckResult($this, layout, SanityChecker$.MODULE$.getCount(ds, layout)));
    }

    public static final /* synthetic */ boolean $anonfun$checkDataCount$5(DataCountCheckResult result) {
        return !IndexEntity.isTableIndex((long)result.layout().getId());
    }

    public static final /* synthetic */ boolean $anonfun$checkDataCount$6(DataCountCheckResult result) {
        return IndexEntity.isTableIndex((long)result.layout().getId());
    }

    public MaterializeFlatTable(SegmentJob jobContext, NDataSegment dataSegment, ParamPropagation params) {
        this.jobContext = jobContext;
        this.dataSegment = dataSegment;
        this.params = params;
        super(jobContext, dataSegment, params);
        this.dataCountCheckGood = true;
    }

    public class DataCountCheckResult {
        private final LayoutEntity layout;
        private final long count;
        public final /* synthetic */ MaterializeFlatTable $outer;

        public LayoutEntity layout() {
            return this.layout;
        }

        public long count() {
            return this.count;
        }

        public /* synthetic */ MaterializeFlatTable org$apache$kylin$engine$spark$job$step$build$MaterializeFlatTable$DataCountCheckResult$$$outer() {
            return this.$outer;
        }

        public DataCountCheckResult(MaterializeFlatTable $outer, LayoutEntity layout, long count) {
            this.layout = layout;
            this.count = count;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public class DataCountCheckTask
    implements SegmentExec.Task {
        private final LayoutEntity layout;
        private final Dataset<Row> ds;
        public final /* synthetic */ MaterializeFlatTable $outer;

        public LayoutEntity layout() {
            return this.layout;
        }

        public Dataset<Row> ds() {
            return this.ds;
        }

        @Override
        public String getTaskDesc() {
            return new StringBuilder(24).append("layout ").append(this.layout().getId()).append(" data count check").toString();
        }

        public /* synthetic */ MaterializeFlatTable org$apache$kylin$engine$spark$job$step$build$MaterializeFlatTable$DataCountCheckTask$$$outer() {
            return this.$outer;
        }

        public DataCountCheckTask(MaterializeFlatTable $outer, LayoutEntity layout, Dataset<Row> ds) {
            this.layout = layout;
            this.ds = ds;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

