/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.planner;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.kylin.engine.spark.planner.TupleCountCounter;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.hash.HashFunction;
import org.apache.kylin.guava30.shaded.common.hash.Hasher;
import org.apache.kylin.guava30.shaded.common.hash.Hashing;
import org.apache.kylin.measure.hllc.HLLCounter;
import org.apache.kylin.measure.hllc.RegisterType;
import org.apache.spark.sql.Row;

public class HLLCountCounter {
    public static final int HLL = 1;
    public static final int PLAIN = 0;
    public static final int DEFAULT_BUFFER_SIZE = 131072;
    public static final int DEFAULT_PRECISION = 14;
    private final HashFunction hf = Hashing.murmur3_128();
    private final List<TupleCountCounter> counterList;

    public HLLCountCounter(int precision, Map<BitSet, List<Integer>> cuboidIndexMap) {
        this.counterList = (List)cuboidIndexMap.entrySet().stream().map(e -> new TupleCountCounter((BitSet)e.getKey(), (List)e.getValue(), new HLLCounter(precision, RegisterType.DENSE))).collect(ImmutableList.toImmutableList());
    }

    public void readRow(Row row) {
        if (row == null) {
            return;
        }
        HashMap columnCache = Maps.newHashMap();
        for (TupleCountCounter counter : this.counterList) {
            counter.accumulate(counter.indexList().stream().map(index -> columnCache.computeIfAbsent(index, i -> this.hashLong(row.get(i.intValue())) + (long)i.intValue())).reduce(0L, Long::sum));
        }
    }

    public Iterator<TupleCountCounter> counterIterator() {
        return this.counterList.iterator();
    }

    private long hashLong(Object value) {
        Hasher hasher = this.hf.newHasher();
        if (value == null) {
            hasher.putInt(0);
        } else {
            hasher.putString((CharSequence)value.toString(), StandardCharsets.UTF_8);
        }
        return hasher.hash().asLong();
    }

    public static long readCount(byte[] bytes, int precision) throws IOException {
        int flag = HLLCountCounter.readFlag(bytes);
        switch (flag) {
            case 0: {
                return HLLCountCounter.readPlainCount(bytes);
            }
            case 1: {
                return HLLCountCounter.readHllCounter(bytes, precision).getCountEstimate();
            }
        }
        throw new IllegalArgumentException("Unknown bytes flag " + flag);
    }

    public static int readFlag(byte[] bytes) {
        return ByteBuffer.wrap(bytes, bytes.length - 4, 4).getInt();
    }

    public static long readPlainCount(byte[] bytes) {
        return ByteBuffer.wrap(bytes, 0, bytes.length - 4).getLong();
    }

    public static HLLCounter readHllCounter(byte[] bytes, int precision) throws IOException {
        HLLCounter hll = new HLLCounter(precision);
        ByteBuffer buffer = ByteBuffer.wrap(bytes, 0, bytes.length - 4);
        hll.readRegisters(buffer);
        return hll;
    }

    public static byte[] plainBytes(long count) {
        ByteBuffer buffer = ByteBuffer.allocate(12);
        buffer.putLong(count);
        buffer.putInt(0);
        return HLLCountCounter.copyBytes(buffer);
    }

    public static byte[] hllBytes(HLLCounter hll) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(131072);
        hll.writeRegisters(buffer);
        buffer.putInt(1);
        return HLLCountCounter.copyBytes(buffer);
    }

    private static byte[] copyBytes(ByteBuffer buffer) {
        byte[] bytes = new byte[buffer.position()];
        System.arraycopy(buffer.array(), 0, bytes, 0, buffer.position());
        return bytes;
    }
}

