/*
 * Decompiled with CFR 0.152.
 */
package io.kyligence.config.external.loader;

import com.alibaba.cloud.nacos.NacosConfigProperties;
import com.alibaba.nacos.api.config.ConfigFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.ConfigType;
import com.alibaba.nacos.api.config.listener.AbstractListener;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.utils.IoUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import io.kyligence.config.core.loader.IExternalConfigLoader;
import io.kyligence.config.external.http.NacosServerHttpAgent;
import io.kyligence.config.external.http.exception.KylinConfigException;
import io.kyligence.config.external.http.request.ActivateConfigRequest;
import io.kyligence.config.external.http.request.AppIntoRequest;
import io.kyligence.config.external.http.request.InitPropertiesRequest;
import io.kyligence.config.external.util.EnvUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class NacosExternalConfigLoader
implements IExternalConfigLoader {
    private static final Logger logger = LoggerFactory.getLogger(NacosExternalConfigLoader.class);
    public static final String BASE_CONFIG_URL = "/v1/cs";
    public static final String PUBLISH_CONFIG_LIBRARY_URL = "/v1/cs/configs/add-config-library";
    public static final String APP_INFO_REGISTER_URL = "/v1/cs/app-info";
    public static final String PUBLISH_INIT_PROPERTIES_URL = "/v1/cs/configs/init-config";
    public static final String ACTIVATE_CONFIG_URL = "/v1/cs/configs/publish-config";
    private final Map<String, String> dataIdContentMap = new LinkedHashMap<String, String>();
    private final Environment environment;
    private final ConfigService configService;
    private final NacosServerHttpAgent agent;
    private final String group;
    private final boolean autoRefresh;
    private final boolean needInit;
    private final List<String> dataIds;
    private final String initConfigContent;
    private final String configLibrary;
    private final ConfigType configPropertyFileType;
    private String app;
    private String zhName;
    private String enName;
    private boolean activateConfig;

    public void innerReceive(String config) {
    }

    public NacosExternalConfigLoader(Map<String, String> properties, NacosConfigProperties nacosConfigProperties, Environment environment) {
        try {
            this.configService = ConfigFactory.createConfigService((Properties)nacosConfigProperties.assembleConfigServiceProperties());
            this.agent = new NacosServerHttpAgent(nacosConfigProperties.assembleConfigServiceProperties());
            this.environment = environment;
        }
        catch (NacosException e) {
            throw new KylinConfigException(e);
        }
        this.app = this.resolveProperties(properties.get("app"));
        this.zhName = this.resolveProperties(properties.getOrDefault("zhName", this.app));
        this.enName = this.resolveProperties(properties.getOrDefault("enName", this.app));
        this.group = this.resolveProperties(properties.get("group"));
        this.dataIds = this.resolveProperties(properties.get("dataIds")) == null ? null : Arrays.stream(properties.get("dataIds").split(",")).map(String::trim).map(this::resolveProperties).collect(Collectors.toList());
        this.autoRefresh = Boolean.parseBoolean(this.resolveProperties(properties.getOrDefault("autoRefresh", "false")));
        this.needInit = Boolean.parseBoolean(this.resolveProperties(properties.getOrDefault("needInit", "false")));
        this.initConfigContent = this.resolveProperties(properties.get("initConfigContent"));
        this.configLibrary = this.resolveProperties(properties.get("configLibrary"));
        this.configPropertyFileType = this.resolveProperties(properties.get("configPropertyFileType")) == null ? ConfigType.PROPERTIES : ConfigType.valueOf((String)properties.get("configPropertyFileType"));
        this.activateConfig = Boolean.parseBoolean(this.resolveProperties(properties.getOrDefault("activateConfig", String.valueOf(false))));
        try {
            this.init();
        }
        catch (Exception e) {
            throw new KylinConfigException(e);
        }
    }

    private String getUniqueDataId() {
        return this.dataIds == null || this.dataIds.isEmpty() ? null : this.dataIds.get(this.dataIds.size() - 1);
    }

    private void init() throws Exception {
        logger.info("[NacosExternalConfigLoader] Init Nacos Config, app: {}, dataIds: {}, group: {}", new Object[]{this.app, this.dataIds, this.group});
        if (this.app == null || this.app.isEmpty() || this.dataIds.isEmpty() || this.group == null || this.group.isEmpty()) {
            return;
        }
        for (String dataId : this.dataIds) {
            this.dataIdContentMap.put(dataId, "");
        }
        this.registerAppInfo();
        if (this.needInit && EnvUtil.isNeedInitialized()) {
            this.publishConfigLibrary();
            this.publishInitConfig();
        }
        if (this.activateConfig) {
            this.activateConfig();
        }
        if (this.autoRefresh) {
            this.registerListener();
        }
        this.initFromNacos();
        logger.info("[NacosExternalConfigLoader] end init nacos config.");
    }

    private String getConfig(String dataId) {
        try {
            return this.configService.getConfig(dataId, this.group, 5000L);
        }
        catch (NacosException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void publish(String content) throws Exception {
        StringReader reader = new StringReader(content);
        Properties properties = new Properties();
        properties.load(reader);
        ArrayList<InitPropertiesRequest.ConfigItem> configItems = new ArrayList<InitPropertiesRequest.ConfigItem>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            InitPropertiesRequest.ConfigItem item = new InitPropertiesRequest.ConfigItem(this.getUniqueDataId(), this.group, (String)entry.getKey(), (String)entry.getValue());
            configItems.add(item);
        }
        InitPropertiesRequest request = new InitPropertiesRequest(this.getUniqueDataId(), this.group, configItems, true, false, "");
        this.agent.httpPostJson(PUBLISH_INIT_PROPERTIES_URL, request);
    }

    private void registerListener() throws NacosException {
        for (final String dataId : this.dataIds) {
            this.configService.addListener(dataId, this.group, (Listener)new AbstractListener(){

                public void receiveConfigInfo(String configInfo) {
                    if (configInfo != null) {
                        NacosExternalConfigLoader.this.dataIdContentMap.put(dataId, configInfo);
                        NacosExternalConfigLoader.this.innerReceive(NacosExternalConfigLoader.this.getConfig());
                    }
                }
            });
        }
    }

    private void registerAppInfo() {
        AppIntoRequest request = new AppIntoRequest(this.app, this.zhName, this.enName, this.group, this.getUniqueDataId());
        try {
            this.agent.httpPostJson(APP_INFO_REGISTER_URL, request);
        }
        catch (Exception e) {
            throw new KylinConfigException(e);
        }
    }

    private void publishConfigLibrary() throws Exception {
        if (this.configLibrary != null && !this.configLibrary.isEmpty()) {
            String content = IoUtils.toString((InputStream)Files.newInputStream(Paths.get(this.configLibrary, new String[0]), new OpenOption[0]), (String)"utf-8");
            this.publishConfigLibrary(content);
        }
    }

    private void activateConfig() throws Exception {
        ActivateConfigRequest request = new ActivateConfigRequest(this.getUniqueDataId(), this.group, true);
        this.agent.httpPostJson(ACTIVATE_CONFIG_URL, request);
    }

    private void publishInitConfig() throws Exception {
        String content = IoUtils.toString((InputStream)Files.newInputStream(Paths.get(this.initConfigContent, new String[0]), new OpenOption[0]), (String)"utf-8");
        if (content != null && !content.isEmpty()) {
            String config = this.getConfig(this.getUniqueDataId());
            if (config == null || config.isEmpty()) {
                logger.info("[NacosExternalConfigLoader] PublishInitConfig start publish init config.");
                this.publish(content);
            } else {
                logger.info("[NacosExternalConfigLoader] PublishInitConfig use remote config.");
            }
        }
    }

    private void initFromNacos() {
        Iterator<String> iterator = this.dataIds.iterator();
        while (iterator.hasNext()) {
            String dataId;
            String config = this.getConfig(dataId = iterator.next());
            this.dataIdContentMap.put(dataId, config == null ? "" : config);
        }
        this.innerReceive(this.getConfig());
    }

    public String getConfig() {
        String config = "";
        if (this.configPropertyFileType == ConfigType.PROPERTIES) {
            config = NacosExternalConfigLoader.mergeProperties(new ArrayList<String>(this.dataIdContentMap.values()));
        } else if (this.configPropertyFileType == ConfigType.JSON) {
            config = NacosExternalConfigLoader.mergeJson(new ArrayList<String>(this.dataIdContentMap.values()));
        }
        return config;
    }

    private void publishConfigLibrary(String configLibraries) throws Exception {
        ArrayList configLibraryModelList = new ArrayList();
        String[] configLibraryArray = configLibraries.split("\n");
        HashMap body = new HashMap();
        for (int i = 1; i < configLibraryArray.length; ++i) {
            String configLibraryItem = configLibraryArray[i];
            HashMap<String, String> configLibraryMap = new HashMap<String, String>();
            String[] configItemLibraryArray = configLibraryItem.split(",(?=(?:[^\\\"]*\\\"[^\\\"]*\\\")*[^\\\"]*$)");
            configLibraryMap.put("dataId", this.getUniqueDataId());
            configLibraryMap.put("groupId", this.group);
            configLibraryMap.put("paramName", configItemLibraryArray[0]);
            configLibraryMap.put("paramType", configItemLibraryArray[1]);
            configLibraryMap.put("paramMeaningCn", configItemLibraryArray[2]);
            configLibraryMap.put("paramMeaningEn", configItemLibraryArray[3]);
            configLibraryMap.put("restartEffect", configItemLibraryArray[4]);
            configLibraryMap.put("systemScope", configItemLibraryArray[5]);
            configLibraryModelList.add(configLibraryMap);
        }
        body.put("configLibraryModelList", configLibraryModelList);
        this.agent.httpPostJson(PUBLISH_CONFIG_LIBRARY_URL, body);
    }

    private static String mergeProperties(List<String> contents) {
        return contents.stream().collect(Collectors.joining(System.lineSeparator()));
    }

    private static String mergeJson(List<String> jsons) {
        String result = "";
        if (jsons == null || jsons.isEmpty()) {
            return result;
        }
        if (jsons.size() == 1) {
            return jsons.get(0);
        }
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode jsonNode = objectMapper.readTree(jsons.get(0));
            for (int i = 1; i < jsons.size(); ++i) {
                ObjectReader objectReader = objectMapper.readerForUpdating((Object)jsonNode);
                jsonNode = (JsonNode)objectReader.readValue(jsons.get(i));
            }
            return jsonNode.toPrettyString();
        }
        catch (JsonProcessingException jsonProcessingException) {
            return result;
        }
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        switch (this.configPropertyFileType) {
            case PROPERTIES: {
                StringReader reader = new StringReader(this.getConfig());
                try {
                    properties.load(reader);
                    break;
                }
                catch (IOException e) {
                    throw new KylinConfigException(e);
                }
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return properties;
    }

    public String getProperty(String key) {
        return this.getProperties().getProperty(key);
    }

    private String resolveProperties(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return value;
        }
        return this.environment.resolvePlaceholders(value);
    }
}

