/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.core;

import io.github.resilience4j.core.IntervalFunctionCompanion;
import io.vavr.collection.Stream;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;

@FunctionalInterface
public interface IntervalFunction
extends Function<Integer, Long> {
    public static final long DEFAULT_INITIAL_INTERVAL = 500L;
    public static final double DEFAULT_MULTIPLIER = 1.5;
    public static final double DEFAULT_RANDOMIZATION_FACTOR = 0.5;

    public static IntervalFunction ofDefaults() {
        return IntervalFunction.of(500L);
    }

    public static IntervalFunction of(long intervalMillis, Function<Long, Long> backoffFunction) {
        IntervalFunctionCompanion.checkInterval(intervalMillis);
        Objects.requireNonNull(backoffFunction);
        return attempt -> {
            IntervalFunctionCompanion.checkAttempt(attempt.intValue());
            return (Long)Stream.iterate((Object)intervalMillis, (Function)backoffFunction).get(attempt - 1);
        };
    }

    public static IntervalFunction of(Duration interval, Function<Long, Long> backoffFunction) {
        return IntervalFunction.of(interval.toMillis(), backoffFunction);
    }

    public static IntervalFunction of(long intervalMillis) {
        IntervalFunctionCompanion.checkInterval(intervalMillis);
        return attempt -> {
            IntervalFunctionCompanion.checkAttempt(attempt.intValue());
            return intervalMillis;
        };
    }

    public static IntervalFunction of(Duration interval) {
        return IntervalFunction.of(interval.toMillis());
    }

    public static IntervalFunction ofRandomized(long intervalMillis, double randomizationFactor) {
        IntervalFunctionCompanion.checkInterval(intervalMillis);
        IntervalFunctionCompanion.checkRandomizationFactor(randomizationFactor);
        return attempt -> {
            IntervalFunctionCompanion.checkAttempt(attempt.intValue());
            return (long)IntervalFunctionCompanion.randomize(intervalMillis, randomizationFactor);
        };
    }

    public static IntervalFunction ofRandomized(Duration interval, double randomizationFactor) {
        return IntervalFunction.ofRandomized(interval.toMillis(), randomizationFactor);
    }

    public static IntervalFunction ofRandomized(long interval) {
        return IntervalFunction.ofRandomized(interval, 0.5);
    }

    public static IntervalFunction ofRandomized(Duration interval) {
        return IntervalFunction.ofRandomized(interval.toMillis(), 0.5);
    }

    public static IntervalFunction ofRandomized() {
        return IntervalFunction.ofRandomized(500L, 0.5);
    }

    public static IntervalFunction ofExponentialBackoff(long initialIntervalMillis, double multiplier, long maxIntervalMillis) {
        IntervalFunctionCompanion.checkInterval(maxIntervalMillis);
        return attempt -> {
            IntervalFunctionCompanion.checkAttempt(attempt.intValue());
            long interval = (Long)IntervalFunction.ofExponentialBackoff(initialIntervalMillis, multiplier).apply(attempt);
            return Math.min(interval, maxIntervalMillis);
        };
    }

    public static IntervalFunction ofExponentialBackoff(Duration initialInterval, double multiplier, Duration maxInterval) {
        return IntervalFunction.ofExponentialBackoff(initialInterval.toMillis(), multiplier, maxInterval.toMillis());
    }

    public static IntervalFunction ofExponentialBackoff(long initialIntervalMillis, double multiplier) {
        IntervalFunctionCompanion.checkMultiplier(multiplier);
        return IntervalFunction.of(initialIntervalMillis, (Long x) -> (long)((double)x.longValue() * multiplier));
    }

    public static IntervalFunction ofExponentialBackoff(Duration initialInterval, double multiplier) {
        return IntervalFunction.ofExponentialBackoff(initialInterval.toMillis(), multiplier);
    }

    public static IntervalFunction ofExponentialBackoff(long initialIntervalMillis) {
        return IntervalFunction.ofExponentialBackoff(initialIntervalMillis, 1.5);
    }

    public static IntervalFunction ofExponentialBackoff(Duration initialInterval) {
        return IntervalFunction.ofExponentialBackoff(initialInterval.toMillis(), 1.5);
    }

    public static IntervalFunction ofExponentialBackoff() {
        return IntervalFunction.ofExponentialBackoff(500L, 1.5);
    }

    public static IntervalFunction ofExponentialRandomBackoff(long initialIntervalMillis, double multiplier, double randomizationFactor, long maxIntervalMillis) {
        IntervalFunctionCompanion.checkInterval(maxIntervalMillis);
        return attempt -> {
            IntervalFunctionCompanion.checkAttempt(attempt.intValue());
            long interval = (Long)IntervalFunction.ofExponentialRandomBackoff(initialIntervalMillis, multiplier, randomizationFactor).apply(attempt);
            return Math.min(interval, maxIntervalMillis);
        };
    }

    public static IntervalFunction ofExponentialRandomBackoff(long initialIntervalMillis, double multiplier, double randomizationFactor) {
        IntervalFunctionCompanion.checkInterval(initialIntervalMillis);
        IntervalFunctionCompanion.checkMultiplier(multiplier);
        IntervalFunctionCompanion.checkRandomizationFactor(randomizationFactor);
        return attempt -> {
            IntervalFunctionCompanion.checkAttempt(attempt.intValue());
            long interval = (Long)IntervalFunction.of(initialIntervalMillis, (Long x) -> (long)((double)x.longValue() * multiplier)).apply(attempt);
            return (long)IntervalFunctionCompanion.randomize(interval, randomizationFactor);
        };
    }

    public static IntervalFunction ofExponentialRandomBackoff(Duration initialInterval, double multiplier, double randomizationFactor, Duration maxInterval) {
        return IntervalFunction.ofExponentialRandomBackoff(initialInterval.toMillis(), multiplier, randomizationFactor, maxInterval.toMillis());
    }

    public static IntervalFunction ofExponentialRandomBackoff(Duration initialInterval, double multiplier, double randomizationFactor) {
        return IntervalFunction.ofExponentialRandomBackoff(initialInterval.toMillis(), multiplier, randomizationFactor);
    }

    public static IntervalFunction ofExponentialRandomBackoff(long initialIntervalMillis, double multiplier, long maxIntervalMillis) {
        return IntervalFunction.ofExponentialRandomBackoff(initialIntervalMillis, multiplier, 0.5, maxIntervalMillis);
    }

    public static IntervalFunction ofExponentialRandomBackoff(long initialIntervalMillis, double multiplier) {
        return IntervalFunction.ofExponentialRandomBackoff(initialIntervalMillis, multiplier, 0.5);
    }

    public static IntervalFunction ofExponentialRandomBackoff(Duration initialInterval, double multiplier, Duration maxInterval) {
        return IntervalFunction.ofExponentialRandomBackoff(initialInterval.toMillis(), multiplier, 0.5, maxInterval.toMillis());
    }

    public static IntervalFunction ofExponentialRandomBackoff(Duration initialInterval, double multiplier) {
        return IntervalFunction.ofExponentialRandomBackoff(initialInterval.toMillis(), multiplier, 0.5);
    }

    public static IntervalFunction ofExponentialRandomBackoff(long initialIntervalMillis) {
        return IntervalFunction.ofExponentialRandomBackoff(initialIntervalMillis, 1.5);
    }

    public static IntervalFunction ofExponentialRandomBackoff(Duration initialInterval) {
        return IntervalFunction.ofExponentialRandomBackoff(initialInterval.toMillis(), 1.5);
    }

    public static IntervalFunction ofExponentialRandomBackoff() {
        return IntervalFunction.ofExponentialRandomBackoff(500L, 1.5, 0.5);
    }
}

