/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec.common;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.base.Throwables;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.rec.exception.ProposerJobException;

public class AccelerateInfo
implements Serializable {
    @JsonIgnore
    private static final Integer MAX_EXCEPTION_MSG_LEN = 4000;
    private Set<QueryLayoutRelation> relatedLayouts = Sets.newHashSet();
    private Throwable failedCause;
    private String pendingMsg;

    public boolean isFailed() {
        return this.failedCause != null;
    }

    public boolean isPending() {
        return StringUtils.isNotBlank((CharSequence)this.pendingMsg);
    }

    public boolean isNotSucceed() {
        return this.isPending() || this.isFailed();
    }

    public static Throwable transformThrowable(Throwable throwable) {
        if (Objects.isNull(throwable)) {
            return null;
        }
        Throwable rootCause = Throwables.getRootCause((Throwable)throwable);
        if (StringUtils.length((CharSequence)rootCause.getMessage()) <= MAX_EXCEPTION_MSG_LEN) {
            return rootCause;
        }
        String subMsg = StringUtils.substring((String)rootCause.getMessage(), (int)0, (int)MAX_EXCEPTION_MSG_LEN);
        return new ProposerJobException(subMsg);
    }

    @Generated
    public void setRelatedLayouts(Set<QueryLayoutRelation> relatedLayouts) {
        this.relatedLayouts = relatedLayouts;
    }

    @Generated
    public void setFailedCause(Throwable failedCause) {
        this.failedCause = failedCause;
    }

    @Generated
    public void setPendingMsg(String pendingMsg) {
        this.pendingMsg = pendingMsg;
    }

    @Generated
    public Set<QueryLayoutRelation> getRelatedLayouts() {
        return this.relatedLayouts;
    }

    @Generated
    public Throwable getFailedCause() {
        return this.failedCause;
    }

    @Generated
    public String getPendingMsg() {
        return this.pendingMsg;
    }

    @Generated
    public String toString() {
        return "AccelerateInfo(relatedLayouts=" + this.getRelatedLayouts() + ", failedCause=" + this.getFailedCause() + ", pendingMsg=" + this.getPendingMsg() + ")";
    }

    public static class QueryLayoutRelation
    implements Serializable {
        @JsonIgnore
        private String sql;
        private String modelId;
        private long layoutId;
        private int semanticVersion;

        public String getUniqueId() {
            return this.modelId + "@" + this.layoutId;
        }

        public boolean consistent(LayoutEntity layout) {
            Preconditions.checkNotNull((Object)layout);
            return this.semanticVersion == layout.getModel().getSemanticVersion() && this.modelId.equalsIgnoreCase(layout.getModel().getId()) && this.layoutId == layout.getId();
        }

        @Generated
        public String getSql() {
            return this.sql;
        }

        @Generated
        public String getModelId() {
            return this.modelId;
        }

        @Generated
        public long getLayoutId() {
            return this.layoutId;
        }

        @Generated
        public int getSemanticVersion() {
            return this.semanticVersion;
        }

        @Generated
        public String toString() {
            return "AccelerateInfo.QueryLayoutRelation(modelId=" + this.getModelId() + ", layoutId=" + this.getLayoutId() + ", semanticVersion=" + this.getSemanticVersion() + ")";
        }

        @Generated
        public QueryLayoutRelation(String sql, String modelId, long layoutId, int semanticVersion) {
            this.sql = sql;
            this.modelId = modelId;
            this.layoutId = layoutId;
            this.semanticVersion = semanticVersion;
        }

        @Generated
        public QueryLayoutRelation() {
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QueryLayoutRelation)) {
                return false;
            }
            QueryLayoutRelation other = (QueryLayoutRelation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$sql = this.getSql();
            String other$sql = other.getSql();
            if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
                return false;
            }
            String this$modelId = this.getModelId();
            String other$modelId = other.getModelId();
            if (this$modelId == null ? other$modelId != null : !this$modelId.equals(other$modelId)) {
                return false;
            }
            if (this.getLayoutId() != other.getLayoutId()) {
                return false;
            }
            return this.getSemanticVersion() == other.getSemanticVersion();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof QueryLayoutRelation;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sql = this.getSql();
            result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
            String $modelId = this.getModelId();
            result = result * 59 + ($modelId == null ? 43 : $modelId.hashCode());
            long $layoutId = this.getLayoutId();
            result = result * 59 + (int)($layoutId >>> 32 ^ $layoutId);
            result = result * 59 + this.getSemanticVersion();
            return result;
        }

        @Generated
        public void setSql(String sql) {
            this.sql = sql;
        }

        @Generated
        public void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Generated
        public void setLayoutId(long layoutId) {
            this.layoutId = layoutId;
        }
    }
}

