/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec.model;

import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.util.ComputedColumnUtil;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.rec.AbstractContext;
import org.apache.kylin.rec.common.AccelerateInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractModelProposer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractModelProposer.class);
    protected AbstractContext.ModelContext modelContext;
    final String project;
    final NDataModelManager dataModelManager;

    AbstractModelProposer(AbstractContext.ModelContext modelCtx) {
        this.modelContext = modelCtx;
        this.project = modelCtx.getProposeContext().getProject();
        this.dataModelManager = NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.project);
    }

    public AbstractContext.ModelContext getModelContext() {
        return this.modelContext;
    }

    public NDataModel propose(NDataModel origModel) {
        NDataModel modelDesc;
        try {
            modelDesc = (NDataModel)JsonUtil.deepCopy((Object)origModel, NDataModel.class);
            modelDesc.setComputedColumnDescs(ComputedColumnUtil.deepCopy((List)origModel.getComputedColumnDescs()));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to deep copy model", e);
        }
        this.initModel(modelDesc);
        this.execute(modelDesc);
        this.initModel(modelDesc);
        return modelDesc;
    }

    void initModel(NDataModel modelDesc) {
        modelDesc.init(KylinConfig.getInstanceFromEnv(), this.project, (List)Lists.newArrayList());
    }

    boolean isValidOlapContext(OlapContext context) {
        AccelerateInfo accelerateInfo = this.modelContext.getProposeContext().getAccelerateInfoMap().get(context.getSql());
        return accelerateInfo != null && !accelerateInfo.isNotSucceed();
    }

    protected abstract void execute(NDataModel var1);
}

